/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.Freeze;
import com.intellij.diagnostic.FreezeProfiler;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeaFreezeReporter
implements IdePerformanceListener {
    private static final ExtensionPointName<FreezeProfiler> EP_NAME = new ExtensionPointName("com.intellij.diagnostic.freezeProfiler");
    private static final int FREEZE_THRESHOLD = ApplicationManager.getApplication().isInternal() ? 15 : 25;
    private static final String REPORT_PREFIX = "report";
    private static final String DUMP_PREFIX = "dump";
    private static final String MESSAGE_FILE_NAME = ".message";
    private static final String THROWABLE_FILE_NAME = ".throwable";
    public static final String APPINFO_FILE_NAME = ".appinfo";
    private static final double COMMON_SUB_STACK_WEIGHT = 0.25;
    private static boolean DEBUG = false;
    private SamplingTask myDumpTask;
    private final List<ThreadDump> myCurrentDumps = new ArrayList<ThreadDump>();
    private List<StackTraceElement> myStacktraceCommonPart = null;
    private volatile boolean myAppClosing;

    IdeaFreezeReporter() {
        Application app = ApplicationManager.getApplication();
        if (!DEBUG && PluginManagerCore.isRunningFromSources() || !app.isEAP() && !app.isInternal()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
        NonUrgentExecutor.getInstance().execute(() -> {
            app.getMessageBus().simpleConnect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                @Override
                public void appWillBeClosed(boolean isRestart) {
                    IdeaFreezeReporter.this.myAppClosing = true;
                }
            });
            PerformanceWatcher.getInstance().processUnfinishedFreeze((dir, duration) -> {
                block21: {
                    try {
                        File[] files2 = dir.listFiles();
                        if (files2 == null) break block21;
                        if (duration > FREEZE_THRESHOLD) {
                            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                            String message2 = null;
                            String appInfo = null;
                            Throwable throwable = null;
                            ArrayList<String> dumps = new ArrayList<String>();
                            for (File file2 : files2) {
                                String text2 = FileUtil.loadFile((File)file2);
                                String name = file2.getName();
                                if (MESSAGE_FILE_NAME.equals(name)) {
                                    message2 = text2;
                                    continue;
                                }
                                if (THROWABLE_FILE_NAME.equals(name)) {
                                    try (FileInputStream fis = new FileInputStream(file2);
                                         ObjectInputStream ois = new ObjectInputStream(fis);){
                                        throwable = (Throwable)ois.readObject();
                                    }
                                    catch (Exception exception) {}
                                    continue;
                                }
                                if (APPINFO_FILE_NAME.equals(name)) {
                                    appInfo = text2;
                                    continue;
                                }
                                if (name.startsWith(REPORT_PREFIX)) {
                                    attachments.add(IdeaFreezeReporter.createReportAttachment(duration.intValue(), text2));
                                    continue;
                                }
                                if (!name.startsWith("threadDump-")) continue;
                                dumps.add(text2);
                            }
                            IdeaFreezeReporter.addDumpsAttachments(dumps, Function.identity(), attachments);
                            EP_NAME.forEachExtensionSafe(p -> attachments.addAll(p.getAttachments((File)dir)));
                            if (message2 != null && throwable != null && !attachments.isEmpty()) {
                                IdeaLoggingEvent event = LogMessage.createEvent(throwable, message2, attachments.toArray(Attachment.EMPTY_ARRAY));
                                IdeaFreezeReporter.setAppInfo(event, appInfo);
                                IdeaFreezeReporter.report(event);
                            }
                        }
                        IdeaFreezeReporter.cleanup(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        });
    }

    static void setAppInfo(IdeaLoggingEvent event, String appInfo) {
        Object data2 = event.getData();
        if (data2 instanceof AbstractMessage) {
            ((AbstractMessage)data2).setAppInfo(appInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static Attachment createReportAttachment(long durationInSeconds, @NotNull String string) {
        void text2;
        if (string == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(0);
        }
        Attachment res2 = new Attachment("report-" + durationInSeconds + "s.txt", (String)text2);
        res2.setIncluded(true);
        Attachment attachment = res2;
        if (attachment == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(1);
        }
        return attachment;
    }

    private static <T> void addDumpsAttachments(List<T> from2, Function<? super T, String> textMapper, List<? super Attachment> container) {
        int size2 = Math.min(from2.size(), 20);
        int step2 = from2.size() / size2;
        for (int i2 = 0; i2 < size2; ++i2) {
            Attachment attachment = new Attachment("dump-" + i2 + ".txt", textMapper.apply(from2.get(i2 * step2)));
            attachment.setIncluded(true);
            container.add((Attachment)attachment);
        }
    }

    private static void cleanup(@Nullable File dir) {
        if (dir != null) {
            FileUtil.delete((File)new File(dir, MESSAGE_FILE_NAME));
            FileUtil.delete((File)new File(dir, THROWABLE_FILE_NAME));
            FileUtil.delete((File)new File(dir, APPINFO_FILE_NAME));
        }
    }

    public void uiFreezeStarted(@NotNull File reportDir) {
        if (reportDir == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(2);
        }
        if (DEBUG || !DebugAttachDetector.isAttached()) {
            if (this.myDumpTask != null) {
                this.myDumpTask.stop();
            }
            this.reset();
            this.myDumpTask = new SamplingTask(Registry.intValue((String)"freeze.reporter.dump.interval.ms"), Registry.intValue((String)"freeze.reporter.dump.duration.s") * 1000){

                @Override
                public void stop() {
                    super.stop();
                    EP_NAME.forEachExtensionSafe(FreezeProfiler::stop);
                }
            };
            EP_NAME.forEachExtensionSafe(p -> p.start(reportDir));
        }
    }

    public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump) {
        if (toFile == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(3);
        }
        if (dump == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(4);
        }
        if (this.myDumpTask != null) {
            this.myCurrentDumps.add(dump);
            Object[] edtStack = dump.getEDTStackTrace();
            if (edtStack != null) {
                this.myStacktraceCommonPart = this.myStacktraceCommonPart == null ? ContainerUtil.newArrayList((Object[])edtStack) : PerformanceWatcher.getStacktraceCommonPart(this.myStacktraceCommonPart, (StackTraceElement[])edtStack);
            }
            File dir = toFile.getParentFile();
            PerformanceWatcher performanceWatcher = PerformanceWatcher.getInstance();
            IdeaLoggingEvent event = this.createEvent(this.myDumpTask.getTotalTime() + (long)performanceWatcher.getUnresponsiveInterval(), Collections.emptyList(), dir, performanceWatcher, false);
            if (event != null) {
                try {
                    FileUtil.writeToFile((File)new File(dir, MESSAGE_FILE_NAME), (String)event.getMessage());
                    try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(dir, THROWABLE_FILE_NAME)));){
                        oos.writeObject(event.getThrowable());
                    }
                    IdeaFreezeReporter.saveAppInfo(dir.toPath().resolve(APPINFO_FILE_NAME), false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static void saveAppInfo(Path appInfoFile, boolean overwrite) throws IOException {
        if (overwrite || !Files.exists(appInfoFile, new LinkOption[0])) {
            Files.createDirectories(appInfoFile.getParent(), new FileAttribute[0]);
            Files.writeString(appInfoFile, (CharSequence)ITNProxy.getAppInfoString(), new OpenOption[0]);
        }
    }

    public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
        if (this.myDumpTask == null) {
            return;
        }
        this.myDumpTask.stop();
        ArrayList extraAttachments = new ArrayList();
        if (reportDir != null) {
            EP_NAME.forEachExtensionSafe(p -> extraAttachments.addAll(p.getAttachments(reportDir)));
        }
        IdeaFreezeReporter.cleanup(reportDir);
        if (Registry.is((String)"freeze.reporter.enabled")) {
            PerformanceWatcher performanceWatcher = PerformanceWatcher.getInstance();
            if ((int)(durationMs / 1000L) > FREEZE_THRESHOLD && !ContainerUtil.isEmpty(this.myStacktraceCommonPart)) {
                long dumpingDurationMs = durationMs - (long)performanceWatcher.getUnresponsiveInterval();
                long dumpsCount = Math.min((long)performanceWatcher.getMaxDumpDuration(), dumpingDurationMs / 2L) / (long)performanceWatcher.getDumpInterval();
                if (this.myDumpTask.isValid(dumpingDurationMs) || (long)this.myCurrentDumps.size() >= Math.max(3L, dumpsCount)) {
                    ArrayList attachments = new ArrayList();
                    IdeaFreezeReporter.addDumpsAttachments(this.myCurrentDumps, ThreadDump::getRawDump, attachments);
                    attachments.addAll(extraAttachments);
                    IdeaFreezeReporter.report(this.createEvent(durationMs, attachments, reportDir, performanceWatcher, true));
                }
            }
        }
        this.myDumpTask = null;
        this.reset();
    }

    static void report(IdeaLoggingEvent event) {
        Throwable t;
        if (event != null && IdeErrorsDialog.getSubmitter(t = event.getThrowable(), PluginUtil.getInstance().findPluginId(t)) instanceof ITNReporter) {
            MessagePool.getInstance().addIdeFatalMessage(event);
        }
    }

    private void reset() {
        this.myCurrentDumps.clear();
        this.myStacktraceCommonPart = null;
    }

    private static ThreadInfo getCauseThread(ThreadInfo[] threadInfos) {
        ThreadDumper.sort((ThreadInfo[])threadInfos);
        ThreadInfo edt = (ThreadInfo)ContainerUtil.find((Object[])threadInfos, ThreadDumper::isEDT);
        if (edt != null && edt.getThreadState() != Thread.State.RUNNABLE) {
            String lockName;
            long id2 = edt.getLockOwnerId();
            if (id2 != -1L) {
                for (ThreadInfo info2 : threadInfos) {
                    if (info2.getThreadId() != id2) continue;
                    return info2;
                }
            }
            if ((lockName = edt.getLockName()) != null && lockName.contains("ReadMostlyRWLock")) {
                ThreadInfo readLockNotRunnable = null;
                for (ThreadInfo info3 : threadInfos) {
                    if (!IdeaFreezeReporter.isWithReadLock(info3)) continue;
                    if (info3.getThreadState() == Thread.State.RUNNABLE) {
                        return info3;
                    }
                    if (readLockNotRunnable != null) continue;
                    readLockNotRunnable = info3;
                }
                if (readLockNotRunnable != null) {
                    return readLockNotRunnable;
                }
            }
        }
        return edt;
    }

    private static boolean isWithReadLock(ThreadInfo thread2) {
        boolean read = false;
        for (StackTraceElement s : thread2.getStackTrace()) {
            String methodName = s.getMethodName();
            if ("runReadAction".equals(methodName) || "tryRunReadAction".equals(methodName) || "insideReadAction".equals(methodName)) {
                read = true;
            }
            if (!"waitABit".equals(methodName)) continue;
            return false;
        }
        return read;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private IdeaLoggingEvent createEvent(long duration, @NotNull List<? extends Attachment> attachments, @Nullable File reportDir, @NotNull PerformanceWatcher performanceWatcher, boolean bl) {
        void finished2;
        List infos;
        long dumpInterval;
        if (attachments == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(5);
        }
        if (performanceWatcher == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(6);
        }
        long l = dumpInterval = (infos = this.myDumpTask.getThreadInfos()).isEmpty() ? (long)performanceWatcher.getDumpInterval() : (long)this.myDumpTask.getDumpInterval();
        if (infos.isEmpty()) {
            infos = ContainerUtil.map(this.myCurrentDumps, ThreadDump::getThreadInfos);
        }
        return this.createEvent(duration, dumpInterval, infos.size(), ContainerUtil.mapNotNull((Collection)infos, IdeaFreezeReporter::getCauseThread), attachments, reportDir, performanceWatcher.getJitProblem(), (boolean)finished2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private IdeaLoggingEvent createEvent(long duration, long dumpInterval, int sampledCount, @NotNull List<? extends ThreadInfo> causeThreads, @NotNull List<? extends Attachment> attachments, @Nullable File reportDir, @Nullable String string, boolean bl) {
        if (causeThreads == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(7);
        }
        if (attachments == null) {
            IdeaFreezeReporter.$$$reportNull$$$0(8);
        }
        boolean allInEdt = ContainerUtil.and(causeThreads, ThreadDumper::isEDT);
        CallTreeNode root = CallTreeNode.buildTree(causeThreads, dumpInterval);
        int classLoadingRatio = IdeaFreezeReporter.countClassLoading(causeThreads) * 100 / causeThreads.size();
        CallTreeNode commonStackNode = root.findDominantCommonStack((long)((double)((long)causeThreads.size() * dumpInterval) * 0.25));
        List<StackTraceElement> commonStack = commonStackNode != null ? commonStackNode.getStack() : null;
        boolean nonEdtCause = false;
        if (ContainerUtil.isEmpty(commonStack)) {
            commonStack = this.myStacktraceCommonPart;
        } else {
            nonEdtCause = !ThreadDumper.isEDT((ThreadInfo)commonStackNode.myThreadInfo);
        }
        String reportText = root.dump();
        try {
            if (reportDir != null) {
                FileUtil.writeToFile((File)new File(reportDir, "report.txt"), (String)reportText);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!ContainerUtil.isEmpty(commonStack)) {
            double processCpuLoad2;
            void jitProblem;
            void finished2;
            String edtNote;
            if (commonStack.stream().anyMatch(IdeaFreezeReporter::skippedFrame)) {
                return null;
            }
            long durationInSeconds = duration / 1000L;
            String string2 = edtNote = allInEdt ? "in EDT " : "";
            String message2 = "Freeze " + edtNote + "for " + durationInSeconds + " seconds\n" + (finished2 != false ? "" : (this.myAppClosing ? "IDE is closing. " : "IDE KILLED! ")) + "Sampled time: " + (long)sampledCount * dumpInterval + "ms, sampling rate: " + dumpInterval + "ms";
            if (jitProblem != null) {
                message2 = message2 + ", " + (String)jitProblem;
            }
            long total = this.myDumpTask.getTotalTime();
            long gcTime = this.myDumpTask.getGcTime();
            if (total > 0L) {
                message2 = message2 + ", GC time: " + gcTime + "ms (" + gcTime * 100L / total + "%), Class loading: " + classLoadingRatio + "%";
            }
            if (DebugAttachDetector.isDebugEnabled()) {
                message2 = message2 + ", debug agent: on";
            }
            if ((processCpuLoad2 = this.myDumpTask.getProcessCpuLoad()) > 0.0) {
                message2 = message2 + ", cpu load: " + (int)(processCpuLoad2 * 100.0) + "%";
            }
            if (nonEdtCause) {
                message2 = message2 + "\n\nThe stack is from the thread that was blocking EDT";
            }
            Attachment report2 = IdeaFreezeReporter.createReportAttachment(durationInSeconds, reportText);
            return LogMessage.createEvent(new Freeze(commonStack), message2, ContainerUtil.append(attachments, (Object[])new Attachment[]{report2}).toArray(Attachment.EMPTY_ARRAY));
        }
        return null;
    }

    private static boolean skippedFrame(StackTraceElement e) {
        return ApplicationImpl.class.getName().equals(e.getClassName()) && "runEdtProgressWriteAction".equals(e.getMethodName());
    }

    private static int countClassLoading(List<? extends ThreadInfo> causeThreads) {
        return (int)causeThreads.stream().filter(t -> Arrays.stream(t.getStackTrace()).anyMatch(IdeaFreezeReporter::isClassLoading)).count();
    }

    private static boolean isClassLoading(StackTraceElement stackTraceElement) {
        return "loadClass".equals(stackTraceElement.getMethodName()) && "java.lang.ClassLoader".equals(stackTraceElement.getClassName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/IdeaFreezeReporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = DUMP_PREFIX;
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "performanceWatcher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "causeThreads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/IdeaFreezeReporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createReportAttachment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReportAttachment";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "uiFreezeStarted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dumpedThreads";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CallTreeNode {
        private final StackTraceElement myStackTraceElement;
        private final CallTreeNode myParent;
        private final List<CallTreeNode> myChildren = new SmartList();
        private final int myDepth;
        private long myTime;
        private final ThreadInfo myThreadInfo;
        static final Comparator<CallTreeNode> TIME_COMPARATOR = Comparator.comparingLong(n -> n.myTime).reversed();

        private CallTreeNode(StackTraceElement element2, CallTreeNode parent, long time, ThreadInfo info2) {
            this.myStackTraceElement = element2;
            this.myParent = parent;
            this.myDepth = parent != null ? parent.myDepth + 1 : 0;
            this.myTime = time;
            this.myThreadInfo = info2;
        }

        @NotNull
        public static CallTreeNode buildTree(List<? extends ThreadInfo> threadInfos, long time) {
            CallTreeNode root = new CallTreeNode(null, null, 0L, null);
            for (ThreadInfo threadInfo : threadInfos) {
                CallTreeNode node2 = root;
                StackTraceElement[] stack = threadInfo.getStackTrace();
                for (int i2 = stack.length - 1; i2 >= 0; --i2) {
                    node2 = node2.addCallee(stack[i2], time, threadInfo);
                }
            }
            CallTreeNode callTreeNode = root;
            if (callTreeNode == null) {
                CallTreeNode.$$$reportNull$$$0(0);
            }
            return callTreeNode;
        }

        CallTreeNode addCallee(StackTraceElement e, long time, ThreadInfo threadInfo) {
            for (CallTreeNode child2 : this.myChildren) {
                if (!PerformanceWatcher.compareStackTraceElements(child2.myStackTraceElement, e)) continue;
                child2.myTime += time;
                return child2;
            }
            CallTreeNode child3 = new CallTreeNode(e, this, time, threadInfo);
            this.myChildren.add(child3);
            return child3;
        }

        @Nullable
        CallTreeNode getMostHitChild() {
            CallTreeNode currentMax = null;
            for (CallTreeNode child2 : this.myChildren) {
                if (currentMax != null && child2.myTime <= currentMax.myTime) continue;
                currentMax = child2;
            }
            return currentMax;
        }

        public String toString() {
            return this.myTime + " " + this.myStackTraceElement;
        }

        public void appendIndentedString(StringBuilder builder2) {
            StringUtil.repeatSymbol((Appendable)builder2, (char)' ', (int)this.myDepth);
            builder2.append(this.myStackTraceElement.getClassName()).append(".").append(this.myStackTraceElement.getMethodName()).append(" ").append(this.myTime).append("ms").append("\n");
        }

        String dump() {
            StringBuilder sb = new StringBuilder();
            LinkedList<CallTreeNode> nodes = new LinkedList<CallTreeNode>(this.myChildren);
            while (!nodes.isEmpty()) {
                CallTreeNode node2 = nodes.removeFirst();
                node2.appendIndentedString(sb);
                nodes.addAll(0, ContainerUtil.sorted(node2.myChildren, TIME_COMPARATOR));
            }
            return sb.toString();
        }

        private List<StackTraceElement> getStack() {
            ArrayList<StackTraceElement> res2 = new ArrayList<StackTraceElement>();
            CallTreeNode node2 = this;
            while (node2 != null && node2.myStackTraceElement != null) {
                res2.add(node2.myStackTraceElement);
                node2 = node2.myParent;
            }
            return res2;
        }

        @Nullable
        private CallTreeNode findDominantCommonStack(long threshold) {
            CallTreeNode mostHitChild;
            CallTreeNode node2 = this.getMostHitChild();
            if (node2 == null) {
                return null;
            }
            while (!node2.myChildren.isEmpty() && (mostHitChild = node2.getMostHitChild()) != null && mostHitChild.myTime > threshold) {
                node2 = mostHitChild;
            }
            return node2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagnostic/IdeaFreezeReporter$CallTreeNode", "buildTree"));
        }
    }
}

