/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H&J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H&J\b\u0010\u0015\u001a\u00020\u0013H&J\u0006\u0010\u0016\u001a\u00020\u0013J\b\u0010\u0017\u001a\u00020\u0018H&J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0004J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u0004J\b\u0010\u001e\u001a\u00020\u001fH&J\b\u0010 \u001a\u00020\u0013H&J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0013H&J\u000e\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0004R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lcom/intellij/diagnostic/hprof/util/HProfReadBuffer;", "Ljava/lang/AutoCloseable;", "()V", "value", "", "idSize", "getIdSize", "()I", "setIdSize", "(I)V", "get", "", "", "bytes", "", "getByteBuffer", "Ljava/nio/ByteBuffer;", "size", "getId", "", "getInt", "getLong", "getRawId", "getShort", "", "getUTF8String", "", "getUnsignedByte", "getUnsignedInt", "getUnsignedShort", "isEof", "", "position", "newPosition", "skip", "n", "intellij.platform.ide.impl"})
public abstract class HProfReadBuffer
implements AutoCloseable {
    private int idSize;

    public final int getIdSize() {
        return this.idSize;
    }

    public final void setIdSize(int value2) {
        if (this.idSize != 0) {
            throw (Throwable)new IllegalStateException("ID size cannot be reassigned.");
        }
        if (value2 != 1 && value2 != 2 && value2 != 4 && value2 != 8) {
            throw (Throwable)new InvalidParameterException("ID size can only be 1, 2, 4 or 8.");
        }
        this.idSize = value2;
    }

    public abstract void position(long var1);

    public abstract boolean isEof();

    public abstract long position();

    public abstract void get(@NotNull byte[] var1);

    @NotNull
    public abstract ByteBuffer getByteBuffer(int var1);

    public abstract byte get();

    public abstract short getShort();

    public abstract int getInt();

    public abstract long getLong();

    public long getId() {
        return this.getRawId();
    }

    public final long getRawId() {
        long l;
        switch (this.idSize) {
            case 1: {
                l = this.getUnsignedByte();
                break;
            }
            case 2: {
                l = this.getUnsignedShort();
                break;
            }
            case 4: {
                l = this.getUnsignedInt();
                break;
            }
            case 8: {
                l = this.getLong();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("ID size not assigned yet.");
            }
        }
        return l;
    }

    public final int getUnsignedByte() {
        return Byte.toUnsignedInt(this.get());
    }

    public final int getUnsignedShort() {
        return Short.toUnsignedInt(this.getShort());
    }

    public final long getUnsignedInt() {
        return Integer.toUnsignedLong(this.getInt());
    }

    @NotNull
    public final String getUTF8String() {
        int length = this.getUnsignedShort();
        byte[] bytes = new byte[length];
        this.get(bytes);
        boolean bl = false;
        return new String(bytes, Charsets.UTF_8);
    }

    public final void skip(int n) {
        this.position(this.position() + (long)n);
    }
}

