/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.ShowBlankDiffWindowActionKt;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.util.ThreeSide;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.editor.EditorDropHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/intellij/diff/actions/DnDHandler3;", "Lcom/intellij/openapi/editor/EditorDropHandler;", "viewer", "Lcom/intellij/diff/tools/util/side/ThreesideTextDiffViewer;", "helper", "Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;", "side", "Lcom/intellij/diff/util/ThreeSide;", "(Lcom/intellij/diff/tools/util/side/ThreesideTextDiffViewer;Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;Lcom/intellij/diff/util/ThreeSide;)V", "getHelper", "()Lcom/intellij/diff/actions/impl/MutableDiffRequestChain$Helper;", "getSide", "()Lcom/intellij/diff/util/ThreeSide;", "getViewer", "()Lcom/intellij/diff/tools/util/side/ThreesideTextDiffViewer;", "canHandleDrop", "", "transferFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "([Ljava/awt/datatransfer/DataFlavor;)Z", "doHandleDnD", "transferable", "Ljava/awt/datatransfer/Transferable;", "handleDrop", "", "t", "project", "Lcom/intellij/openapi/project/Project;", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "install", "intellij.platform.diff.impl"})
final class DnDHandler3
implements EditorDropHandler {
    @NotNull
    private final ThreesideTextDiffViewer viewer;
    @NotNull
    private final MutableDiffRequestChain.Helper helper;
    @NotNull
    private final ThreeSide side;

    public final void install() {
        EditorEx editorEx = this.viewer.getEditor(this.side);
        if (!(editorEx instanceof EditorImpl)) {
            editorEx = null;
        }
        EditorImpl editorImpl = (EditorImpl)editorEx;
        if (editorImpl == null) {
            return;
        }
        EditorImpl editor = editorImpl;
        editor.setDropHandler(this);
    }

    @Override
    public boolean canHandleDrop(@NotNull DataFlavor[] transferFlavors) {
        Intrinsics.checkNotNullParameter((Object)transferFlavors, (String)"transferFlavors");
        return FileCopyPasteUtil.isFileListFlavorAvailable(transferFlavors);
    }

    @Override
    public void handleDrop(@NotNull Transferable t, @Nullable Project project, @Nullable EditorWindow editorWindow) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        boolean success2 = this.doHandleDnD(t);
        if (success2) {
            this.helper.fireRequestUpdated();
        }
    }

    private final boolean doHandleDnD(Transferable transferable) {
        List<File> files2 = FileCopyPasteUtil.getFileList(transferable);
        if (files2 != null) {
            if (files2.size() == 1) {
                Project project = this.viewer.getProject();
                File file2 = files2.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"files[0]");
                DocumentContent documentContent = ShowBlankDiffWindowActionKt.access$createFileContent(project, file2);
                if (documentContent == null) {
                    return false;
                }
                DocumentContent newContent = documentContent;
                this.helper.setContent((DiffContent)newContent, this.side);
                return true;
            }
            if (files2.size() == 3) {
                Project project = this.viewer.getProject();
                File file3 = files2.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"files[0]");
                DocumentContent documentContent = ShowBlankDiffWindowActionKt.access$createFileContent(project, file3);
                if (documentContent == null) {
                    return false;
                }
                DocumentContent newContent1 = documentContent;
                Project project2 = this.viewer.getProject();
                File file4 = files2.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"files[1]");
                DocumentContent documentContent2 = ShowBlankDiffWindowActionKt.access$createFileContent(project2, file4);
                if (documentContent2 == null) {
                    return false;
                }
                DocumentContent newBaseContent = documentContent2;
                Project project3 = this.viewer.getProject();
                File file5 = files2.get(2);
                Intrinsics.checkNotNullExpressionValue((Object)file5, (String)"files[2]");
                DocumentContent documentContent3 = ShowBlankDiffWindowActionKt.access$createFileContent(project3, file5);
                if (documentContent3 == null) {
                    return false;
                }
                DocumentContent newContent2 = documentContent3;
                this.helper.setContent((DiffContent)newContent1, ThreeSide.LEFT);
                this.helper.setContent((DiffContent)newBaseContent, ThreeSide.BASE);
                this.helper.setContent((DiffContent)newContent2, ThreeSide.RIGHT);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final ThreesideTextDiffViewer getViewer() {
        return this.viewer;
    }

    @NotNull
    public final MutableDiffRequestChain.Helper getHelper() {
        return this.helper;
    }

    @NotNull
    public final ThreeSide getSide() {
        return this.side;
    }

    public DnDHandler3(@NotNull ThreesideTextDiffViewer viewer, @NotNull MutableDiffRequestChain.Helper helper, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.viewer = viewer;
        this.helper = helper;
        this.side = side;
    }
}

