/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.GridBag;
import java.awt.Cursor;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffSplitter
extends Splitter {
    @Nullable
    private Painter myPainter;
    @Nullable
    private AnAction myTopAction;
    @Nullable
    private AnAction myBottomAction;

    public DiffSplitter() {
        this.setDividerWidth(JBUIScale.scale((int)Registry.intValue((String)"diff.divider.width")));
    }

    protected Divider createDivider() {
        return new Splitter.DividerImpl(){

            public void setOrientation(boolean isVerticalSplit) {
                int width;
                this.removeAll();
                this.setCursor(Cursor.getPredefinedCursor(10));
                List<JComponent> actionComponents = Arrays.asList(DiffSplitter.createActionComponent(DiffSplitter.this.myTopAction), DiffSplitter.createActionComponent(DiffSplitter.this.myBottomAction));
                List<JComponent> syncComponents = DiffUtil.createSyncHeightComponents(actionComponents);
                GridBag bag = new GridBag();
                JComponent button12 = syncComponents.get(0);
                JComponent button22 = syncComponents.get(1);
                if (button12 != null) {
                    width = button12.getPreferredSize().width;
                    if (DiffSplitter.this.getDividerWidth() < width) {
                        DiffSplitter.this.setDividerWidth(width);
                    }
                }
                if (button22 != null) {
                    width = button22.getPreferredSize().width;
                    if (DiffSplitter.this.getDividerWidth() < width) {
                        DiffSplitter.this.setDividerWidth(width);
                    }
                }
                if (button12 != null) {
                    this.add(button12, bag.nextLine());
                }
                if (button12 != null && button22 != null) {
                    this.add(Box.createVerticalStrut(JBUIScale.scale((int)20)), bag.nextLine());
                }
                if (button22 != null) {
                    this.add(button22, bag.nextLine());
                }
                this.revalidate();
                this.repaint();
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (DiffSplitter.this.myPainter != null) {
                    DiffSplitter.this.myPainter.paint(g, (JComponent)((Object)this));
                }
            }
        };
    }

    public void setTopAction(@Nullable AnAction value2) {
        this.myTopAction = value2;
        this.setOrientation(false);
    }

    public void setBottomAction(@Nullable AnAction value2) {
        this.myBottomAction = value2;
        this.setOrientation(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setPainter(@Nullable Painter painter) {
        void painter2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myPainter = painter2;
    }

    public void repaintDivider() {
        this.getDivider().repaint();
    }

    @Nullable
    private static JComponent createActionComponent(@Nullable AnAction action2) {
        if (action2 == null) {
            return null;
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DiffSplitter", (ActionGroup)new DefaultActionGroup(new AnAction[]{action2}), true);
        toolbar.setTargetComponent(toolbar.getComponent());
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setCursor(Cursor.getDefaultCursor());
        return toolbar.getComponent();
    }

    public static interface Painter {
        public void paint(@NotNull Graphics var1, @NotNull JComponent var2);
    }
}

