/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.Range;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TwosideTextDiffProviderBase
extends TextDiffProviderBase
implements TwosideTextDiffProvider {
    protected TwosideTextDiffProviderBase(@NotNull TextDiffSettingsHolder.TextDiffSettings settings2, @NotNull Runnable rediff, @NotNull Disposable disposable2, IgnorePolicy @NotNull [] ignorePolicies, HighlightPolicy @NotNull [] highlightPolicies) {
        if (settings2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(0);
        }
        if (rediff == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(2);
        }
        if (ignorePolicies == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(3);
        }
        if (highlightPolicies == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(4);
        }
        super(settings2, rediff, disposable2, ignorePolicies, highlightPolicies);
    }

    @Override
    @Nullable
    public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator2) {
        LineOffsets lineOffsets2;
        LineOffsets lineOffsets1;
        List<List<LineFragment>> fragments;
        if (text1 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(6);
        }
        if (indicator2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(7);
        }
        if ((fragments = this.doCompare(text1, text2, lineOffsets1 = LineOffsetsUtil.create(text1), lineOffsets2 = LineOffsetsUtil.create(text2), null, indicator2)) == null) {
            return null;
        }
        assert (fragments.size() == 1);
        return fragments.get(0);
    }

    @Override
    @Nullable
    public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator2) {
        if (text1 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(9);
        }
        if (linesRanges == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(10);
        }
        if (indicator2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(11);
        }
        LineOffsets lineOffsets1 = LineOffsetsUtil.create(text1);
        LineOffsets lineOffsets2 = LineOffsetsUtil.create(text2);
        return this.doCompare(text1, text2, lineOffsets1, lineOffsets2, linesRanges, indicator2);
    }

    @Nullable
    private List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @Nullable List<Range> linesRanges, @NotNull ProgressIndicator indicator2) {
        if (text1 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(13);
        }
        if (lineOffsets1 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(14);
        }
        if (lineOffsets2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(15);
        }
        if (indicator2 == null) {
            TwosideTextDiffProviderBase.$$$reportNull$$$0(16);
        }
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        if (!highlightPolicy.isShouldCompare()) {
            return null;
        }
        indicator2.checkCanceled();
        List<List<LineFragment>> fragments = this.doCompare(text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, highlightPolicy, indicator2);
        assert (fragments.size() == (linesRanges != null ? linesRanges.size() : 1));
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        boolean squashFragments = highlightPolicy.isShouldSquash();
        boolean trimFragments = ignorePolicy.isShouldTrimChunks();
        indicator2.checkCanceled();
        return ContainerUtil.map(fragments, rangeFragments -> ComparisonManager.getInstance().processBlocks(rangeFragments, text1, text2, policy, squashFragments, trimFragments));
    }

    @NotNull
    protected abstract List<List<LineFragment>> doCompare(@NotNull CharSequence var1, @NotNull CharSequence var2, @NotNull LineOffsets var3, @NotNull LineOffsets var4, @Nullable List<? extends Range> var5, @NotNull IgnorePolicy var6, @NotNull HighlightPolicy var7, @NotNull ProgressIndicator var8);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesRanges";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/text/TwosideTextDiffProviderBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doCompare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

