/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.statistics.RunConfigurationUsageTriggerCollector;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.UIBundle;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a&\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a \u0010\u0013\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\r*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0007\u00a8\u0006\u0018"}, d2={"createEnvironmentBuilder", "Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "triggerUsage", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "userApprovesStopForIncompatibleConfigurations", "", "configName", "", "runningIncompatibleDescriptors", "", "Lcom/intellij/execution/ui/RunContentDescriptor;", "userApprovesStopForSameTypeConfigurations", "instancesCount", "", "isOfSameType", "runnerAndConfigurationSettings", "intellij.platform.execution.impl"})
public final class ExecutionManagerImplKt {
    @ApiStatus.Internal
    public static final boolean isOfSameType(@NotNull RunnerAndConfigurationSettings $this$isOfSameType, @NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        Intrinsics.checkNotNullParameter((Object)$this$isOfSameType, (String)"$this$isOfSameType");
        Intrinsics.checkNotNullParameter((Object)runnerAndConfigurationSettings, (String)"runnerAndConfigurationSettings");
        if ($this$isOfSameType == runnerAndConfigurationSettings) {
            return true;
        }
        RunConfiguration runConfiguration = $this$isOfSameType.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"configuration");
        RunConfiguration thisConfiguration = runConfiguration;
        RunConfiguration runConfiguration2 = runnerAndConfigurationSettings.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"runnerAndConfigurationSettings.configuration");
        RunConfiguration thatConfiguration = runConfiguration2;
        if (thisConfiguration == thatConfiguration) {
            return true;
        }
        if (thisConfiguration instanceof UserDataHolder) {
            RunProfile runProfile = (RunProfile)ExecutionManagerImpl.Companion.getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl().get((UserDataHolder)thisConfiguration);
            if (runProfile == null) {
                return false;
            }
            RunProfile originalRunProfile = runProfile;
            if (originalRunProfile == thatConfiguration) {
                return true;
            }
            if (thatConfiguration instanceof UserDataHolder) {
                return originalRunProfile == (RunProfile)ExecutionManagerImpl.Companion.getDELEGATED_RUN_PROFILE_KEY$intellij_platform_execution_impl().get((UserDataHolder)thatConfiguration);
            }
        }
        return false;
    }

    private static final StructuredIdeActivity triggerUsage(ExecutionEnvironment environment2) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment2.getRunnerAndConfigurationSettings();
        Object runConfiguration = runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null;
        RunConfiguration runConfiguration2 = runConfiguration;
        if (runConfiguration2 == null || (runConfiguration2 = runConfiguration2.getFactory()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration2, (String)"runConfiguration?.factory ?: return null");
        RunConfiguration configurationFactory = runConfiguration2;
        return RunConfigurationUsageTriggerCollector.trigger(environment2.getProject(), (ConfigurationFactory)configurationFactory, environment2.getExecutor(), runConfiguration);
    }

    private static final ExecutionEnvironmentBuilder createEnvironmentBuilder(Project project, Executor executor, RunnerAndConfigurationSettings configuration2) {
        ProgramRunner runner;
        ProgramRunner programRunner;
        ExecutionEnvironmentBuilder builder2 = new ExecutionEnvironmentBuilder(project, executor);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configuration2;
        if (runnerAndConfigurationSettings != null) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            boolean bl = false;
            boolean bl2 = false;
            RunnerAndConfigurationSettings it = runnerAndConfigurationSettings2;
            boolean bl3 = false;
            programRunner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)it.getConfiguration()));
        } else {
            programRunner = runner = null;
        }
        if (runner == null && configuration2 != null) {
            ExecutionManagerImpl.Companion.getLOG().error("Cannot find runner for " + configuration2.getName());
        } else if (runner != null) {
            builder2.runnerAndSettings(runner, configuration2);
        }
        return builder2;
    }

    private static final boolean userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        RunManagerConfig config2 = RunManagerImpl.Companion.getInstanceImpl(project).getConfig();
        if (!config2.isRestartRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(config2){
            final /* synthetic */ RunManagerConfig $config;

            public boolean isToBeShown() {
                return this.$config.isRestartRequiresConfirmation();
            }

            public void setToBeShown(boolean value2, int exitCode) {
                this.$config.setRestartRequiresConfirmation(value2);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UIBundle.message(\"dialog.options.do.not.show\")");
                return string;
            }
            {
                this.$config = $captured_local_variable$0;
            }
        };
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"rerun.singleton.confirmation.message", (Object[])new Object[]{configName, instancesCount}), (String)ExecutionBundle.message((String)"process.is.running.dialog.title", (Object[])new Object[]{configName}), (String)ExecutionBundle.message((String)"rerun.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option2) == 0;
    }

    private static final boolean userApprovesStopForIncompatibleConfigurations(Project project, String configName, List<? extends RunContentDescriptor> runningIncompatibleDescriptors) {
        RunManagerConfig config2 = RunManagerImpl.Companion.getInstanceImpl(project).getConfig();
        if (!config2.isStopIncompatibleRequiresConfirmation()) {
            return true;
        }
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(config2){
            final /* synthetic */ RunManagerConfig $config;

            public boolean isToBeShown() {
                return this.$config.isStopIncompatibleRequiresConfirmation();
            }

            public void setToBeShown(boolean value2, int exitCode) {
                this.$config.setStopIncompatibleRequiresConfirmation(value2);
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return false;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UIBundle.message(\"dialog.options.do.not.show\")");
                return string;
            }
            {
                this.$config = $captured_local_variable$0;
            }
        };
        StringBuilder names2 = new StringBuilder();
        for (RunContentDescriptor runContentDescriptor : runningIncompatibleDescriptors) {
            String string;
            String name = runContentDescriptor.getDisplayName();
            CharSequence charSequence = names2;
            boolean bl = false;
            if (charSequence.length() > 0) {
                names2.append(", ");
            }
            charSequence = name;
            bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                string = ExecutionBundle.message((String)"run.configuration.no.name", (Object[])new Object[0]);
            } else {
                charSequence = StringCompanionObject.INSTANCE;
                String string2 = "'%s'";
                Object[] objectArray = new Object[]{name};
                boolean bl3 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            }
            names2.append(string);
        }
        return Messages.showOkCancelDialog((Project)project, (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.message", (Object[])new Object[]{configName, names2.toString(), runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"incompatible.configuration.is.running.dialog.title", (Object[])new Object[]{runningIncompatibleDescriptors.size()}), (String)ExecutionBundle.message((String)"stop.incompatible.confirmation.button.text", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)option2) == 0;
    }

    public static final /* synthetic */ StructuredIdeActivity access$triggerUsage(ExecutionEnvironment environment2) {
        return ExecutionManagerImplKt.triggerUsage(environment2);
    }

    public static final /* synthetic */ ExecutionEnvironmentBuilder access$createEnvironmentBuilder(Project project, Executor executor, RunnerAndConfigurationSettings configuration2) {
        return ExecutionManagerImplKt.createEnvironmentBuilder(project, executor, configuration2);
    }

    public static final /* synthetic */ boolean access$userApprovesStopForSameTypeConfigurations(Project project, String configName, int instancesCount) {
        return ExecutionManagerImplKt.userApprovesStopForSameTypeConfigurations(project, configName, instancesCount);
    }

    public static final /* synthetic */ boolean access$userApprovesStopForIncompatibleConfigurations(Project project, String configName, List runningIncompatibleDescriptors) {
        return ExecutionManagerImplKt.userApprovesStopForIncompatibleConfigurations(project, configName, runningIncompatibleDescriptors);
    }
}

