/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerMediator {
    private static final Logger LOG = Logger.getInstance(RunnerMediator.class);
    private static final char IAC = '\u0005';
    private static final char BRK = '\u0003';
    private static final char C = '\u0005';
    private static final String RUNNERW = "runnerw.exe";
    private static final String IDEA_RUNNERW = "IDEA_RUNNERW";
    private static final Key<Boolean> MEDIATOR_KEY = Key.create((String)"KillableProcessHandler.Mediator.Process");

    public static RunnerMediator getInstance() {
        return new RunnerMediator();
    }

    private static void sendCtrlEventThroughStream(@NotNull Process process2, char event) {
        if (process2 == null) {
            RunnerMediator.$$$reportNull$$$0(0);
        }
        OutputStream os = process2.getOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.print('\u0005');
        pw.print(event);
        pw.flush();
    }

    @NotNull
    public ProcessHandler createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RunnerMediator.$$$reportNull$$$0(1);
        }
        return new KillableColoredProcessHandler(commandLine, true){

            @Override
            protected boolean destroyProcessGracefully() {
                if (SystemInfo.isWindows) {
                    return RunnerMediator.destroyProcess(this.myProcess, false);
                }
                return super.destroyProcessGracefully();
            }
        };
    }

    @Nullable
    private static String getRunnerPath() {
        Path runnerw;
        if (!SystemInfo.isWindows) {
            throw new IllegalStateException("There is no need of runner under unix based OS");
        }
        String path2 = System.getenv(IDEA_RUNNERW);
        if (path2 != null) {
            if (new File(path2).exists()) {
                return path2;
            }
            LOG.warn("Cannot locate a runner at " + path2 + " (as told by IDEA_RUNNERW)");
        }
        if ((runnerw = PathManager.findBinFile((String)RUNNERW)) != null && Files.exists(runnerw, new LinkOption[0])) {
            return runnerw.toString();
        }
        LOG.warn("Cannot locate runnerw.exe in " + PathManager.getBinPath());
        return null;
    }

    public static void injectRunnerCommand(@NotNull GeneralCommandLine commandLine, boolean showConsole) {
        if (commandLine == null) {
            RunnerMediator.$$$reportNull$$$0(2);
        }
        if (!SystemInfo.isWindows || RunnerMediator.isRunnerCommandInjected(commandLine)) {
            return;
        }
        String path2 = RunnerMediator.getRunnerPath();
        if (path2 != null) {
            commandLine.getParametersList().addAt(0, commandLine.getExePath());
            if (showConsole) {
                commandLine.getParametersList().addAt(0, "/C");
            }
            commandLine.setExePath(path2);
            MEDIATOR_KEY.set((UserDataHolder)commandLine, (Object)true);
        }
    }

    static boolean isRunnerCommandInjected(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            RunnerMediator.$$$reportNull$$$0(3);
        }
        return MEDIATOR_KEY.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    public static boolean destroyProcess(@NotNull Process process2) {
        if (process2 == null) {
            RunnerMediator.$$$reportNull$$$0(4);
        }
        return RunnerMediator.destroyProcess(process2, false);
    }

    static boolean destroyProcess(@NotNull Process process2, boolean softKill) {
        if (process2 == null) {
            RunnerMediator.$$$reportNull$$$0(5);
        }
        try {
            if (SystemInfo.isWindows) {
                RunnerMediator.sendCtrlEventThroughStream(process2, softKill ? (char)'\u0005' : '\u0003');
                return true;
            }
            if (SystemInfo.isUnix) {
                if (softKill) {
                    return UnixProcessManager.sendSigIntToProcessTree((Process)process2);
                }
                return UnixProcessManager.sendSigKillToProcessTree((Process)process2);
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate the process", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/process/RunnerMediator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sendCtrlEventThroughStream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createProcess";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "injectRunnerCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRunnerCommandInjected";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "destroyProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

