/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptRunnerUtil {
    private static final Logger LOG = Logger.getInstance(ScriptRunnerUtil.class);
    public static final Condition<Key> STDOUT_OUTPUT_KEY_FILTER = key -> ProcessOutputTypes.STDOUT.equals(key);
    public static final Condition<Key> STDERR_OUTPUT_KEY_FILTER = key -> ProcessOutputTypes.STDERR.equals(key);
    public static final Condition<Key> STDOUT_OR_STDERR_OUTPUT_KEY_FILTER = Conditions.or(STDOUT_OUTPUT_KEY_FILTER, STDERR_OUTPUT_KEY_FILTER);
    private static final int DEFAULT_TIMEOUT = 30000;

    private ScriptRunnerUtil() {
    }

    public static String getProcessOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(0);
        }
        return ScriptRunnerUtil.getProcessOutput(commandLine, STDOUT_OUTPUT_KEY_FILTER, 30000L);
    }

    public static String getProcessOutput(@NotNull GeneralCommandLine commandLine, @NotNull Condition<? super Key> outputTypeFilter, long timeout) throws ExecutionException {
        if (commandLine == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(1);
        }
        if (outputTypeFilter == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(2);
        }
        return ScriptRunnerUtil.getProcessOutput((ProcessHandler)new OSProcessHandler(commandLine), outputTypeFilter, timeout);
    }

    public static String getProcessOutput(@NotNull ProcessHandler processHandler2, final @NotNull Condition<? super Key> outputTypeFilter, long timeout) throws ExecutionException {
        if (processHandler2 == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(3);
        }
        if (outputTypeFilter == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!processHandler2.isStartNotified());
        final StringBuilder outputBuilder = new StringBuilder();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputTypeFilter.value((Object)outputType)) {
                    String text2 = event.getText();
                    outputBuilder.append(text2);
                    LOG.debug(text2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/process/ScriptRunnerUtil$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        processHandler2.startNotify();
        if (!processHandler2.waitFor(timeout)) {
            throw new ExecutionException(ExecutionBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(timeout / 1000L)}));
        }
        return outputBuilder.toString();
    }

    @NotNull
    public static OSProcessHandler execute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters2) throws ExecutionException {
        if (exePath == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(5);
        }
        return ScriptRunnerUtil.execute(exePath, workingDirectory, scriptFile, parameters2, null, (ThrowableNotNullFunction<? super GeneralCommandLine, ? extends OSProcessHandler, ? extends ExecutionException>)((ThrowableNotNullFunction)commandLine -> new ColoredProcessHandler((GeneralCommandLine)commandLine)));
    }

    @NotNull
    public static OSProcessHandler execute(@NotNull String exePath, @Nullable String workingDirectory, @Nullable VirtualFile scriptFile, String[] parameters2, @Nullable Charset charset, @NotNull ThrowableNotNullFunction<? super GeneralCommandLine, ? extends OSProcessHandler, ? extends ExecutionException> creator) throws ExecutionException {
        if (exePath == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(6);
        }
        if (creator == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(7);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)exePath)});
        if (scriptFile != null) {
            commandLine.addParameter(scriptFile.getPresentableUrl());
        }
        commandLine.addParameters(parameters2);
        if (workingDirectory != null) {
            commandLine.setWorkDirectory(workingDirectory);
        }
        LOG.debug("Command line: ", new Object[]{commandLine.getCommandLineString()});
        LOG.debug("Command line env: ", new Object[]{commandLine.getEnvironment()});
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        commandLine.setCharset(charset);
        OSProcessHandler processHandler2 = (OSProcessHandler)creator.fun((Object)commandLine);
        if (LOG.isDebugEnabled()) {
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    LOG.debug(outputType + ": " + event.getText());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/execution/process/ScriptRunnerUtil$2";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        OSProcessHandler oSProcessHandler = processHandler2;
        if (oSProcessHandler == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(8);
        }
        return oSProcessHandler;
    }

    public static boolean isExecutableInPath(@NotNull String exeName) {
        if (exeName == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(9);
        }
        assert (exeName.indexOf(File.pathSeparatorChar) == -1) : exeName;
        File exeFile = PathEnvironmentVariableUtil.findInPath((String)exeName);
        if (exeFile != null) {
            return true;
        }
        String pathWithExt = PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)exeName);
        return pathWithExt != exeName;
    }

    public static ScriptOutput executeScriptInConsoleWithFullOutput(String exePathString, @Nullable VirtualFile scriptFile, @Nullable String workingDirectory, long timeout, Condition<? super Key> scriptOutputType, String ... parameters2) throws ExecutionException {
        OSProcessHandler processHandler2 = ScriptRunnerUtil.execute(exePathString, workingDirectory, scriptFile, parameters2);
        ScriptOutput output2 = new ScriptOutput(scriptOutputType);
        processHandler2.addProcessListener((ProcessListener)output2);
        processHandler2.startNotify();
        if (!processHandler2.waitFor(timeout)) {
            LOG.warn("Process did not complete in " + timeout / 1000L + "s");
            throw new ExecutionException(ExecutionBundle.message((String)"script.execution.timeout", (Object[])new Object[]{String.valueOf(timeout / 1000L)}));
        }
        LOG.debug("script output: ", new Object[]{output2.myFilteredOutput});
        return output2;
    }

    public static void terminateProcessHandler(@NotNull ProcessHandler processHandler2, long millisTimeout, @Nullable String string) {
        KillableProcess killableProcess;
        if (processHandler2 == null) {
            ScriptRunnerUtil.$$$reportNull$$$0(10);
        }
        if (processHandler2.isProcessTerminated()) {
            String commandLine;
            if (commandLine == null && processHandler2 instanceof BaseProcessHandler) {
                commandLine = ((BaseProcessHandler)processHandler2).getCommandLine();
            }
            LOG.warn("Process '" + commandLine + "' is already terminated!");
            return;
        }
        processHandler2.destroyProcess();
        if (processHandler2 instanceof KillableProcess && (killableProcess = (KillableProcess)processHandler2).canKillProcess() && !processHandler2.waitFor(millisTimeout)) {
            killableProcess.killProcess();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputTypeFilter";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ScriptRunnerUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ScriptRunnerUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExecutableInPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "terminateProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ScriptOutput
    extends ProcessAdapter {
        private final Condition<? super Key> myScriptOutputType;
        public final StringBuilder myFilteredOutput;
        public final StringBuffer myMergedOutput;

        public ScriptOutput(Condition<? super Key> scriptOutputType) {
            this.myScriptOutputType = scriptOutputType;
            this.myFilteredOutput = new StringBuilder();
            this.myMergedOutput = new StringBuffer();
        }

        public String getFilteredOutput() {
            return this.myFilteredOutput.toString();
        }

        public String getMergedOutput() {
            return this.myMergedOutput.toString();
        }

        public String[] getOutputToParseArray() {
            return this.getFilteredOutput().split("\n");
        }

        public String getDescriptiveOutput() {
            String outputToParse = this.getFilteredOutput();
            return StringUtil.isEmpty((String)outputToParse) ? this.getMergedOutput() : outputToParse;
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                ScriptOutput.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                ScriptOutput.$$$reportNull$$$0(1);
            }
            String text2 = event.getText();
            if (this.myScriptOutputType.value((Object)outputType)) {
                this.myFilteredOutput.append(text2);
            }
            this.myMergedOutput.append(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/process/ScriptRunnerUtil$ScriptOutput";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

