/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.elevation;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.elevation.ElevationBundle;
import com.intellij.execution.process.elevation.ElevationLogger;
import com.intellij.execution.process.mediator.client.ProcessMediatorClient;
import com.intellij.execution.process.mediator.daemon.DaemonLaunchOptions;
import com.intellij.execution.process.mediator.launcher.DaemonHandshakeTransport;
import com.intellij.execution.process.mediator.launcher.DaemonHandshakeTransportKt;
import com.intellij.execution.process.mediator.launcher.DaemonProcessLauncher;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.processHandshake.ProcessHandshakeTransport;
import com.sun.jna.platform.unix.LibC;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0014J-\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0014J\b\u0010\u0014\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/process/elevation/ElevationDaemonProcessLauncher;", "Lcom/intellij/execution/process/mediator/launcher/DaemonProcessLauncher;", "clientBuilder", "Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;", "(Lcom/intellij/execution/process/mediator/client/ProcessMediatorClient$Builder;)V", "createBaseLaunchOptions", "Lcom/intellij/execution/process/mediator/daemon/DaemonLaunchOptions;", "createHandshakeTransport", "Lcom/intellij/execution/process/mediator/launcher/DaemonHandshakeTransport;", "createProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "transport", "handshakeFailed", "", "processHandler", "output", "Lcom/intellij/execution/process/ProcessOutput;", "reason", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "openUnixHandshakeTransport", "Companion", "intellij.platform.elevation"})
public final class ElevationDaemonProcessLauncher
extends DaemonProcessLauncher {
    private static final Key<Path> SUDO_PATH_KEY;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected DaemonHandshakeTransport createHandshakeTransport() {
        DaemonHandshakeTransport daemonHandshakeTransport;
        if (SystemInfo.isWindows) {
            daemonHandshakeTransport = super.createHandshakeTransport();
        } else {
            DaemonHandshakeTransport daemonHandshakeTransport2;
            try {
                daemonHandshakeTransport2 = this.openUnixHandshakeTransport();
            }
            catch (IOException e) {
                throw (Throwable)new ExecutionException(ElevationBundle.message("dialog.message.handshake.init.failed", new Object[0]), (Throwable)e);
            }
            daemonHandshakeTransport = daemonHandshakeTransport2;
        }
        return daemonHandshakeTransport;
    }

    private final DaemonHandshakeTransport openUnixHandshakeTransport() {
        DaemonHandshakeTransport daemonHandshakeTransport;
        DaemonLaunchOptions launchOptions = this.createBaseLaunchOptions();
        try {
            Path path2 = FileUtil.generateRandomTemporaryPath().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"FileUtil.generateRandomTemporaryPath().toPath()");
            daemonHandshakeTransport = DaemonHandshakeTransportKt.createUnixFifoTransport(DaemonHandshakeTransport.Companion, launchOptions, path2);
        }
        catch (IOException e0) {
            DaemonHandshakeTransport daemonHandshakeTransport2;
            ElevationLogger.INSTANCE.getLOG().warn("Unable to create file-based handshake channel; falling back to socket streams", (Throwable)e0);
            try {
                daemonHandshakeTransport2 = DaemonHandshakeTransportKt.createSocketTransport$default(DaemonHandshakeTransport.Companion, launchOptions, 0, 2, null);
            }
            catch (IOException e1) {
                ExceptionsKt.addSuppressed((Throwable)e1, (Throwable)e0);
                throw (Throwable)e1;
            }
            daemonHandshakeTransport = daemonHandshakeTransport2;
        }
        return DaemonHandshakeTransportKt.encrypted(daemonHandshakeTransport);
    }

    @Override
    @NotNull
    protected DaemonLaunchOptions createBaseLaunchOptions() {
        DaemonLaunchOptions daemonLaunchOptions = super.createBaseLaunchOptions();
        boolean bl = false;
        boolean bl2 = false;
        DaemonLaunchOptions it = daemonLaunchOptions;
        boolean bl3 = false;
        return SystemInfo.isWindows ? it : DaemonLaunchOptions.copy$default(it, true, true, null, SystemInfo.isMac ? Integer.valueOf(LibC.INSTANCE.getuid()) : null, null, null, 52, null);
    }

    @Override
    @NotNull
    protected BaseOSProcessHandler createProcessHandler(@NotNull DaemonHandshakeTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        GeneralCommandLine commandLine = this.createCommandLine(transport);
        Object[] objectArray = new Object[1];
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        objectArray[0] = applicationNamesInfo.getFullProductName();
        String string = ElevationBundle.message("dialog.title.sudo.prompt.product.elevation.daemon", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ElevationBundle.message(\u2026stance().fullProductName)");
        GeneralCommandLine sudoCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)string);
        Path sudoPath = sudoCommandLine != commandLine ? Path.of(sudoCommandLine.getExePath(), new String[0]) : null;
        BaseOSProcessHandler baseOSProcessHandler = this.createProcessHandler((ProcessHandshakeTransport)transport, sudoCommandLine);
        boolean bl = false;
        boolean bl2 = false;
        BaseOSProcessHandler $this$apply = baseOSProcessHandler;
        boolean bl3 = false;
        $this$apply.putUserData(SUDO_PATH_KEY, (Object)sudoPath);
        return baseOSProcessHandler;
    }

    @Override
    @NotNull
    protected Void handshakeFailed(@NotNull DaemonHandshakeTransport transport, @NotNull BaseOSProcessHandler processHandler2, @NotNull ProcessOutput output2, @NotNull String reason) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Path sudoPath = (Path)processHandler2.getUserData(SUDO_PATH_KEY);
        if (SystemInfo.isMac && output2.isExitCodeSet() && output2.getExitCode() == 1 && sudoPath != null && StringsKt.contains$default((CharSequence)((Object)sudoPath.getFileName()).toString(), (CharSequence)"osascript", (boolean)false, (int)2, null)) {
            String string = output2.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stderr");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"execution error: User cancelled", (boolean)false, (int)2, null)) {
                throw (Throwable)new ProcessCanceledException();
            }
        }
        String string = (path2 = sudoPath) == null ? ElevationBundle.message("dialog.message.failed.to.launch.daemon", reason) : ElevationBundle.message("dialog.message.failed.to.launch.daemon.with.sudo", sudoPath.getFileName(), reason);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (sudoPath) {\n      \u2026h.fileName, reason)\n    }");
        String message2 = string;
        throw (Throwable)new ExecutionException(message2);
    }

    public ElevationDaemonProcessLauncher(@NotNull ProcessMediatorClient.Builder clientBuilder) {
        Intrinsics.checkNotNullParameter((Object)clientBuilder, (String)"clientBuilder");
        super(clientBuilder);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"SUDO_PATH_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"SUDO_PATH_KEY\")");
        SUDO_PATH_KEY = key;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/execution/process/elevation/ElevationDaemonProcessLauncher$Companion;", "", "()V", "SUDO_PATH_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "intellij.platform.elevation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

