/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.IdeaWatchdog;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    public static final Logger LOG = Logger.getInstance(RemoteProcessSupport.class);
    private final Class<EntryPoint> myValueClass;
    private final AtomicReference<Heartbeat> myHeartbeatRef;
    private final Map<Pair<Target, Parameters>, Info> myProcMap;
    private final Map<Pair<Target, Parameters>, InProcessInfo<EntryPoint>> myInProcMap;

    public RemoteProcessSupport(@NotNull Class<EntryPoint> valueClass) {
        if (valueClass == null) {
            RemoteProcessSupport.$$$reportNull$$$0(0);
        }
        this.myHeartbeatRef = new AtomicReference();
        this.myProcMap = new HashMap<Pair<Target, Parameters>, Info>();
        this.myInProcMap = new HashMap<Pair<Target, Parameters>, InProcessInfo<EntryPoint>>();
        this.myValueClass = valueClass;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(@NotNull Target var1);

    protected void logText(@NotNull Parameters configuration2, @NotNull ProcessEvent event, @NotNull Key outputType) {
        if (configuration2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(1);
        }
        if (event == null) {
            RemoteProcessSupport.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            RemoteProcessSupport.$$$reportNull$$$0(3);
        }
        String text2 = StringUtil.notNullize((String)event.getText());
        if (outputType == ProcessOutputTypes.STDERR) {
            LOG.warn(text2.trim());
        } else {
            LOG.debug(text2.trim());
        }
    }

    public void stopAll() {
        this.stopAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll(boolean wait) {
        ArrayList<Info> infos = new ArrayList<Info>();
        Map<Pair<Target, Parameters>, Info> map2 = this.myProcMap;
        synchronized (map2) {
            for (Info o : this.myProcMap.values()) {
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (infos.isEmpty()) {
            return;
        }
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            if (wait) {
                for (Info o : infos) {
                    o.handler.waitFor();
                }
            }
        });
        if (wait) {
            try {
                future2.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (java.util.concurrent.ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target2) {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(4);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        Map<Pair<Target, Parameters>, Info> map2 = this.myProcMap;
        synchronized (map2) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target2) continue;
                result2.add(pair.second);
            }
        }
        if (RemoteObject.IN_PROCESS) {
            map2 = this.myInProcMap;
            synchronized (map2) {
                for (Pair<Target, Parameters> pair : this.myInProcMap.keySet()) {
                    if (pair.first != target2) continue;
                    result2.add(pair.second);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Target, Parameters>> getActiveConfigurations() {
        HashSet<Pair<Target, Parameters>> configurations;
        Map<Pair<Target, Parameters>, Info> map2 = this.myProcMap;
        synchronized (map2) {
            configurations = new HashSet<Pair<Target, Parameters>>(this.myProcMap.keySet());
        }
        if (RemoteObject.IN_PROCESS) {
            map2 = this.myInProcMap;
            synchronized (map2) {
                configurations.addAll(this.myInProcMap.keySet());
            }
        }
        return configurations;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public EntryPoint acquire(@NotNull Target target2, @NotNull Parameters configuration2) throws Exception {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(5);
        }
        if (configuration2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(6);
        }
        return this.acquire(target2, configuration2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPoint acquire(@NotNull Target target2, @NotNull Parameters configuration2, @Nullable ProgressIndicator indicator2) throws Exception {
        RunningInfo info2;
        Pair key;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(7);
        }
        if (configuration2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(8);
        }
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        EntryPoint inProcess = this.acquireInProcess(target2, configuration2);
        if (inProcess != null) {
            return inProcess;
        }
        Ref ref = Ref.create(null);
        if (!this.getExistingInfo((Ref<RunningInfo>)ref, key = Pair.create(target2, configuration2))) {
            this.startProcess(target2, configuration2, key);
            if (ref.isNull()) {
                try {
                    Ref ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            RemoteProcessSupport.checkIndicator(indicator2);
                        }
                    }
                }
                catch (InterruptedException e) {
                    RemoteProcessSupport.checkIndicator(indicator2);
                }
            }
        }
        if ((info2 = (RunningInfo)ref.get()) instanceof FailedInfo) {
            FailedInfo o = (FailedInfo)info2;
            String message2 = o.cause != null && StringUtil.isEmptyOrSpaces((String)o.stderr) ? o.cause.getMessage() : o.stderr;
            throw new ExecutionException(message2, o.cause);
        }
        if (info2 == null || info2.handler == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"dialog.remote.process.unable.to.acquire.remote.proxy.for", (Object[])new Object[]{this.getName(target2)}));
        }
        return this.acquire(info2);
    }

    private static void checkIndicator(@Nullable ProgressIndicator indicator2) {
        if (indicator2 != null) {
            indicator2.checkCanceled();
        } else {
            ProgressManager.checkCanceled();
        }
    }

    protected int publishPort(int port) {
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> release(@NotNull Target target2, @Nullable Parameters configuration2) {
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(9);
        }
        ArrayList<Info> infos = new ArrayList<Info>();
        Map<Pair<Target, Parameters>, Info> map2 = this.myProcMap;
        synchronized (map2) {
            for (Pair<Target, Parameters> key : this.myProcMap.keySet()) {
                if (key.first != target2 || configuration2 != null && key.second != configuration2) continue;
                Info o = this.myProcMap.get(key);
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (RemoteObject.IN_PROCESS) {
            map2 = this.myInProcMap;
            synchronized (map2) {
                Iterator<Pair<Target, Parameters>> it = this.myInProcMap.keySet().iterator();
                while (it.hasNext()) {
                    Pair<Target, Parameters> key;
                    key = it.next();
                    if (key.first != target2 || configuration2 != null && key.second != configuration2) continue;
                    it.remove();
                }
            }
        }
        Future<Object> future2 = infos.isEmpty() ? CompletableFuture.completedFuture(null) : ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            this.fireModificationCountChanged();
            for (Info o : infos) {
                o.handler.waitFor();
            }
        });
        if (future2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(10);
        }
        return future2;
    }

    private static void destroyProcessesImpl(@NotNull List<? extends Info> infos) {
        if (infos == null) {
            RemoteProcessSupport.$$$reportNull$$$0(11);
        }
        for (Info info2 : infos) {
            LOG.info("Terminating: " + info2);
            info2.handler.destroyProcess();
        }
    }

    private void startProcess(@NotNull Target target2, @NotNull Parameters configuration2, @NotNull Pair<Target, Parameters> key) {
        ProcessHandler processHandler2;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(12);
        }
        if (configuration2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(13);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(14);
        }
        ProgramRunner<RunnerSettings> runner = new ProgramRunner<RunnerSettings>(){

            @NotNull
            public String getRunnerId() {
                return "MyRunner";
            }

            public void execute(@NotNull ExecutionEnvironment environment2) throws ExecutionException {
                if (environment2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExecutionManager.getInstance((Project)environment2.getProject()).startRunProfile(environment2, state -> DefaultProgramRunnerKt.executeState(state, environment2, this));
            }

            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (profile == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canRun";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        try {
            RunProfileState state = this.getRunProfileState(target2, configuration2, executor);
            ExecutionResult result2 = state.execute(executor, (ProgramRunner)runner);
            processHandler2 = result2.getProcessHandler();
        }
        catch (Throwable e) {
            this.dropProcessInfo(key, e, null);
            return;
        }
        processHandler2.addProcessListener(this.getProcessListener(key));
        processHandler2.startNotify();
    }

    protected abstract RunProfileState getRunProfileState(@NotNull Target var1, @NotNull Parameters var2, @NotNull Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(@NotNull Ref<RunningInfo> ref, @NotNull Pair<Target, Parameters> key) {
        Info info2;
        if (ref == null) {
            RemoteProcessSupport.$$$reportNull$$$0(15);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(16);
        }
        Map<Pair<Target, Parameters>, Info> map2 = this.myProcMap;
        synchronized (map2) {
            info2 = this.myProcMap.get(key);
            try {
                while (info2 != null && (!(info2 instanceof RunningInfo) || info2.handler.isProcessTerminating() || info2.handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info2 = this.myProcMap.get(key);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info2 == null) {
                this.myProcMap.put(key, new PendingInfo(ref, null));
            }
        }
        if (info2 instanceof RunningInfo) {
            map2 = ref;
            synchronized (map2) {
                ref.set((Object)((RunningInfo)info2));
                ref.notifyAll();
            }
        }
        return info2 != null;
    }

    private EntryPoint acquire(RunningInfo info2) throws Exception {
        Object result2;
        info2.entryPointHardRef = result2 = RemoteUtil.executeWithClassLoader(() -> {
            Registry registry = LocateRegistry.getRegistry(info2.host, info2.port);
            Remote remote = Objects.requireNonNull(registry.lookup(info2.name));
            if (this.myValueClass.isInstance(remote)) {
                EntryPoint entryPoint = this.myValueClass.cast(remote);
                return RemoteUtil.substituteClassLoader(entryPoint, (ClassLoader)this.myValueClass.getClassLoader());
            }
            return RemoteUtil.castToLocal((Object)remote, this.myValueClass);
        }, (ClassLoader)this.getClass().getClassLoader());
        return (EntryPoint)result2;
    }

    private ProcessListener getProcessListener(final @NotNull Pair<Target, Parameters> key) {
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(17);
        }
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProcessHandler processHandler2 = event.getProcessHandler();
                processHandler2.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, (Object)Boolean.TRUE);
                Map map2 = RemoteProcessSupport.this.myProcMap;
                synchronized (map2) {
                    Info o = RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        RemoteProcessSupport.this.myProcMap.put(key, new PendingInfo(((PendingInfo)o).ref, processHandler2));
                    }
                }
                RemoteProcessSupport.this.sendDataAfterStart(processHandler2);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
                RemoteProcessSupport.this.onProcessTerminated(event);
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                Heartbeat heartbeat2;
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
                if ((heartbeat2 = RemoteProcessSupport.this.myHeartbeatRef.get()) != null) {
                    heartbeat2.stopBeat();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                PendingInfo info2;
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(4);
                }
                String text2 = StringUtil.notNullize((String)event.getText());
                RemoteProcessSupport.this.logText(key.second, event, outputType);
                RunningInfo result2 = null;
                Map map2 = RemoteProcessSupport.this.myProcMap;
                synchronized (map2) {
                    Info o = RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        info2 = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String prefix2 = "Port/ServicesPort/ID:";
                            if (text2.startsWith(prefix2)) {
                                List data2 = StringUtil.split((String)text2.substring(prefix2.length()).trim(), (String)"/");
                                int port = Integer.parseInt((String)data2.get(0));
                                int servicesPort = Integer.parseInt((String)data2.get(1));
                                String id2 = (String)data2.get(2);
                                result2 = new RunningInfo(info2.handler, RemoteProcessSupport.this.getRemoteHost(), RemoteProcessSupport.this.publishPort(port), id2, RemoteProcessSupport.this.publishPort(servicesPort));
                                RemoteProcessSupport.this.myProcMap.put(key, result2);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info2.stderr.append(text2);
                        }
                    } else {
                        info2 = null;
                    }
                }
                if (result2 != null) {
                    map2 = info2.ref;
                    synchronized (map2) {
                        info2.ref.set(result2);
                        info2.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    try {
                        Heartbeat heartbeat2 = new Heartbeat(result2.host, result2.port);
                        heartbeat2.startBeat();
                        RemoteProcessSupport.this.myHeartbeatRef.set(heartbeat2);
                    }
                    catch (Throwable e) {
                        LOG.warn("The cook failed to start due to " + ExceptionUtil.getRootCause((Throwable)e));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void onProcessTerminated(ProcessEvent event) {
    }

    protected void sendDataAfterStart(ProcessHandler handler2) {
    }

    protected String getRemoteHost() {
        return (String)ObjectUtils.notNull((Object)System.getProperty("java.rmi.server.hostname"), (Object)"127.0.0.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropProcessInfo(Pair<Target, Parameters> key, @Nullable Throwable error2, @Nullable ProcessHandler handler2) {
        Info info2;
        Map<Pair<Target, Parameters>, Info> map2 = this.myProcMap;
        synchronized (map2) {
            info2 = this.myProcMap.get(key);
            if (info2 != null && (handler2 == null || info2.handler == handler2)) {
                this.myProcMap.remove(key);
                this.myProcMap.notifyAll();
            } else {
                info2 = null;
            }
        }
        if (info2 instanceof PendingInfo) {
            PendingInfo pendingInfo = (PendingInfo)info2;
            if (error2 != null || pendingInfo.stderr.length() > 0 || pendingInfo.ref.isNull()) {
                pendingInfo.ref.set((Object)new FailedInfo(error2, pendingInfo.stderr.toString()));
            }
            Ref<RunningInfo> ref = pendingInfo.ref;
            synchronized (ref) {
                pendingInfo.ref.notifyAll();
            }
        }
        return info2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EntryPoint acquireInProcess(@NotNull Target target2, @NotNull Parameters configuration2) throws Exception {
        InProcessInfo<EntryPoint> info2;
        if (target2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(18);
        }
        if (configuration2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(19);
        }
        if (!RemoteObject.IN_PROCESS) {
            return null;
        }
        Pair key = Pair.create(target2, configuration2);
        Map<Pair<Target, Parameters>, InProcessInfo<EntryPoint>> map2 = this.myInProcMap;
        synchronized (map2) {
            info2 = this.myInProcMap.get(key);
            if (info2 == null) {
                info2 = new InProcessInfo<EntryPoint>(this.acquireInProcessFactory(target2, configuration2));
                this.myInProcMap.put(key, info2);
            }
        }
        return (EntryPoint)info2.factory.compute();
    }

    protected @NotNull ThrowableComputable<@Nullable EntryPoint, Exception> acquireInProcessFactory(Target target2, Parameters configuration2) throws Exception {
        ThrowableComputable throwableComputable = () -> null;
        if (throwableComputable == null) {
            RemoteProcessSupport.$$$reportNull$$$0(20);
        }
        return throwableComputable;
    }

    static {
        RemoteServer.setupRMI((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "release";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireInProcessFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 10: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcessesImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExistingInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProcessListener";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "acquireInProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Heartbeat {
        private final Registry myRegistry;
        private boolean live = true;
        private ScheduledFuture<?> myFuture = null;

        Heartbeat(String host, int port) throws RemoteException {
            this.myRegistry = LocateRegistry.getRegistry(host, port);
        }

        void stopBeat() {
            if (this.myFuture != null) {
                this.myFuture.cancel(false);
            }
        }

        void startBeat() {
            this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> {
                try {
                    if (this.live) {
                        IdeaWatchdog watchdog = this.getWatchdog();
                        watchdog.ping();
                    }
                }
                catch (Exception ignore) {
                    this.live = false;
                    this.myFuture.cancel(false);
                }
                catch (Throwable t) {
                    this.live = false;
                    this.myFuture.cancel(false);
                    LOG.error(t);
                }
            }, 9000L, 9000L, TimeUnit.MILLISECONDS);
            Disposer.register((Disposable)ApplicationManager.getApplication(), () -> this.myFuture.cancel(false));
        }

        @TestOnly
        public void kill(int exitCode) {
            try {
                this.getWatchdog().dieNow(exitCode);
            }
            catch (NotBoundException | RemoteException exception) {
                // empty catch block
            }
        }

        private IdeaWatchdog getWatchdog() throws RemoteException, NotBoundException {
            Remote remote = this.myRegistry.lookup("_LIVE_PULSE_");
            if (remote instanceof IdeaWatchdog) {
                return (IdeaWatchdog)remote;
            }
            return (IdeaWatchdog)RemoteUtil.castToLocal((Object)remote, IdeaWatchdog.class);
        }
    }

    private static class InProcessInfo<EntryPoint>
    extends Info {
        final ThrowableComputable<EntryPoint, Exception> factory;

        InProcessInfo(ThrowableComputable<EntryPoint, Exception> factory2) {
            super(null);
            this.factory = factory2;
        }

        public String toString() {
            return "InProcessInfo{" + Integer.toHexString(this.hashCode()) + "}";
        }
    }

    private static class FailedInfo
    extends RunningInfo {
        final Throwable cause;
        @NlsSafe
        final String stderr;

        FailedInfo(Throwable cause, String stderr) {
            super(null, null, -1, null);
            this.cause = cause;
            this.stderr = stderr;
        }

        @Override
        public String toString() {
            return "FailedInfo{" + this.cause + "}";
        }
    }

    private static class RunningInfo
    extends Info {
        final String host;
        final int port;
        final String name;
        final int servicesPort;
        Object entryPointHardRef;

        RunningInfo(ProcessHandler handler2, String host, int port, String name) {
            this(handler2, host, port, name, 0);
        }

        RunningInfo(ProcessHandler handler2, String host, int port, String name, int servicesPort) {
            super(handler2);
            this.host = host;
            this.port = port;
            this.name = name;
            this.servicesPort = servicesPort;
        }

        public String toString() {
            return this.host + ":" + this.port + "/" + this.name;
        }
    }

    private static class PendingInfo
    extends Info {
        final Ref<RunningInfo> ref;
        final StringBuilder stderr = new StringBuilder();

        PendingInfo(Ref<RunningInfo> ref, ProcessHandler handler2) {
            super(handler2);
            this.ref = ref;
        }

        public String toString() {
            return "PendingInfo{" + this.ref.get() + "}";
        }
    }

    private static class Info {
        final ProcessHandler handler;

        Info(ProcessHandler handler2) {
            this.handler = handler2;
        }
    }
}

