/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMPoolOfTestIcons;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestsPresentationUtil {
    @NonNls
    private static final String DOUBLE_SPACE = "  ";
    @NonNls
    private static final String UNKNOWN_TESTS_COUNT = "<...>";
    @NonNls
    static final String DEFAULT_TESTS_CATEGORY = "Tests";

    private TestsPresentationUtil() {
    }

    @Nls
    public static String getProgressStatus_Text(long startTime, long endTime, int testsTotal, int testsCount, int failuresCount, @Nullable Set<String> allCategories, boolean isFinished) {
        @Nls StringBuilder sb = new StringBuilder();
        if (endTime == 0L) {
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running", new Object[0]));
        } else {
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.done", new Object[0]));
        }
        if (allCategories != null && TestsPresentationUtil.hasNonDefaultCategories(allCategories)) {
            sb.append(' ');
            boolean first = true;
            for (String category : allCategories) {
                if (StringUtil.isEmpty((String)category)) continue;
                if (!first) {
                    sb.append(", ");
                }
                char firstChar = category.charAt(0);
                sb.append(first ? firstChar : Character.toLowerCase(firstChar));
                sb.append(category.substring(1));
                first = false;
            }
        }
        sb.append(' ').append(testsCount).append(' ');
        sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.of", new Object[0]));
        sb.append(' ').append(testsTotal != 0 ? Integer.valueOf(testsTotal) : (!isFinished ? UNKNOWN_TESTS_COUNT : Integer.valueOf(0)));
        if (failuresCount > 0) {
            sb.append(DOUBLE_SPACE);
            sb.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.failed", new Object[0]));
            sb.append(' ').append(failuresCount);
        }
        if (endTime != 0L) {
            long time = endTime - startTime;
            sb.append(DOUBLE_SPACE);
            sb.append('(').append(NlsMessages.formatDurationApproximateNarrow((long)time)).append(')');
        }
        sb.append(DOUBLE_SPACE);
        return sb.toString();
    }

    public static boolean hasNonDefaultCategories(@Nullable Set<String> allCategories) {
        if (allCategories == null) {
            return false;
        }
        return allCategories.size() > 1 || allCategories.size() == 1 && !DEFAULT_TESTS_CATEGORY.equals(allCategories.iterator().next());
    }

    public static void formatRootNodeWithChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer2) {
        renderer2.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer2.getConsoleProperties()));
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        String presentableName = testProxy.getPresentation();
        String text2 = presentableName != null ? presentableName : (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.running.tests", new Object[0]) : (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]) : SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.results", new Object[0])));
        renderer2.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String comment = testProxy.getComment();
        if (comment != null) {
            renderer2.append(" (" + comment + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public static void formatRootNodeWithoutChildren(SMTestProxy.SMRootTestProxy testProxy, TestTreeRenderer renderer2) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
            if (!testProxy.getChildren().isEmpty()) {
                TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer2);
            } else {
                renderer2.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer2.getConsoleProperties()));
                renderer2.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.instantiating.tests", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        } else if (magnitude == TestStateInfo.Magnitude.NOT_RUN_INDEX) {
            renderer2.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer2.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.not.test.results", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX) {
            renderer2.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            renderer2.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.PASSED_INDEX) {
            renderer2.setIcon(PoolOfTestIcons.PASSED_ICON);
            renderer2.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.tests.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.IGNORED_INDEX && !testProxy.hasErrors()) {
            renderer2.setIcon(PoolOfTestIcons.IGNORED_ICON);
            renderer2.append(SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.all.but.ignored.passed", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (!testProxy.getChildren().isEmpty()) {
            TestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer2);
        } else {
            renderer2.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer2.append(testProxy.isTestsReporterAttached() ? SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", new Object[0]) : SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void formatTestProxy(SMTestProxy testProxy, TestTreeRenderer renderer2) {
        renderer2.setIcon(TestsPresentationUtil.getIcon(testProxy, renderer2.getConsoleProperties()));
        renderer2.append(testProxy.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public static String getPresentableName(SMTestProxy testProxy) {
        String parentName;
        SMTestProxy parent = testProxy.getParent();
        String name = testProxy.getName();
        if (name == null) {
            String string = Holder.getNoNameTest();
            if (string == null) {
                TestsPresentationUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String presentationCandidate = name;
        if (parent != null && !testProxy.isSuite() && (parentName = parent.getName()) != null) {
            String comment;
            String presentation2;
            boolean parentStartsWith = name.startsWith(parentName);
            if (!parentStartsWith && parent instanceof SMTestProxy.SMRootTestProxy && (presentation2 = ((SMTestProxy.SMRootTestProxy)parent).getPresentation()) != null && !(parentStartsWith = name.startsWith(parentName = presentation2)) && (comment = ((SMTestProxy.SMRootTestProxy)parent).getComment()) != null) {
                parentName = StringUtil.getQualifiedName((String)comment, (String)presentation2);
                parentStartsWith = name.startsWith(parentName);
            }
            if (parentStartsWith) {
                presentationCandidate = name.substring(parentName.length());
                presentationCandidate = StringUtil.trimStart((String)presentationCandidate, (String)".");
            }
        }
        presentationCandidate = presentationCandidate.trim();
        if (StringUtil.isEmpty((String)(presentationCandidate = presentationCandidate.replaceAll("\\s+", " ")))) {
            String string = Holder.getNoNameTest();
            if (string == null) {
                TestsPresentationUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = presentationCandidate;
        if (string == null) {
            TestsPresentationUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getPresentableNameTrimmedOnly(@NotNull SMTestProxy testProxy) {
        String name;
        if (testProxy == null) {
            TestsPresentationUtil.$$$reportNull$$$0(3);
        }
        if ((name = testProxy.getName()) != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            name = Holder.getNoNameTest();
        }
        String string = name;
        if (string == null) {
            TestsPresentationUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static Icon getIcon(SMTestProxy testProxy, TestConsoleProperties consoleProperties) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        boolean hasErrors = testProxy.hasErrors();
        boolean hasPassedTests = testProxy.hasPassedTests();
        switch (magnitude) {
            case ERROR_INDEX: {
                return SMPoolOfTestIcons.ERROR_ICON;
            }
            case FAILED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.FAILED_E_ICON : SMPoolOfTestIcons.FAILED_ICON;
            }
            case IGNORED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.IGNORED_E_ICON : (hasPassedTests ? SMPoolOfTestIcons.PASSED_IGNORED : SMPoolOfTestIcons.IGNORED_ICON);
            }
            case NOT_RUN_INDEX: {
                return SMPoolOfTestIcons.NOT_RAN;
            }
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.PASSED_E_ICON : SMPoolOfTestIcons.PASSED_ICON;
            }
            case RUNNING_INDEX: {
                if (consoleProperties.isPaused()) {
                    return hasErrors ? SMPoolOfTestIcons.PAUSED_E_ICON : AllIcons.RunConfigurations.TestPaused;
                }
                return hasErrors ? SMPoolOfTestIcons.RUNNING_E_ICON : SMPoolOfTestIcons.RUNNING_ICON;
            }
            case SKIPPED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.SKIPPED_E_ICON : SMPoolOfTestIcons.SKIPPED_ICON;
            }
            case TERMINATED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.TERMINATED_E_ICON : SMPoolOfTestIcons.TERMINATED_ICON;
            }
        }
        return null;
    }

    @Nullable
    public static String getTestStatusPresentation(SMTestProxy proxy) {
        return proxy.getMagnitudeInfo().getTitle();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/sm/runner/ui/TestsPresentationUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/sm/runner/ui/TestsPresentationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableNameTrimmedOnly";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableNameTrimmedOnly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private Holder() {
        }

        private static String getNoNameTest() {
            return SmRunnerBundle.message("sm.test.runner.ui.tests.tree.presentation.labels.test.noname", new Object[0]);
        }
    }
}

