/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.AboutPopupDescriptionProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.AboutPopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AboutDialog
extends DialogWrapper {
    private final List<String> myInfo = new ArrayList<String>();

    public AboutDialog(Project project) {
        this(project, false);
    }

    public AboutDialog(Project project, boolean showDebugInfo) {
        super(project, false);
        String appName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.setResizable(false);
        this.setTitle(IdeBundle.message((String)"about.popup.about.app", (Object[])new Object[]{appName}));
        this.init();
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                AboutDialog.this.copyAboutInfoToClipboard();
                AboutDialog.this.close(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/AboutDialog$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"meta C", "control C"}), this.getContentPanel(), this.getDisposable());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        Icon appIcon = AppUIUtil.loadApplicationIcon(ScaleContext.create(), 60);
        Box box2 = this.getText();
        JLabel icon2 = new JLabel(appIcon);
        icon2.setVerticalAlignment(1);
        icon2.setBorder((Border)JBUI.Borders.empty((int)20, (int)12, (int)0, (int)24));
        box2.setBorder((Border)JBUI.Borders.empty((int)20, (int)0, (int)0, (int)20));
        return JBUI.Panels.simplePanel().addToLeft((Component)icon2).addToCenter((Component)box2);
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myCancelAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"button.copy", (Object[])new Object[0])){
            {
                this.putValue("ShortDescription", IdeBundle.message((String)"description.copy.text.to.clipboard", (Object[])new Object[0]));
            }

            protected void doAction(ActionEvent e) {
                AboutDialog.this.copyAboutInfoToClipboard();
                AboutDialog.this.close(0);
            }
        };
    }

    private void copyAboutInfoToClipboard() {
        try {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.getExtendedAboutText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getExtendedAboutText() {
        return StringUtil.join(this.myInfo, (String)"\n") + "\n" + AboutPopup.getExtraInfo();
    }

    @NonNls
    private Box getText() {
        Box lines2 = Box.createVerticalBox();
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        Object appName = appInfo.getFullApplicationName();
        String edition = ApplicationNamesInfo.getInstance().getEditionName();
        if (edition != null) {
            appName = (String)appName + " (" + edition + ")";
        }
        this.addLine(lines2, (String)appName, JBFont.h3().asBold());
        lines2.add(Box.createVerticalStrut(10));
        Object buildInfo = IdeBundle.message((String)"about.box.build.number", (Object[])new Object[]{appInfo.getBuild().asString()});
        Date timestamp = appInfo.getBuildDate().getTime();
        buildInfo = appInfo.getBuild().isSnapshot() ? (String)buildInfo + IdeBundle.message((String)"about.box.build.date.time", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)timestamp), new SimpleDateFormat("HH:mm").format(timestamp)}) : (String)buildInfo + IdeBundle.message((String)"about.box.build.date", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)timestamp)});
        this.addLine(lines2, (String)buildInfo);
        AboutDialog.addEmptyLine(lines2);
        LicensingFacade la = LicensingFacade.getInstance();
        if (la != null) {
            String licensedTo = la.getLicensedToMessage();
            if (licensedTo != null) {
                this.addLine(lines2, licensedTo);
            }
            la.getLicenseRestrictionsMessages().forEach(text2 -> this.addLine(lines2, (String)text2));
        }
        AboutDialog.addEmptyLine(lines2);
        Properties properties = System.getProperties();
        String javaVersion = properties.getProperty("java.runtime.version", properties.getProperty("java.version", "unknown"));
        String arch = properties.getProperty("os.arch", "");
        String jreInfo = IdeBundle.message((String)"about.box.jre", (Object[])new Object[]{javaVersion, arch});
        this.addLine(lines2, jreInfo);
        String vmVersion = properties.getProperty("java.vm.name", "unknown");
        String vmVendor = properties.getProperty("java.vendor", "unknown");
        String vmVendorInfo = IdeBundle.message((String)"about.box.vm", (Object[])new Object[]{vmVersion, vmVendor});
        this.addLine(lines2, vmVendorInfo);
        AboutDialog.addEmptyLine(lines2);
        ExtensionPointName ep2 = new ExtensionPointName("com.intellij.aboutPopupDescriptionProvider");
        for (AboutPopupDescriptionProvider aboutInfoProvider : (AboutPopupDescriptionProvider[])ep2.getExtensions()) {
            String description2 = aboutInfoProvider.getDescription();
            if (description2 == null) continue;
            this.addLineWithoutLog(lines2, description2);
            AboutDialog.addEmptyLine(lines2);
        }
        HyperlinkLabel openSourceSoftware = new HyperlinkLabel();
        openSourceSoftware.setTextWithHyperlink(IdeBundle.message((String)"about.box.powered.by.open.source", (Object[])new Object[0]));
        openSourceSoftware.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                AboutPopup.showOpenSoftwareSources((String)ObjectUtils.notNull((Object)AboutPopup.loadThirdPartyLibraries(), (Object)""));
            }
        });
        openSourceSoftware.setFont((Font)AboutDialog.getDefaultTextFont());
        JBLabel poweredBy = new JBLabel(IdeBundle.message((String)"about.box.powered.by", (Object[])new Object[0]) + " ").withFont(AboutDialog.getDefaultTextFont());
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)openSourceSoftware).addToLeft((Component)poweredBy);
        panel2.setAlignmentX(0.0f);
        lines2.add((Component)panel2);
        this.addLineWithoutLog(lines2, AboutPopup.getCopyrightText());
        AboutDialog.addEmptyLine(lines2);
        return lines2;
    }

    private static JBFont getDefaultTextFont() {
        return JBFont.medium();
    }

    private static void addEmptyLine(Box box2) {
        box2.add(Box.createVerticalStrut(18));
    }

    private void addLine(JComponent panel2, @NlsContexts.Label String text2, JBFont font) {
        this.addLine(panel2, text2, font, true);
    }

    private void addLine(JComponent panel2, @NlsContexts.Label String text2, JBFont font, boolean log) {
        JBLabel label2 = new JBLabel(text2).withFont(font);
        panel2.add((Component)label2);
        if (log) {
            this.myInfo.add(text2);
        }
    }

    private void addLineWithoutLog(JComponent panel2, @NlsContexts.Label String text2) {
        this.addLine(panel2, text2, AboutDialog.getDefaultTextFont(), false);
    }

    private void addLine(JComponent panel2, @NlsContexts.Label String text2) {
        this.addLine(panel2, text2, AboutDialog.getDefaultTextFont());
    }
}

