/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.troubleshooting.CompositeGeneralTroubleInfoCollector;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.Compressor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectZippedLogsAction
extends AnAction
implements DumbAware {
    private static final String CONFIRMATION_DIALOG = "zipped.logs.action.show.confirmation.dialog";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        boolean doNotShowDialog = PropertiesComponent.getInstance().getBoolean(CONFIRMATION_DIALOG);
        if (!doNotShowDialog && !((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)IdeBundle.message((String)"dialog.title.sensitive.data", (Object[])new Object[0]), (String)IdeBundle.message((String)"message.included.logs.and.settings.may.contain.sensitive.data", (Object[])new Object[0])).yesText(IdeBundle.message((String)"button.show.in.file.manager", (Object[])new Object[]{RevealFileAction.getFileManagerName()}))).noText(CommonBundle.getCancelButtonText())).icon(Messages.getWarningIcon())).doNotAsk((DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean selected2, int exitCode) {
                PropertiesComponent.getInstance().setValue(CollectZippedLogsAction.CONFIRMATION_DIALOG, selected2);
            }
        })).ask(project)) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                File zippedLogsFile = CollectZippedLogsAction.createZip(project, compressor -> {});
                if (RevealFileAction.isSupported()) {
                    RevealFileAction.openFile(zippedLogsFile);
                } else {
                    Notification logNotification = new Notification(Holder.NOTIFICATION_GROUP.getDisplayId(), "", IdeBundle.message((String)"notification.content.log.file.is.created.0", (Object[])new Object[]{zippedLogsFile.getAbsolutePath()}), NotificationType.INFORMATION);
                    Notifications.Bus.notify((Notification)logNotification);
                }
            }
            catch (IOException exception) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn((Throwable)exception);
                Notification errorNotification = new Notification(Holder.NOTIFICATION_GROUP.getDisplayId(), "", IdeBundle.message((String)"notification.content.can.t.create.zip.file.with.logs.0", (Object[])new Object[]{exception.getLocalizedMessage()}), NotificationType.ERROR);
                Notifications.Bus.notify((Notification)errorNotification);
            }
        }, IdeBundle.message((String)"progress.title.collecting.logs", (Object[])new Object[0]), true, project);
    }

    @NotNull
    @ApiStatus.Internal
    public static File createZip(@Nullable Project project, @NotNull @NotNull Consumer<? super @NotNull Compressor> additionalFiles) throws IOException {
        if (additionalFiles == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(1);
        }
        PerformanceWatcher.getInstance().dumpThreads("", false);
        String productName = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getLowercaseProductName());
        File zippedLogsFile = FileUtil.createTempFile((String)(productName + "-logs-" + CollectZippedLogsAction.getDate()), (String)".zip");
        try (Compressor.Zip zip = new Compressor.Zip(zippedLogsFile);){
            ProgressManager.checkCanceled();
            additionalFiles.accept((Compressor)zip);
            ProgressManager.checkCanceled();
            zip.addDirectory(new File(PathManager.getLogPath()));
            StringBuilder troubleshooting = CollectZippedLogsAction.collectInfoFromExtensions(project);
            if (troubleshooting != null) {
                ProgressManager.checkCanceled();
                zip.addFile("troubleshooting.txt", troubleshooting.toString().getBytes(StandardCharsets.UTF_8));
            }
            for (File javaErrorLog : CollectZippedLogsAction.getJavaErrorLogs()) {
                ProgressManager.checkCanceled();
                zip.addFile(javaErrorLog.getName(), javaErrorLog);
            }
        }
        catch (Exception exception) {
            FileUtil.delete((File)zippedLogsFile);
            throw exception;
        }
        File file2 = zippedLogsFile;
        if (file2 == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(2);
        }
        return file2;
    }

    @Nullable
    private static StringBuilder collectInfoFromExtensions(@Nullable Project project) {
        StringBuilder settings2 = null;
        if (project != null) {
            settings2 = new StringBuilder();
            settings2.append(new CompositeGeneralTroubleInfoCollector().collectInfo(project));
            for (TroubleInfoCollector troubleInfoCollector : (TroubleInfoCollector[])TroubleInfoCollector.EP_SETTINGS.getExtensions()) {
                settings2.append(troubleInfoCollector.collectInfo(project)).append('\n');
            }
        }
        return settings2;
    }

    private static File[] getJavaErrorLogs() {
        return new File(SystemProperties.getUserHome()).listFiles(file2 -> file2.isFile() && (file2.getName().startsWith("java_error_in") || file2.getName().startsWith("jbr_err_pid")) && !file2.getName().endsWith("hprof"));
    }

    @NotNull
    private static String getDate() {
        String string = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        if (string == null) {
            CollectZippedLogsAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CollectZippedLogsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CollectZippedLogsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createZip";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createZip";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Holder {
        private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Collect Zipped Logs", NotificationDisplayType.BALLOON, true);

        private Holder() {
        }
    }
}

