/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteAction
extends AnAction
implements DumbAware,
LightEditCompatible {
    private static final Logger LOG = Logger.getInstance(DeleteAction.class);

    public DeleteAction() {
    }

    public DeleteAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description2, Icon icon2) {
        super(text2, description2, icon2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        DeleteProvider provider2;
        if (e == null) {
            DeleteAction.$$$reportNull$$$0(0);
        }
        if ((provider2 = this.getDeleteProvider(dataContext = e.getDataContext())) == null) {
            return;
        }
        try {
            provider2.deleteElement(dataContext);
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    @Nullable
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        return (DeleteProvider)PlatformDataKeys.DELETE_ELEMENT_PROVIDER.getData(dataContext);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean canDelete;
        if (e == null) {
            DeleteAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation2.setText(IdeBundle.messagePointer((String)"action.delete.ellipsis", (Object[])new Object[0]));
        } else {
            presentation2.setText(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
        }
        if (e.isFromActionToolbar() && e.getPresentation().getIcon() == null) {
            e.getPresentation().setIcon(IconUtil.getRemoveIcon());
        }
        if (e.getProject() == null) {
            presentation2.setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        DeleteProvider provider2 = this.getDeleteProvider(dataContext);
        if (e.getInputEvent() instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
            Object component2 = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component2 instanceof JTextComponent) {
                provider2 = null;
            }
            if (keyEvent.getKeyCode() == 8) {
                String activeSpeedSearchFilter;
                SpeedSearchSupply searchSupply;
                if (component2 instanceof JComponent && (searchSupply = SpeedSearchSupply.getSupply((JComponent)((JComponent)component2))) != null) {
                    provider2 = null;
                }
                if (!StringUtil.isEmpty((String)(activeSpeedSearchFilter = (String)SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.getData(dataContext)))) {
                    provider2 = null;
                }
            }
        }
        if (provider2 instanceof TitledHandler) {
            presentation2.setText(((TitledHandler)provider2).getActionTitle());
        }
        boolean bl = canDelete = provider2 != null && provider2.canDeleteElement(dataContext);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation2.setVisible(canDelete);
        } else {
            presentation2.setEnabled(canDelete);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/DeleteAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

