/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J*\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/actions/MnemonicIcon;", "Ljavax/swing/Icon;", "icon", "mnemonic", "", "selected", "", "(Ljavax/swing/Icon;Ljava/lang/String;Z)V", "getIcon", "()Ljavax/swing/Icon;", "getMnemonic", "()Ljava/lang/String;", "getSelected", "()Z", "size", "", "width", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "intellij.platform.ide.impl"})
final class MnemonicIcon
implements Icon {
    private final int size;
    private final int width;
    @Nullable
    private final Icon icon;
    @Nullable
    private final String mnemonic;
    private final boolean selected;

    @Override
    public int getIconWidth() {
        return this.size + this.width;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Icon icon2 = RenderingUtil.getIcon((Icon)this.icon, (boolean)this.selected);
        if (icon2 != null) {
            object = icon2;
            bl = false;
            boolean bl2 = false;
            Icon it = object;
            boolean bl3 = false;
            Icon icon3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"it");
            int dx = x + (this.size - icon3.getIconWidth()) / 2;
            int dy = y + (this.size - it.getIconHeight()) / 2;
            it.paintIcon(c, g, dx, dy);
        }
        if (g instanceof Graphics2D) {
            String string = this.mnemonic;
            if (string != null) {
                object = string;
                bl = false;
                if (!(object.length() == 0)) {
                    Font font = EditorFontType.PLAIN.getGlobalFont().deriveFont(0.8f * (float)this.size);
                    ((Graphics2D)g).setFont(font);
                    bl = this.selected;
                    ((Graphics2D)g).setPaint(bl ? (Paint)JBUI.CurrentTheme.List.foreground((boolean)true, (boolean)true) : (Paint)JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND);
                    UISettings.Companion.setupAntialiasing(g);
                    FontMetrics metrics = ((Graphics2D)g).getFontMetrics();
                    int w = metrics.stringWidth(this.mnemonic);
                    int dx = x + this.size - (w - this.width) / 2;
                    FontMetrics fontMetrics = metrics;
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"metrics");
                    int dy = y + this.size - fontMetrics.getDescent();
                    g.drawString(this.mnemonic, dx, dy);
                    if (SystemInfo.isWindows) {
                        EffectPainter.LINE_UNDERSCORE.paint((Graphics2D)g, dx, dy, w, metrics.getDescent(), (Object)font);
                    }
                }
            }
        }
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public final String getMnemonic() {
        return this.mnemonic;
    }

    public final boolean getSelected() {
        return this.selected;
    }

    public MnemonicIcon(@Nullable Icon icon2, @Nullable String mnemonic, boolean selected2) {
        int n;
        this.icon = icon2;
        this.mnemonic = mnemonic;
        this.selected = selected2;
        this.size = JBUI.scale((int)16);
        MnemonicIcon mnemonicIcon = this;
        String string = this.mnemonic;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            MnemonicIcon mnemonicIcon2 = mnemonicIcon;
            boolean bl3 = false;
            int n2 = JBUI.scale((int)10);
            mnemonicIcon = mnemonicIcon2;
            n = n2;
        } else {
            n = 0;
        }
        mnemonicIcon.width = n;
    }
}

