/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class StartUseVcsDialog
extends DialogWrapper {
    @NonNls
    private static final String GIT = "Git";
    private final ComboBox<AbstractVcs> myVcsCombo;
    private static final Comparator<AbstractVcs> VCS_COMPARATOR = Comparator.comparingInt(vcs -> GIT.equals(vcs.getName()) ? -1 : 0).thenComparing(vcs -> vcs.getDisplayName(), String.CASE_INSENSITIVE_ORDER);

    StartUseVcsDialog(@NotNull Project project) {
        if (project == null) {
            StartUseVcsDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        Object[] vcses = ProjectLevelVcsManager.getInstance((Project)project).getAllSupportedVcss();
        ContainerUtil.sort((Object[])vcses, VCS_COMPARATOR);
        this.myVcsCombo = new ComboBox(vcses);
        this.myVcsCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", AbstractVcs::getDisplayName));
        this.setTitle(VcsBundle.message((String)"dialog.enable.version.control.integration.title", (Object[])new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVcsCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.select.vcs.label.text", (Object[])new Object[0]));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.insets((int)5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridx;
        mainPanel.add((Component)this.myVcsCombo, gb);
        String path2 = SystemInfo.isMac ? VcsBundle.message((String)"vcs.settings.path.mac", (Object[])new Object[0]) : VcsBundle.message((String)"vcs.settings.path", (Object[])new Object[0]);
        JLabel helpText = new JLabel(VcsBundle.message((String)"dialog.enable.version.control.integration.hint.text", (Object[])new Object[0]) + path2);
        helpText.setUI((LabelUI)new MultiLineLabelUI());
        helpText.setForeground(UIUtil.getInactiveTextColor());
        gb.anchor = 18;
        gb.gridx = 0;
        ++gb.gridy;
        gb.gridwidth = 2;
        mainPanel.add((Component)helpText, gb);
        JPanel wrapper2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0);
        wrapper2.add((Component)mainPanel, gbc);
        return wrapper2;
    }

    protected String getHelpId() {
        return "reference.version.control.enable.version.control.integration";
    }

    @NotNull
    AbstractVcs getVcs() {
        AbstractVcs abstractVcs = (AbstractVcs)this.myVcsCombo.getItem();
        if (abstractVcs == null) {
            StartUseVcsDialog.$$$reportNull$$$0(1);
        }
        return abstractVcs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/StartUseVcsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/StartUseVcsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

