/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.util.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupedSearchListModel
extends SearchListModel {
    GroupedSearchListModel() {
    }

    public boolean hasMoreElements(SearchEverywhereContributor contributor) {
        return this.listElements.stream().anyMatch(info2 -> info2.getElement() == MORE_ELEMENT && info2.getContributor() == contributor);
    }

    @Override
    public void addElements(List<? extends SearchEverywhereFoundElementInfo> items) {
        if (items.isEmpty()) {
            return;
        }
        HashMap<SearchEverywhereContributor, List> itemsMap = new HashMap<SearchEverywhereContributor, List>();
        items.forEach(info2 -> {
            List list2 = itemsMap.computeIfAbsent(info2.getContributor(), contributor -> new ArrayList());
            list2.add(info2);
        });
        itemsMap.forEach((contributor, list2) -> list2.sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed()));
        if (this.resultsExpired) {
            this.retainContributors(itemsMap.keySet());
            this.clearMoreItems();
            itemsMap.forEach((contributor, list2) -> {
                Range<Integer> range2 = this.getRangeForContributor((SearchEverywhereContributor<?>)contributor);
                if (range2 != null) {
                    this.listElements.subList((Integer)range2.getFrom(), (Integer)range2.getTo() + 1).clear();
                    this.fireIntervalRemoved(this, (Integer)range2.getFrom(), (Integer)range2.getTo());
                }
                int insertionPoint = range2 != null ? ((Integer)range2.getFrom()).intValue() : this.getInsertionPoint((SearchEverywhereContributor)contributor);
                this.listElements.addAll(insertionPoint, list2);
                this.fireIntervalAdded(this, insertionPoint, insertionPoint + list2.size() - 1);
            });
            this.resultsExpired = false;
        } else {
            itemsMap.forEach((contributor, list2) -> {
                int startIndex = this.contributors().indexOf(contributor);
                int insertionIndex = this.getInsertionPoint((SearchEverywhereContributor)contributor);
                int endIndex = insertionIndex + list2.size() - 1;
                this.listElements.addAll(insertionIndex, list2);
                this.fireIntervalAdded(this, insertionIndex, endIndex);
                if (startIndex >= 0) {
                    this.listElements.subList(startIndex, endIndex + 1).sort(Comparator.comparingInt(SearchEverywhereFoundElementInfo::getPriority).reversed());
                    this.fireContentsChanged(this, startIndex, endIndex);
                }
            });
        }
    }

    private void retainContributors(Collection<SearchEverywhereContributor<?>> retainContributors) {
        Iterator iterator2 = this.listElements.iterator();
        int startInterval = 0;
        int endInterval = -1;
        while (iterator2.hasNext()) {
            SearchEverywhereFoundElementInfo item = (SearchEverywhereFoundElementInfo)iterator2.next();
            if (retainContributors.contains(item.getContributor())) {
                if (startInterval <= endInterval) {
                    this.fireIntervalRemoved(this, startInterval, endInterval);
                    startInterval = endInterval + 2;
                } else {
                    ++startInterval;
                }
            } else {
                iterator2.remove();
            }
            ++endInterval;
        }
        if (startInterval <= endInterval) {
            this.fireIntervalRemoved(this, startInterval, endInterval);
        }
    }

    @Override
    public void clearMoreItems() {
        ListIterator iterator2 = this.listElements.listIterator();
        while (iterator2.hasNext()) {
            int index2 = iterator2.nextIndex();
            if (((SearchEverywhereFoundElementInfo)iterator2.next()).getElement() != MORE_ELEMENT) continue;
            iterator2.remove();
            this.fireContentsChanged(this, index2, index2);
        }
    }

    @Override
    public void removeElement(@NotNull Object item, SearchEverywhereContributor<?> contributor) {
        int index2;
        if (item == null) {
            GroupedSearchListModel.$$$reportNull$$$0(0);
        }
        if ((index2 = this.contributors().indexOf(contributor)) < 0) {
            return;
        }
        while (index2 < this.getSize() && ((SearchEverywhereFoundElementInfo)this.listElements.get(index2)).getContributor() == contributor) {
            if (item.equals(this.getElementAt(index2))) {
                this.listElements.remove(index2);
                this.fireIntervalRemoved(this, index2, index2);
                return;
            }
            ++index2;
        }
    }

    @Override
    public void setHasMore(SearchEverywhereContributor<?> contributor, boolean newVal) {
        int index2 = this.contributors().lastIndexOf(contributor);
        if (index2 < 0) {
            return;
        }
        boolean alreadyHas = this.isMoreElement(index2);
        if (alreadyHas && !newVal) {
            this.listElements.remove(index2);
            this.fireIntervalRemoved(this, index2, index2);
        }
        if (!alreadyHas && newVal) {
            this.listElements.add(++index2, new SearchEverywhereFoundElementInfo(MORE_ELEMENT, 0, contributor));
            this.fireIntervalAdded(this, index2, index2);
        }
    }

    public boolean isGroupFirstItem(int index2) {
        return index2 == 0 || ((SearchEverywhereFoundElementInfo)this.listElements.get(index2)).getContributor() != ((SearchEverywhereFoundElementInfo)this.listElements.get(index2 - 1)).getContributor();
    }

    @Override
    public int getIndexToScroll(int currentIndex, boolean scrollDown) {
        int index2 = currentIndex;
        while ((index2 += scrollDown ? 1 : -1) >= 0 && index2 < this.getSize() && !this.isGroupFirstItem(index2) && !this.isMoreElement(index2)) {
        }
        return Integer.max(Integer.min(index2, this.getSize() - 1), 0);
    }

    public int getItemsForContributor(SearchEverywhereContributor<?> contributor) {
        Range<Integer> range2 = this.getRangeForContributor(contributor);
        return range2 == null ? 0 : (Integer)range2.getTo() - (Integer)range2.getFrom() + 1;
    }

    @Nullable
    private Range<Integer> getRangeForContributor(SearchEverywhereContributor<?> contributor) {
        List<SearchEverywhereContributor> contributorsList = this.contributors();
        int first = contributorsList.indexOf(contributor);
        if (first < 0) {
            return null;
        }
        int last = contributorsList.lastIndexOf(contributor);
        if (this.isMoreElement(last)) {
            --last;
        }
        return new Range((Comparable)Integer.valueOf(first), (Comparable)Integer.valueOf(last));
    }

    private int getInsertionPoint(SearchEverywhereContributor contributor) {
        if (this.listElements.isEmpty()) {
            return 0;
        }
        List<SearchEverywhereContributor> list2 = this.contributors();
        int index2 = list2.lastIndexOf(contributor);
        if (index2 >= 0) {
            return this.isMoreElement(index2) ? index2 : index2 + 1;
        }
        index2 = Collections.binarySearch(list2, contributor, Comparator.comparingInt(SearchEverywhereContributor::getSortWeight));
        return -index2 - 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ide/actions/searcheverywhere/GroupedSearchListModel", "removeElement"));
    }
}

