/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.ml;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;

public class SearchEverywhereMlExperiment {
    private static final int NUMBER_OF_GROUPS = 8;
    private static final int EXPERIMENT_GROUP = 6;
    private final int myExperimentGroup;
    private final boolean myPerformExperiment;
    private final boolean myIsExperimentalMode = StatisticsUploadAssistant.isSendAllowed() && ApplicationManager.getApplication().isEAP();

    public SearchEverywhereMlExperiment() {
        this.myExperimentGroup = this.myIsExperimentalMode ? EventLogConfiguration.getInstance().getOrCreate("MLSE").getBucket() % 8 : -1;
        this.myPerformExperiment = this.myExperimentGroup == 6;
    }

    public boolean isAllowed() {
        if (SearchEverywhereMlExperiment.isOrderByMlEnabled()) {
            return true;
        }
        return !this.isDisableLoggingAndExperiments();
    }

    public boolean shouldOrderByMl() {
        if (SearchEverywhereMlExperiment.isOrderByMlEnabled()) {
            return true;
        }
        if (this.isDisableLoggingAndExperiments() || SearchEverywhereMlExperiment.isDisableExperiments()) {
            return false;
        }
        return this.myPerformExperiment;
    }

    private boolean isDisableLoggingAndExperiments() {
        return !this.myIsExperimentalMode || Registry.is((String)"search.everywhere.force.disable.logging.ml");
    }

    private static boolean isDisableExperiments() {
        return Registry.is((String)"search.everywhere.force.disable.experiment.action.ml");
    }

    private static boolean isOrderByMlEnabled() {
        return Registry.is((String)"search.everywhere.sort.actions.by.ml");
    }

    public int getExperimentGroup() {
        return this.myExperimentGroup;
    }
}

