/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.ide.bookmarks.actions.BookmarkContext;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"context", "Lcom/intellij/ide/bookmarks/actions/BookmarkContext;", "Lcom/intellij/openapi/actionSystem/DataContext;", "getContext", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/ide/bookmarks/actions/BookmarkContext;", "intellij.platform.lang.impl"})
public final class BookmarkContextKt {
    @Nullable
    public static final BookmarkContext getContext(@NotNull DataContext $this$context) {
        PsiElement psiElement;
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)$this$context, (String)"$this$context");
        Project project = (Project)$this$context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getData(CommonDataKeys.PROJECT) ?: return null");
        Project project2 = project;
        Editor editor2 = (Editor)$this$context.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            editor2 = editor = (Editor)$this$context.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        }
        if (editor != null) {
            if (editor.isOneLineMode()) {
                return null;
            }
            Integer n = $this$context.getData(EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR);
            if (n == null) {
                CaretModel caretModel = editor.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                n = caretModel.getLogicalPosition().line;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getData(EditorGutterComp\u2026odel.logicalPosition.line");
            int line = n;
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"FileDocumentManager.getI\u2026.document) ?: return null");
            VirtualFile file2 = virtualFile2;
            return file2 instanceof LightVirtualFile ? null : new BookmarkContext(project2, file2, editor, line);
        }
        PsiElement psiElement2 = psiElement = (PsiElement)$this$context.getData(PlatformDataKeys.PSI_ELEMENT);
        VirtualFile elementFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)(psiElement2 != null ? psiElement2.getContainingFile() : null)));
        if (psiElement != null && !(psiElement instanceof PsiCompiledElement) && elementFile != null) {
            if (elementFile instanceof LightVirtualFile) {
                return null;
            }
            Document document = FileDocumentManager.getInstance().getDocument(elementFile);
            int line = document != null ? document.getLineNumber(psiElement.getTextOffset()) : -1;
            return new BookmarkContext(project2, elementFile, null, line);
        }
        VirtualFile file3 = (VirtualFile)$this$context.getData(PlatformDataKeys.VIRTUAL_FILE);
        if (file3 != null && !(file3 instanceof LightVirtualFile)) {
            return new BookmarkContext(project2, file3, null, -1);
        }
        return null;
    }
}

