/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmarks.BookmarkBundle;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ListUtil;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

class MoveBookmarkDownAction
extends DumbAwareAction {
    private final Project myProject;
    private final JList<BookmarkItem> myList;

    MoveBookmarkDownAction(Project project, JList<BookmarkItem> list2) {
        super(BookmarkBundle.message("action.bookmark.move.down", new Object[0]), null, AllIcons.Actions.MoveDown);
        this.setEnabledInModalContext(true);
        this.myProject = project;
        this.myList = list2;
        this.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, list2);
    }

    public void update(@NotNull AnActionEvent e) {
        int modelSize;
        if (e == null) {
            MoveBookmarkDownAction.$$$reportNull$$$0(0);
        }
        if ((modelSize = this.myList.getModel().getSize()) == 0 || !BookmarksAction.notFiltered(this.myList) || UISettings.getInstance().getSortBookmarks()) {
            e.getPresentation().setEnabled(false);
        } else {
            int lastIndex = modelSize - 1;
            if (this.myList.getModel().getElementAt(lastIndex) == null) {
                --lastIndex;
            }
            e.getPresentation().setEnabled(BookmarksAction.getSelectedBookmarks(this.myList).size() == 1 && this.myList.getSelectedIndex() < lastIndex);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MoveBookmarkDownAction.$$$reportNull$$$0(1);
        }
        ListUtil.moveSelectedItemsDown(this.myList);
        BookmarkManager.getInstance(this.myProject).moveBookmarkDown(BookmarksAction.getSelectedBookmarks(this.myList).get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/bookmarks/actions/MoveBookmarkDownAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

