/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.cds;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.cds.CDSFUSCollector;
import com.intellij.ide.cds.CDSManager;
import com.intellij.ide.cds.CDSPaths;
import com.intellij.ide.cds.CDSTaskResult;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JO\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00072\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00180 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"H\u0082\bJ\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010&\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\"J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010+\u001a\u00020\u0018J\u0015\u0010,\u001a\u00020\u0007*\u00020\u00072\u0006\u0010-\u001a\u00020$H\u0082\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u000e\u0010\u0010R\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/intellij/ide/cds/CDSManager;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "agentPath", "Ljava/io/File;", "getAgentPath", "()Ljava/io/File;", "currentCDSArchive", "getCurrentCDSArchive", "currentCDSArchive$delegate", "Lkotlin/Lazy;", "isValidEnv", "", "()Z", "isValidEnv$delegate", "isValidFile", "(Ljava/io/File;)Z", "cleanupStaleCDSFiles", "Lcom/intellij/ide/cds/CDSTaskResult;", "isCDSEnabled", "generateClassList", "", "indicator", "Lcom/intellij/ide/cds/CDSManager$CDSProgressIndicator;", "paths", "Lcom/intellij/ide/cds/CDSPaths;", "generateFileIfNeeded", "theOutputFile", "generate", "Lkotlin/Function2;", "errorMessage", "Lkotlin/Function1;", "", "", "generateSharedArchive", "installCDS", "canStillWork", "Lkotlin/Function0;", "onResult", "installCDSImpl", "removeCDS", "div", "s", "CDSProgressIndicator", "intellij.platform.ide.impl"})
public final class CDSManager {
    private static final Logger LOG;
    @NotNull
    private static final Lazy isValidEnv$delegate;
    @Nullable
    private static final Lazy currentCDSArchive$delegate;
    @NotNull
    public static final CDSManager INSTANCE;

    public final boolean isValidEnv() {
        Lazy lazy = isValidEnv$delegate;
        CDSManager cDSManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final File getCurrentCDSArchive() {
        Lazy lazy = currentCDSArchive$delegate;
        CDSManager cDSManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @NotNull
    public final CDSTaskResult cleanupStaleCDSFiles(boolean isCDSEnabled) {
        File[] files2;
        CDSPaths paths2 = CDSPaths.Companion.getCurrent();
        File currentCDSPath = this.getCurrentCDSArchive();
        File[] fileArray = paths2.getBaseDir().listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] fileArray2 = files2 = fileArray;
        int n = 0;
        if (fileArray2.length == 0) {
            return CDSTaskResult.Success.INSTANCE;
        }
        for (File path2 : files2) {
            if (Intrinsics.areEqual((Object)path2, (Object)currentCDSPath) || isCDSEnabled && paths2.isOurFile(path2)) continue;
            FileUtil.delete((File)path2);
        }
        return CDSTaskResult.Success.INSTANCE;
    }

    public final void removeCDS() {
        File file2 = this.getCurrentCDSArchive();
        if (file2 == null || !file2.isFile()) {
            return;
        }
        VMOptions.writeDisableCDSArchiveOption();
        LOG.warn("Disabled CDS");
    }

    public final void installCDS(@NotNull Function0<Boolean> canStillWork, @NotNull Function1<? super CDSTaskResult, Unit> onResult) {
        Intrinsics.checkNotNullParameter(canStillWork, (String)"canStillWork");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        CDSFUSCollector.INSTANCE.logCDSBuildingStarted();
        long startTime = System.nanoTime();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(canStillWork, startTime, onResult, null, IdeBundle.message((String)"progress.title.cds.optimize.startup", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            final /* synthetic */ Function0 $canStillWork;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Function1 $onResult;

            public void run(@NotNull ProgressIndicator indicator2) {
                CDSTaskResult cDSTaskResult;
                Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                indicator2.setIndeterminate(true);
                CDSProgressIndicator progress2 = new CDSProgressIndicator(this, indicator2){
                    final /* synthetic */ installCDS.1 this$0;
                    final /* synthetic */ ProgressIndicator $indicator;

                    @Nullable
                    public CDSTaskResult.Cancelled getCancelledStatus() {
                        if (!((Boolean)this.this$0.$canStillWork.invoke()).booleanValue()) {
                            return CDSTaskResult.InterruptedForRetry.INSTANCE;
                        }
                        if (this.$indicator.isCanceled()) {
                            return CDSTaskResult.TerminatedByUser.INSTANCE;
                        }
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                        if (application.isDisposed()) {
                            return CDSTaskResult.InterruptedForRetry.INSTANCE;
                        }
                        return null;
                    }

                    @Nullable
                    public String getText2() {
                        return this.$indicator.getText2();
                    }

                    public void setText2(@NlsContexts.ProgressText @Nullable String value2) {
                        this.$indicator.setText2(value2);
                    }
                    {
                        this.this$0 = this$0;
                        this.$indicator = $captured_local_variable$1;
                    }
                };
                CDSPaths paths2 = CDSPaths.Companion.getCurrent();
                try {
                    cDSTaskResult = CDSManager.access$installCDSImpl(CDSManager.INSTANCE, progress2, paths2);
                }
                catch (Throwable t) {
                    CDSManager.access$getLOG$p(CDSManager.INSTANCE).warn("Settings up CDS Archive crashed unexpectedly. " + t.getMessage(), t);
                    String message2 = "Unexpected crash " + t;
                    paths2.markError(message2);
                    cDSTaskResult = new CDSTaskResult.Failed(message2);
                }
                CDSTaskResult result2 = cDSTaskResult;
                long installTime = TimeoutUtil.getDurationMillis((long)this.$startTime);
                CDSFUSCollector.INSTANCE.logCDSBuildingCompleted(installTime, result2);
                this.$onResult.invoke((Object)result2);
            }
            {
                this.$canStillWork = $captured_local_variable$0;
                this.$startTime = $captured_local_variable$1;
                this.$onResult = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final CDSTaskResult installCDSImpl(CDSProgressIndicator indicator2, CDSPaths paths2) {
        CDSTaskResult archiveResult;
        CDSTaskResult cDSTaskResult;
        void theOutputFile$iv;
        void this_$iv;
        CDSTaskResult listResult;
        Object t;
        boolean bl;
        CDSTaskResult cDSTaskResult2;
        CDSManager theOutputFile$iv2;
        void this_$iv2;
        if (paths2.isSame(this.getCurrentCDSArchive())) {
            String message2 = "CDS archive is already generated and being used. Nothing to do";
            LOG.debug(message2);
            return CDSTaskResult.Success.INSTANCE;
        }
        if (paths2.getClassesErrorMarkerFile().isFile()) {
            return new CDSTaskResult.Failed("CDS archive has already failed, skipping");
        }
        LOG.info("Starting generation of CDS archive to the " + paths2.getClassesArchiveFile() + " and " + paths2.getClassesArchiveFile() + " files");
        paths2.mkdirs();
        CDSManager cDSManager = this;
        File file2 = paths2.getClassesListFile();
        Object object = this;
        boolean $i$f$generateFileIfNeeded = false;
        try {
            if (((CDSManager)this_$iv2).isValidFile((File)((Object)theOutputFile$iv2))) {
                cDSTaskResult2 = CDSTaskResult.Success.INSTANCE;
            } else {
                CDSTaskResult.Cancelled cancelled = indicator2.getCancelledStatus();
                if (cancelled != null) {
                    CDSTaskResult.Cancelled cancelled2 = cancelled;
                    boolean bl2 = false;
                    bl = false;
                    CDSTaskResult.Cancelled it$iv = cancelled2;
                    boolean bl3 = false;
                    cDSTaskResult2 = it$iv;
                } else if (!paths2.hasSameEnvironmentToBuildCDSArchive()) {
                    cDSTaskResult2 = CDSTaskResult.PluginsChanged.INSTANCE;
                } else {
                    void p2;
                    CDSPaths cDSPaths = paths2;
                    CDSProgressIndicator p1 = indicator2;
                    boolean bl4 = false;
                    ((CDSManager)object).generateClassList(p1, (CDSPaths)p2);
                    CDSManager.access$getLOG$p((CDSManager)this_$iv2).assertTrue(((CDSManager)this_$iv2).isValidFile((File)((Object)theOutputFile$iv2)), (Object)"Result file must be generated and be valid");
                    cDSTaskResult2 = CDSTaskResult.Success.INSTANCE;
                }
            }
        }
        catch (Throwable t$iv) {
            FileUtil.delete((File)((Object)theOutputFile$iv2));
            CDSTaskResult.Cancelled cancelled = indicator2.getCancelledStatus();
            if (cancelled != null) {
                CDSTaskResult.Cancelled cancelled3 = cancelled;
                bl = false;
                boolean bl5 = false;
                CDSTaskResult.Cancelled it$iv = cancelled3;
                boolean bl6 = false;
                cDSTaskResult2 = it$iv;
            }
            if (t$iv instanceof InterruptedException) {
                cDSTaskResult2 = CDSTaskResult.InterruptedForRetry.INSTANCE;
            }
            t = t$iv;
            boolean bl7 = false;
            String message$iv = "Failed to attach CDS Java Agent to the running IDE instance. " + ((Throwable)t).getMessage();
            CDSManager.access$getLOG$p((CDSManager)this_$iv2).warn(message$iv, t$iv);
            paths2.markError(message$iv);
            cDSTaskResult2 = listResult = (CDSTaskResult)new CDSTaskResult.Failed(message$iv);
        }
        if (Intrinsics.areEqual((Object)listResult, (Object)CDSTaskResult.Success.INSTANCE) ^ true) {
            return listResult;
        }
        theOutputFile$iv2 = this;
        object = paths2.getClassesArchiveFile();
        CDSManager cDSManager2 = this;
        boolean $i$f$generateFileIfNeeded2 = false;
        try {
            if (((CDSManager)this_$iv).isValidFile((File)theOutputFile$iv)) {
                cDSTaskResult = CDSTaskResult.Success.INSTANCE;
            } else {
                CDSTaskResult.Cancelled cancelled = indicator2.getCancelledStatus();
                if (cancelled != null) {
                    CDSTaskResult.Cancelled message$iv = cancelled;
                    bl = false;
                    boolean bl8 = false;
                    CDSTaskResult.Cancelled it$iv = message$iv;
                    boolean bl9 = false;
                    cDSTaskResult = it$iv;
                } else if (!paths2.hasSameEnvironmentToBuildCDSArchive()) {
                    cDSTaskResult = CDSTaskResult.PluginsChanged.INSTANCE;
                } else {
                    void p2;
                    t = paths2;
                    CDSProgressIndicator p1 = indicator2;
                    boolean bl10 = false;
                    cDSManager2.generateSharedArchive(p1, (CDSPaths)p2);
                    CDSManager.access$getLOG$p((CDSManager)this_$iv).assertTrue(((CDSManager)this_$iv).isValidFile((File)theOutputFile$iv), (Object)"Result file must be generated and be valid");
                    cDSTaskResult = CDSTaskResult.Success.INSTANCE;
                }
            }
        }
        catch (Throwable t$iv) {
            FileUtil.delete((File)theOutputFile$iv);
            CDSTaskResult.Cancelled cancelled = indicator2.getCancelledStatus();
            if (cancelled != null) {
                CDSTaskResult.Cancelled cancelled4 = cancelled;
                boolean bl11 = false;
                boolean bl12 = false;
                CDSTaskResult.Cancelled it$iv = cancelled4;
                boolean bl13 = false;
                cDSTaskResult = it$iv;
            }
            if (t$iv instanceof InterruptedException) {
                cDSTaskResult = CDSTaskResult.InterruptedForRetry.INSTANCE;
            }
            Throwable t2 = t$iv;
            boolean bl14 = false;
            String message$iv = "Failed to generated CDS archive. " + t2.getMessage();
            CDSManager.access$getLOG$p((CDSManager)this_$iv).warn(message$iv, t$iv);
            paths2.markError(message$iv);
            cDSTaskResult = archiveResult = (CDSTaskResult)new CDSTaskResult.Failed(message$iv);
        }
        if (Intrinsics.areEqual((Object)archiveResult, (Object)CDSTaskResult.Success.INSTANCE) ^ true) {
            return archiveResult;
        }
        VMOptions.writeEnableCDSArchiveOption(paths2.getClassesArchiveFile().getAbsolutePath());
        LOG.warn("Enabled CDS archive from " + paths2.getClassesArchiveFile() + ", VMOptions were updated");
        return CDSTaskResult.Success.INSTANCE;
    }

    private final File getAgentPath() {
        File libPath = this.div(this.div(new File(PathManager.getLibPath()), "cds"), "classesLogAgent.jar");
        if (libPath.isFile()) {
            return libPath;
        }
        LOG.warn("Failed to find bundled CDS classes agent in " + libPath);
        File probe = this.div(this.div(this.div(this.div(this.div(new File(PathManager.getHomePath()), "out"), "classes"), "artifacts"), "classesLogAgent_jar"), "classesLogAgent.jar");
        if (probe.isFile()) {
            return probe;
        }
        String string = "Failed to resolve path to the CDS agent";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateClassList(CDSProgressIndicator indicator2, CDSPaths paths2) {
        indicator2.setText2(IdeBundle.message((String)"progress.text.collecting.classes", (Object[])new Object[0]));
        String selfAttachKey = "jdk.attach.allowAttachSelf";
        if (!System.getProperties().containsKey(selfAttachKey)) {
            throw (Throwable)new RuntimeException("Please make sure you have -D" + selfAttachKey + "=true set in the VM options");
        }
        boolean $i$f$measureTimeMillis = false;
        boolean bl = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        VirtualMachine vm = VirtualMachine.attach(OSProcessUtil.getApplicationPid());
        try {
            vm.loadAgent(INSTANCE.getAgentPath().getPath(), String.valueOf(paths2.getClassesListFile()));
        }
        finally {
            vm.detach();
        }
        long duration = System.currentTimeMillis() - start$iv;
        LOG.info("CDS classes file is generated in " + StringUtil.formatDuration((long)duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateSharedArchive(CDSProgressIndicator indicator2, CDSPaths paths2) {
        Object object;
        indicator2.setText2(IdeBundle.message((String)"progress.text.generate.classes.archive", (Object[])new Object[0]));
        String logLevel = LOG.isDebugEnabled() ? "=debug" : "";
        Object[] objectArray = new String[7];
        StringBuilder stringBuilder = new StringBuilder().append("-Djava.class.path=");
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        objectArray[0] = stringBuilder.append(runtimeMXBean.getClassPath()).toString();
        objectArray[1] = "-Xlog:cds" + logLevel;
        objectArray[2] = "-Xlog:class+path" + logLevel;
        objectArray[3] = "-Xshare:dump";
        objectArray[4] = "-XX:+UnlockDiagnosticVMOptions";
        objectArray[5] = "-XX:SharedClassListFile=" + paths2.getClassesListFile();
        objectArray[6] = "-XX:SharedArchiveFile=" + paths2.getClassesArchiveFile();
        List args = CollectionsKt.listOf((Object[])objectArray);
        CommandLineWrapperUtil.writeArgumentsFile((File)paths2.getClassesPathFile(), (List)args, (Charset)StandardCharsets.UTF_8);
        boolean $i$f$measureTimeMillis = false;
        boolean bl = false;
        long start$iv = System.currentTimeMillis();
        boolean bl2 = false;
        String ext = SystemInfo.isWindows ? ".exe" : "";
        String string = System.getProperty("java.home");
        Intrinsics.checkNotNull((Object)string);
        File javaExe = INSTANCE.div(INSTANCE.div(new File(string), "bin"), "java" + ext);
        List javaArgs = CollectionsKt.listOf((Object[])new String[]{javaExe.getPath(), "" + '@' + paths2.getClassesPathFile()});
        File cwd = new File(".").getCanonicalFile();
        LOG.info("Running CDS generation process: " + javaArgs + " in " + cwd + " with classpath: " + args);
        FileUtil.delete((File)paths2.getDumpOutputFile());
        FileUtil.delete((File)paths2.getClassesArchiveFile());
        GeneralCommandLine commandLine = new GeneralCommandLine(paths2, args, indicator2){
            final /* synthetic */ CDSPaths $paths$inlined;
            final /* synthetic */ List $args$inlined;
            final /* synthetic */ CDSProgressIndicator $indicator$inlined;
            {
                this.$paths$inlined = cDSPaths;
                this.$args$inlined = list2;
                this.$indicator$inlined = cDSProgressIndicator;
            }

            @NotNull
            protected ProcessBuilder buildProcess(@NotNull ProcessBuilder builder2) {
                Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                ProcessBuilder processBuilder = super.buildProcess(builder2).redirectErrorStream(true).redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(this.$paths$inlined.getDumpOutputFile());
                Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"super.buildProcess(build\u2026put(paths.dumpOutputFile)");
                return processBuilder;
            }
        };
        commandLine.setWorkDirectory(cwd);
        commandLine.setExePath(javaExe.getAbsolutePath());
        commandLine.addParameter("" + '@' + paths2.getClassesPathFile());
        if (!SystemInfo.isWindows) {
            ExecUtil.setupLowPriorityExecution((GeneralCommandLine)commandLine);
        }
        long timeToWaitFor = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
        Function0<Boolean> $fun$shouldWaitForProcessToComplete$1 = new Function0<Boolean>(timeToWaitFor){
            final /* synthetic */ long $timeToWaitFor;

            public final boolean invoke() {
                return this.$timeToWaitFor > System.currentTimeMillis();
            }
            {
                this.$timeToWaitFor = l;
                super(0);
            }
        };
        Process process2 = commandLine.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"commandLine.createProcess()");
        Process process3 = process2;
        try {
            CDSManager cDSManager = INSTANCE;
            boolean bl3 = false;
            try {
                object = Result.Companion;
                CDSManager $this$runCatching = cDSManager;
                boolean bl4 = false;
                process3.getOutputStream().close();
                Unit unit = Unit.INSTANCE;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl6 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            while ($fun$shouldWaitForProcessToComplete$1.invoke()) {
                if (indicator2.getCancelledStatus() != null) {
                    throw (Throwable)new InterruptedException();
                }
                if (!process3.waitFor(200L, TimeUnit.MILLISECONDS)) continue;
                break;
            }
        }
        finally {
            if (process3.isAlive()) {
                process3.destroyForcibly();
            }
        }
        if (!$fun$shouldWaitForProcessToComplete$1.invoke()) {
            throw (Throwable)new RuntimeException("The process took too long and will be killed. See " + paths2.getDumpOutputFile() + " for details");
        }
        int exitValue = process3.exitValue();
        if (exitValue != 0) {
            Object object2;
            Object object3;
            object = INSTANCE;
            boolean bl7 = false;
            try {
                object3 = Result.Companion;
                Object $this$runCatching = object;
                boolean bl8 = false;
                $this$runCatching = CollectionsKt.joinToString$default((Iterable)CollectionsKt.takeLast((List)FilesKt.readLines$default((File)paths2.getDumpOutputFile(), null, (int)1, null), (int)30), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                bl8 = false;
                object3 = Result.constructor-impl((Object)$this$runCatching);
            }
            catch (Throwable $this$runCatching) {
                Result.Companion bl8 = Result.Companion;
                boolean bl9 = false;
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
            }
            object = object3;
            bl7 = false;
            boolean bl10 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) {
                object2 = object;
            } else {
                Throwable it = throwable;
                boolean bl11 = false;
                object2 = "";
            }
            String outputLines = (String)object2;
            throw (Throwable)new RuntimeException("The process existed with code " + exitValue + ". See " + paths2.getDumpOutputFile() + " for details:\n" + outputLines);
        }
        long durationLink2 = System.currentTimeMillis() - start$iv;
        LOG.info("Generated CDS archive in " + paths2.getClassesArchiveFile() + ", " + "size = " + StringUtil.formatFileSize((long)paths2.getClassesArchiveFile().length()) + ", " + "it took " + StringUtil.formatDuration((long)durationLink2));
    }

    private final File div(File $this$div, String s) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"$this$div");
        return new File($this$div, s);
    }

    private final boolean isValidFile(File $this$isValidFile) {
        return $this$isValidFile.isFile() && $this$isValidFile.length() > (long)42;
    }

    private final CDSTaskResult generateFileIfNeeded(CDSProgressIndicator indicator2, CDSPaths paths2, File theOutputFile, Function2<? super CDSProgressIndicator, ? super CDSPaths, Unit> generate2, Function1<? super Throwable, String> errorMessage) {
        int $i$f$generateFileIfNeeded = 0;
        try {
            if (this.isValidFile(theOutputFile)) {
                return CDSTaskResult.Success.INSTANCE;
            }
            CDSTaskResult.Cancelled cancelled = indicator2.getCancelledStatus();
            if (cancelled != null) {
                CDSTaskResult.Cancelled cancelled2 = cancelled;
                boolean bl = false;
                boolean bl2 = false;
                CDSTaskResult.Cancelled it = cancelled2;
                boolean bl3 = false;
                return it;
            }
            if (!paths2.hasSameEnvironmentToBuildCDSArchive()) {
                return CDSTaskResult.PluginsChanged.INSTANCE;
            }
            generate2.invoke((Object)indicator2, (Object)paths2);
            CDSManager.access$getLOG$p(this).assertTrue(this.isValidFile(theOutputFile), (Object)"Result file must be generated and be valid");
            return CDSTaskResult.Success.INSTANCE;
        }
        catch (Throwable t) {
            FileUtil.delete((File)theOutputFile);
            CDSTaskResult.Cancelled cancelled = indicator2.getCancelledStatus();
            if (cancelled != null) {
                CDSTaskResult.Cancelled cancelled3 = cancelled;
                boolean bl = false;
                boolean bl4 = false;
                CDSTaskResult.Cancelled it = cancelled3;
                boolean bl5 = false;
                return it;
            }
            if (t instanceof InterruptedException) {
                return CDSTaskResult.InterruptedForRetry.INSTANCE;
            }
            String message2 = (String)errorMessage.invoke((Object)t);
            CDSManager.access$getLOG$p(this).warn(message2, t);
            paths2.markError(message2);
            return new CDSTaskResult.Failed(message2);
        }
    }

    private CDSManager() {
    }

    static {
        CDSManager cDSManager;
        INSTANCE = cDSManager = new CDSManager();
        Logger logger = Logger.getInstance(cDSManager.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(javaClass)");
        LOG = logger;
        isValidEnv$delegate = LazyKt.lazy((Function0)isValidEnv.2.INSTANCE);
        currentCDSArchive$delegate = LazyKt.lazy((Function0)currentCDSArchive.2.INSTANCE);
    }

    public static final /* synthetic */ CDSTaskResult access$installCDSImpl(CDSManager $this, CDSProgressIndicator indicator2, CDSPaths paths2) {
        return $this.installCDSImpl(indicator2, paths2);
    }

    public static final /* synthetic */ Logger access$getLOG$p(CDSManager $this) {
        CDSManager cDSManager = $this;
        return LOG;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\bb\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/cds/CDSManager$CDSProgressIndicator;", "", "cancelledStatus", "Lcom/intellij/ide/cds/CDSTaskResult$Cancelled;", "getCancelledStatus", "()Lcom/intellij/ide/cds/CDSTaskResult$Cancelled;", "text2", "", "getText2", "()Ljava/lang/String;", "setText2", "(Ljava/lang/String;)V", "intellij.platform.ide.impl"})
    private static interface CDSProgressIndicator {
        @Nullable
        public CDSTaskResult.Cancelled getCancelledStatus();

        @Nullable
        public String getText2();

        public void setText2(@Nullable String var1);
    }
}

