/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.IconUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeleteFromFavoritesAction
extends AnActionButton
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DeleteFromFavoritesAction.class);

    public DeleteFromFavoritesAction() {
        super(IdeBundle.messagePointer((String)"action.remove.from.current.favorites", (Object[])new Object[0]), IconUtil.getRemoveIcon());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String listName;
        if (e == null) {
            DeleteFromFavoritesAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        FavoritesViewTreeBuilder builder2 = FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(dataContext);
        if (project == null || builder2 == null) {
            return;
        }
        Set selection = builder2.getSelectedElements();
        if (selection.isEmpty()) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesListProvider provider2 = favoritesManager.getListProvider(listName = FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext));
        if (provider2 != null && provider2.willHandle(CommonActionsPanel.Buttons.REMOVE, project, selection)) {
            provider2.handle(CommonActionsPanel.Buttons.REMOVE, project, selection, builder2.getTree());
            return;
        }
        FavoriteTreeNodeDescriptor[] roots = FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        DnDAwareTree tree = FavoritesTreeViewPanel.FAVORITES_TREE_KEY.getData(dataContext);
        assert (roots != null && tree != null);
        HashMap toRemove2 = new HashMap();
        for (FavoriteTreeNodeDescriptor root : roots) {
            AbstractTreeNode node2 = root.getElement();
            if (node2 instanceof FavoritesListNode) {
                favoritesManager.removeFavoritesList((String)node2.getValue());
                continue;
            }
            FavoritesListNode listNode = FavoritesTreeUtil.extractParentList(root);
            LOG.assertTrue(listNode != null);
            String name = listNode.getName();
            if (!toRemove2.containsKey(name)) {
                toRemove2.put(name, new ArrayList());
            }
            ((List)toRemove2.get(name)).add(node2);
        }
        for (String name : toRemove2.keySet()) {
            favoritesManager.removeRoot(name, (List)toRemove2.get(name));
        }
    }

    public void updateButton(@NotNull AnActionEvent e) {
        if (e == null) {
            DeleteFromFavoritesAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setText(this.getTemplatePresentation().getText());
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        FavoritesViewTreeBuilder builder2 = FavoritesTreeViewPanel.FAVORITES_TREE_BUILDER_KEY.getData(dataContext);
        if (project == null || builder2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Set selection = builder2.getSelectedElements();
        String listName = FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        if (listName == null) {
            e.getPresentation().setText(CommonActionsPanel.Buttons.REMOVE.getText());
            e.getPresentation().setEnabled(false);
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesListProvider provider2 = favoritesManager.getListProvider(listName);
        if (provider2 != null) {
            boolean willHandle = provider2.willHandle(CommonActionsPanel.Buttons.REMOVE, project, selection);
            e.getPresentation().setEnabled(willHandle);
            if (willHandle) {
                e.getPresentation().setText(provider2.getCustomName(CommonActionsPanel.Buttons.REMOVE));
            } else {
                e.getPresentation().setText(CommonActionsPanel.Buttons.REMOVE.getText());
            }
            return;
        }
        FavoriteTreeNodeDescriptor[] roots = FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        if (roots == null || roots.length == 0 || selection.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        for (Object o : selection) {
            if (o instanceof AbstractTreeNode) {
                AbstractTreeNode node2 = (AbstractTreeNode)o;
                int deep = DeleteFromFavoritesAction.getDeep(node2);
                if (deep == 2 || deep == 3) continue;
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabled(false);
            return;
        }
    }

    private static int getDeep(AbstractTreeNode node2) {
        int result2 = 0;
        while (node2 != null) {
            node2 = node2.getParent();
            ++result2;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/actions/DeleteFromFavoritesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateButton";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

