/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultCreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.VelocityTemplateContext;
import com.intellij.ide.fileTemplates.VelocityWrapper;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTSetDirective;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTemplateUtil {
    private static final Logger LOG = Logger.getInstance(FileTemplateUtil.class);
    private static final CreateFromTemplateHandler DEFAULT_HANDLER = new DefaultCreateFromTemplateHandler();

    public static String @NotNull [] calculateAttributes(@NotNull String templateContent, @NotNull Properties properties, boolean includeDummies, @NotNull Project project) throws ParseException {
        if (templateContent == null) {
            FileTemplateUtil.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            FileTemplateUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(2);
        }
        HashSet<String> propertiesNames = new HashSet<String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            propertiesNames.add((String)e.nextElement());
        }
        return FileTemplateUtil.calculateAttributes(templateContent, propertiesNames, includeDummies, project);
    }

    public static String[] calculateAttributes(@NotNull String templateContent, @NotNull Map<String, Object> properties, boolean includeDummies, @NotNull Project project) throws ParseException {
        if (templateContent == null) {
            FileTemplateUtil.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            FileTemplateUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(5);
        }
        return FileTemplateUtil.calculateAttributes(templateContent, properties.keySet(), includeDummies, project);
    }

    private static String @NotNull [] calculateAttributes(@NotNull String templateContent, @NotNull Set<String> propertiesNames, boolean includeDummies, @NotNull Project project) throws ParseException {
        if (templateContent == null) {
            FileTemplateUtil.$$$reportNull$$$0(6);
        }
        if (propertiesNames == null) {
            FileTemplateUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(8);
        }
        LinkedHashSet unsetAttributes = new LinkedHashSet();
        HashSet definedAttributes = new HashSet();
        SimpleNode template = (SimpleNode)VelocityTemplateContext.withContext(project, () -> VelocityWrapper.parse(new StringReader(templateContent), "MyTemplate"));
        FileTemplateUtil.collectAttributes(unsetAttributes, definedAttributes, (Node)template, propertiesNames, includeDummies, new HashSet(), project);
        for (String definedAttribute : definedAttributes) {
            unsetAttributes.remove(definedAttribute);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(unsetAttributes);
        if (stringArray == null) {
            FileTemplateUtil.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static void collectAttributes(@NotNull Set<? super String> referenced, @NotNull Set<? super String> defined, @NotNull Node apacheNode, @NotNull Set<String> propertiesNames, boolean includeDummies, @NotNull Set<? super String> visitedIncludes, @NotNull Project project) throws ParseException {
        if (referenced == null) {
            FileTemplateUtil.$$$reportNull$$$0(10);
        }
        if (defined == null) {
            FileTemplateUtil.$$$reportNull$$$0(11);
        }
        if (apacheNode == null) {
            FileTemplateUtil.$$$reportNull$$$0(12);
        }
        if (propertiesNames == null) {
            FileTemplateUtil.$$$reportNull$$$0(13);
        }
        if (visitedIncludes == null) {
            FileTemplateUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(15);
        }
        int childCount = apacheNode.jjtGetNumChildren();
        for (int i2 = 0; i2 < childCount; ++i2) {
            Token firstToken;
            Node literal;
            Node apacheChild = apacheNode.jjtGetChild(i2);
            FileTemplateUtil.collectAttributes(referenced, defined, apacheChild, propertiesNames, includeDummies, visitedIncludes, project);
            if (apacheChild instanceof ASTReference) {
                String s = apacheChild.literal();
                if ((s = FileTemplateUtil.referenceToAttribute(s, includeDummies)) == null || s.length() <= 0 || propertiesNames.contains(s)) continue;
                referenced.add(s);
                continue;
            }
            if (apacheChild instanceof ASTSetDirective) {
                Node lhs = apacheChild.jjtGetChild(0);
                String attr = FileTemplateUtil.referenceToAttribute(lhs.literal(), false);
                if (attr == null) continue;
                defined.add(attr);
                continue;
            }
            if (!(apacheChild instanceof ASTDirective) || !"parse".equals(((ASTDirective)apacheChild).getDirectiveName()) || apacheChild.jjtGetNumChildren() != 1 || !((literal = apacheChild.jjtGetChild(0)) instanceof ASTStringLiteral) || literal.jjtGetNumChildren() != 0 || (firstToken = literal.getFirstToken()) == null) continue;
            String s = StringUtil.unquoteString((String)firstToken.toString());
            FileTemplateManager templateManager = FileTemplateManager.getInstance(project);
            FileTemplate includedTemplate = templateManager.getTemplate(s);
            if (includedTemplate == null) {
                includedTemplate = templateManager.getPattern(s);
            }
            if (includedTemplate == null || !visitedIncludes.add(s)) continue;
            SimpleNode template = VelocityWrapper.parse(new StringReader(includedTemplate.getText()), "MyTemplate");
            FileTemplateUtil.collectAttributes(referenced, defined, (Node)template, propertiesNames, includeDummies, visitedIncludes, project);
        }
    }

    @Nullable
    private static String referenceToAttribute(@NotNull String attrib, boolean includeDummies) {
        if (attrib == null) {
            FileTemplateUtil.$$$reportNull$$$0(16);
        }
        while (attrib.startsWith("\\\\")) {
            attrib = attrib.substring(2);
        }
        if (attrib.startsWith("\\$")) {
            if (includeDummies) {
                attrib = attrib.substring(1);
            } else {
                return null;
            }
        }
        if (!StringUtil.startsWithChar((CharSequence)attrib, (char)'$')) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)(attrib = attrib.substring(1)), (char)'{')) {
            String cleanAttribute = null;
            for (int i2 = 1; i2 < attrib.length(); ++i2) {
                char currChar = attrib.charAt(i2);
                if (currChar == '{' || currChar == '.') {
                    cleanAttribute = null;
                    break;
                }
                if (currChar != '}') continue;
                cleanAttribute = attrib.substring(1, i2);
                break;
            }
            attrib = cleanAttribute;
        } else {
            for (int i3 = 0; i3 < attrib.length(); ++i3) {
                char currChar = attrib.charAt(i3);
                if (currChar != '{' && currChar != '}' && currChar != '.') continue;
                attrib = attrib.substring(0, i3);
                break;
            }
        }
        return attrib;
    }

    @NotNull
    public static String mergeTemplate(@NotNull Map attributes2, @NotNull String content2, boolean useSystemLineSeparators) {
        if (attributes2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(17);
        }
        if (content2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(18);
        }
        VelocityContext context2 = FileTemplateUtil.createVelocityContext();
        for (Object o : attributes2.keySet()) {
            String name = (String)o;
            context2.put(name, attributes2.get(name));
        }
        return FileTemplateUtil.mergeTemplate(content2, context2, useSystemLineSeparators, null);
    }

    @NotNull
    private static VelocityContext createVelocityContext() {
        VelocityContext context2 = new VelocityContext();
        context2.put("StringUtils", StringUtils.class);
        VelocityContext velocityContext = context2;
        if (velocityContext == null) {
            FileTemplateUtil.$$$reportNull$$$0(19);
        }
        return velocityContext;
    }

    @NotNull
    public static String mergeTemplate(@NotNull Properties attributes2, @NotNull String content2, boolean useSystemLineSeparators) {
        if (attributes2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(20);
        }
        if (content2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(21);
        }
        return FileTemplateUtil.mergeTemplate(attributes2, content2, useSystemLineSeparators, null);
    }

    @NotNull
    public static String mergeTemplate(@NotNull Properties attributes2, @NotNull String content2, boolean useSystemLineSeparators, @Nullable Consumer<? super VelocityException> exceptionHandler) {
        if (attributes2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(22);
        }
        if (content2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(23);
        }
        VelocityContext context2 = FileTemplateUtil.createVelocityContext();
        Enumeration<?> names2 = attributes2.propertyNames();
        while (names2.hasMoreElements()) {
            String name = (String)names2.nextElement();
            context2.put(name, (Object)attributes2.getProperty(name));
        }
        return FileTemplateUtil.mergeTemplate(content2, context2, useSystemLineSeparators, exceptionHandler);
    }

    @NotNull
    private static String mergeTemplate(String templateContent, VelocityContext context2, boolean useSystemLineSeparators, @Nullable Consumer<? super VelocityException> exceptionHandler) {
        String newSeparator;
        StringWriter stringWriter = new StringWriter();
        try {
            Project project;
            Object projectName = context2.get("PROJECT_NAME");
            if (projectName instanceof String) {
                Object[] projects = ProjectManager.getInstance().getOpenProjects();
                project = (Project)ContainerUtil.find((Object[])projects, project1 -> projectName.equals(project1.getName()));
            } else {
                project = null;
            }
            VelocityTemplateContext.withContext(project, () -> VelocityWrapper.evaluate(project, (Context)context2, stringWriter, templateContent));
        }
        catch (VelocityException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((Throwable)e);
            }
            LOG.info("Error evaluating template:\n" + templateContent, (Throwable)e);
            if (exceptionHandler == null) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)IdeBundle.message((String)"error.parsing.file.template", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.velocity.error", (Object[])new Object[0])));
            }
            exceptionHandler.consume((Object)e);
        }
        String result2 = stringWriter.toString();
        if (useSystemLineSeparators && !"\n".equals(newSeparator = CodeStyle.getDefaultSettings().getLineSeparator())) {
            String string = StringUtil.convertLineSeparators((String)result2, (String)newSeparator);
            if (string == null) {
                FileTemplateUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            FileTemplateUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName, @Nullable Properties props, @NotNull PsiDirectory directory) throws Exception {
        HashMap<String, Object> map2;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(26);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(27);
        }
        if (props != null) {
            map2 = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map2, props);
        } else {
            map2 = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName, map2, directory, null);
    }

    @NotNull
    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName, @Nullable Properties props, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        HashMap<String, Object> map2;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(28);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(29);
        }
        if (props != null) {
            map2 = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map2, props);
        } else {
            map2 = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName, map2, directory, classLoader);
    }

    @NotNull
    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName, @Nullable Map<String, Object> propsMap, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        String[] dummyRefs;
        Properties p;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(30);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(31);
        }
        Project project = directory.getProject();
        FileTemplateManager.getInstance(project).addRecentName(template.getName());
        if (propsMap == null) {
            p = FileTemplateManager.getInstance(project).getDefaultProperties();
            propsMap = new HashMap<String, Object>();
            FileTemplateUtil.putAll(propsMap, p);
        }
        p = new Properties();
        FileTemplateUtil.fillDefaultProperties(p, directory);
        FileTemplateUtil.putAll(propsMap, p);
        CreateFromTemplateHandler handler2 = FileTemplateUtil.findHandler(template);
        if (fileName != null && propsMap.get("NAME") == null) {
            propsMap.put("NAME", fileName);
        } else if (fileName == null && handler2.isNameRequired() && (fileName = (String)propsMap.get("NAME")) == null) {
            throw new Exception("File name must be specified");
        }
        String fileNameWithExt = fileName + (String)(StringUtil.isEmpty((String)template.getExtension()) ? "" : "." + template.getExtension());
        propsMap.put("FILE_NAME", fileNameWithExt);
        propsMap.put("FILE_PATH", FileUtil.join((String[])new String[]{directory.getVirtualFile().getPath(), fileNameWithExt}));
        String dirPath = FileTemplateUtil.getDirPathRelativeToProjectBaseDir(directory);
        if (dirPath != null) {
            propsMap.put("DIR_PATH", dirPath);
        }
        for (String dummyRef : dummyRefs = FileTemplateUtil.calculateAttributes(template.getText(), propsMap, true, directory.getProject())) {
            propsMap.put(dummyRef, "");
        }
        handler2.prepareProperties(propsMap, fileName, template, project);
        handler2.prepareProperties(propsMap);
        Map<String, Object> props_ = propsMap;
        String fileName_ = fileName;
        String mergedText = (String)ClassLoaderUtil.computeWithClassLoader((ClassLoader)(classLoader != null ? classLoader : FileTemplateUtil.class.getClassLoader()), () -> template.getText(props_));
        String templateText = StringUtil.convertLineSeparators((String)mergedText);
        if (ModelBranch.getPsiBranch((PsiElement)directory) != null) {
            PsiElement psiElement = handler2.createFromTemplate(project, directory, fileName_, template, templateText, props_);
            if (psiElement == null) {
                FileTemplateUtil.$$$reportNull$$$0(32);
            }
            return psiElement;
        }
        PsiElement psiElement = (PsiElement)WriteCommandAction.writeCommandAction((Project)project).withName(handler2.commandName(template)).compute(() -> handler2.createFromTemplate(project, directory, fileName_, template, templateText, props_));
        if (psiElement == null) {
            FileTemplateUtil.$$$reportNull$$$0(33);
        }
        return psiElement;
    }

    @Nullable
    public static String getDirPathRelativeToProjectBaseDir(@NotNull PsiDirectory directory) {
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(34);
        }
        VirtualFile dirVfile = directory.getVirtualFile();
        VirtualFile baseDir = directory.getProject().getBaseDir();
        return baseDir != null ? VfsUtilCore.getRelativePath((VirtualFile)dirVfile, (VirtualFile)ModelBranchUtil.obtainCopyFromTheSameBranch((VirtualFile)dirVfile, (VirtualFile)baseDir)) : null;
    }

    @NotNull
    public static CreateFromTemplateHandler findHandler(@NotNull FileTemplate template) {
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(35);
        }
        CreateFromTemplateHandler createFromTemplateHandler = CreateFromTemplateHandler.EP_NAME.getExtensionList().stream().filter(handler2 -> handler2.handlesTemplate(template)).findFirst().orElse(DEFAULT_HANDLER);
        if (createFromTemplateHandler == null) {
            FileTemplateUtil.$$$reportNull$$$0(36);
        }
        return createFromTemplateHandler;
    }

    public static void fillDefaultProperties(@NotNull Properties props, @NotNull PsiDirectory directory) {
        if (props == null) {
            FileTemplateUtil.$$$reportNull$$$0(37);
        }
        if (directory == null) {
            FileTemplateUtil.$$$reportNull$$$0(38);
        }
        for (DefaultTemplatePropertiesProvider provider2 : DefaultTemplatePropertiesProvider.EP_NAME.getExtensionList()) {
            provider2.fillProperties(directory, props);
        }
        props.setProperty("FILE_NAME", "");
        props.setProperty("DIR_PATH", "");
    }

    @NotNull
    public static String indent(@NotNull String methodText, @NotNull Project project, FileType fileType) {
        if (methodText == null) {
            FileTemplateUtil.$$$reportNull$$$0(39);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(40);
        }
        int indent = CodeStyle.getSettings((Project)project).getIndentSize(fileType);
        String string = methodText.replaceAll("\n", "\n" + StringUtil.repeatSymbol((char)' ', (int)indent));
        if (string == null) {
            FileTemplateUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    public static boolean canCreateFromTemplate(PsiDirectory @NotNull [] dirs, @NotNull FileTemplate template) {
        FileType fileType;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(42);
        }
        if (dirs == null) {
            FileTemplateUtil.$$$reportNull$$$0(43);
        }
        if ((fileType = FileTemplateUtil.getFileType(template)).equals(FileTypes.UNKNOWN)) {
            return false;
        }
        CreateFromTemplateHandler handler2 = FileTemplateUtil.findHandler(template);
        return handler2.canCreate(dirs);
    }

    @NotNull
    private static FileType getFileType(@NotNull FileTemplate template) {
        FileType fileType;
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(44);
        }
        if ((fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension())).equals(FileTypes.UNKNOWN)) {
            FileType fileType2 = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(FileUtilRt.getExtension((String)template.getExtension()));
            if (fileType2 == null) {
                FileTemplateUtil.$$$reportNull$$$0(45);
            }
            return fileType2;
        }
        FileType fileType3 = fileType;
        if (fileType3 == null) {
            FileTemplateUtil.$$$reportNull$$$0(46);
        }
        return fileType3;
    }

    @Nullable
    public static Icon getIcon(@NotNull FileTemplate fileTemplate) {
        if (fileTemplate == null) {
            FileTemplateUtil.$$$reportNull$$$0(47);
        }
        return FileTemplateUtil.getFileType(fileTemplate).getIcon();
    }

    public static void putAll(@NotNull Map<String, Object> props, @NotNull Properties p) {
        if (props == null) {
            FileTemplateUtil.$$$reportNull$$$0(48);
        }
        if (p == null) {
            FileTemplateUtil.$$$reportNull$$$0(49);
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s;
            props.putIfAbsent(s, p.containsKey(s = (String)e.nextElement()) ? p.get(s) : p.getProperty(s));
        }
    }

    @NotNull
    public static FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension2, @NotNull String content2, FileTemplate @NotNull [] templates) {
        if (prefName == null) {
            FileTemplateUtil.$$$reportNull$$$0(50);
        }
        if (extension2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(51);
        }
        if (content2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(52);
        }
        if (templates == null) {
            FileTemplateUtil.$$$reportNull$$$0(53);
        }
        HashSet<String> names2 = new HashSet<String>();
        for (FileTemplate template : templates) {
            names2.add(template.getName());
        }
        Object name = prefName;
        int i2 = 0;
        while (names2.contains(name)) {
            name = prefName + " (" + ++i2 + ")";
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate((String)name, extension2);
        newTemplate.setText(content2);
        CustomFileTemplate customFileTemplate = newTemplate;
        if (customFileTemplate == null) {
            FileTemplateUtil.$$$reportNull$$$0(54);
        }
        return customFileTemplate;
    }

    @NotNull
    public static Pattern getTemplatePattern(@NotNull FileTemplate template, @NotNull Project project, @NotNull Int2ObjectMap<String> offsetToProperty) {
        if (template == null) {
            FileTemplateUtil.$$$reportNull$$$0(55);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(56);
        }
        if (offsetToProperty == null) {
            FileTemplateUtil.$$$reportNull$$$0(57);
        }
        String templateText = template.getText().trim();
        Object regex = FileTemplateUtil.templateToRegex(templateText, offsetToProperty, project);
        regex = StringUtil.replace((String)regex, (String)"with", (String)"(?:with|by)");
        regex = ".*(" + (String)regex + ").*";
        Pattern pattern = Pattern.compile((String)regex, 32);
        if (pattern == null) {
            FileTemplateUtil.$$$reportNull$$$0(58);
        }
        return pattern;
    }

    @NotNull
    private static String templateToRegex(@NotNull String text2, @NotNull Int2ObjectMap<String> offsetToProperty, @NotNull Project project) {
        if (text2 == null) {
            FileTemplateUtil.$$$reportNull$$$0(59);
        }
        if (offsetToProperty == null) {
            FileTemplateUtil.$$$reportNull$$$0(60);
        }
        if (project == null) {
            FileTemplateUtil.$$$reportNull$$$0(61);
        }
        ArrayList<Object> properties = new ArrayList<Object>(FileTemplateManager.getInstance(project).getDefaultProperties().keySet());
        properties.add("PACKAGE_NAME");
        Object regex = FileTemplateUtil.escapeRegexChars(text2);
        int groupNumber = 1;
        for (Object e : properties) {
            String name = e.toString();
            String escaped = FileTemplateUtil.escapeRegexChars("${" + name + "}");
            boolean first = true;
            int i2 = ((String)regex).indexOf(escaped);
            while (i2 != -1 && i2 < ((String)regex).length()) {
                Object replacement = first ? "([^\\n]*)" : "\\" + groupNumber;
                int delta = escaped.length() - ((String)replacement).length();
                for (int off : offsetToProperty.keySet().toIntArray()) {
                    if (off <= i2) continue;
                    String prop = (String)offsetToProperty.remove(off);
                    offsetToProperty.put(off - delta, (Object)prop);
                }
                offsetToProperty.put(i2, (Object)name);
                regex = ((String)regex).substring(0, i2) + (String)replacement + ((String)regex).substring(i2 + escaped.length());
                if (first) {
                    ++groupNumber;
                    first = false;
                }
                i2 = ((String)regex).indexOf(escaped, i2 + 1);
            }
        }
        String string = regex;
        if (string == null) {
            FileTemplateUtil.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    private static String escapeRegexChars(@NotNull String regex) {
        if (regex == null) {
            FileTemplateUtil.$$$reportNull$$$0(63);
        }
        regex = StringUtil.replace((String)regex, (String)"|", (String)"\\|");
        regex = StringUtil.replace((String)regex, (String)".", (String)"\\.");
        regex = StringUtil.replace((String)regex, (String)"*", (String)"\\*");
        regex = StringUtil.replace((String)regex, (String)"+", (String)"\\+");
        regex = StringUtil.replace((String)regex, (String)"?", (String)"\\?");
        regex = StringUtil.replace((String)regex, (String)"$", (String)"\\$");
        regex = StringUtil.replace((String)regex, (String)"(", (String)"\\(");
        regex = StringUtil.replace((String)regex, (String)")", (String)"\\)");
        regex = StringUtil.replace((String)regex, (String)"[", (String)"\\[");
        regex = StringUtil.replace((String)regex, (String)"]", (String)"\\]");
        regex = StringUtil.replace((String)regex, (String)"{", (String)"\\{");
        String string = regex = StringUtil.replace((String)regex, (String)"}", (String)"\\}");
        if (string == null) {
            FileTemplateUtil.$$$reportNull$$$0(64);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 19: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 54: 
            case 58: 
            case 62: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 19: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 54: 
            case 58: 
            case 62: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateContent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 15: 
            case 40: 
            case 56: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesNames";
                break;
            }
            case 9: 
            case 19: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 54: 
            case 58: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/FileTemplateUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenced";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defined";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apacheNode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedIncludes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrib";
                break;
            }
            case 17: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 18: 
            case 21: 
            case 23: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 35: 
            case 42: 
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 37: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodText";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTemplate";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetToProperty";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/FileTemplateUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAttributes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createVelocityContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTemplate";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromTemplate";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findHandler";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "indent";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePattern";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "templateToRegex";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeRegexChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateAttributes";
                break;
            }
            case 9: 
            case 19: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 54: 
            case 58: 
            case 62: 
            case 64: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "referenceToAttribute";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mergeTemplate";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDirPathRelativeToProjectBaseDir";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findHandler";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "fillDefaultProperties";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "canCreateFromTemplate";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getTemplatePattern";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "templateToRegex";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "escapeRegexChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 19: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 41: 
            case 45: 
            case 46: 
            case 54: 
            case 58: 
            case 62: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

