/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginContentDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.lang.Java11Shim;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aT\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002\u001a,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a4\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eH\u0002\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a0\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0019H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"collectDirectDependencies", "", "rootDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "pluginSet", "Lcom/intellij/ide/plugins/PluginSet;", "withOptional", "", "hasAllModules", "javaDep", "Ljava/util/function/Supplier;", "uniqueCheck", "", "result", "", "createPluginIdGraph", "Lcom/intellij/ide/plugins/CachingSemiGraph;", "descriptors", "", "directDependenciesOfModule", "module", "getTopologicallySorted", "", "processDirectDependencies", "processor", "Lkotlin/Function1;", "intellij.platform.core.impl"})
public final class CachingSemiGraphKt {
    @NotNull
    public static final List<IdeaPluginDescriptorImpl> getTopologicallySorted(@NotNull Collection<IdeaPluginDescriptorImpl> descriptors2, @NotNull PluginSet pluginSet, boolean withOptional) {
        Intrinsics.checkNotNullParameter(descriptors2, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = CachingSemiGraphKt.createPluginIdGraph(descriptors2, pluginSet, withOptional);
        DFSTBuilder requiredOnlyGraph = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)graph2));
        ArrayList<IdeaPluginDescriptorImpl> sortedRequired = new ArrayList<IdeaPluginDescriptorImpl>(graph2.getNodes());
        Comparator comparator2 = requiredOnlyGraph.comparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"requiredOnlyGraph.comparator()");
        Comparator comparator3 = comparator2;
        Collections.sort((List)sortedRequired, new Comparator(comparator3){
            final /* synthetic */ Comparator $comparator;

            public final int compare(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
                int n;
                PluginId pluginId = PluginManagerCore.CORE_ID;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = o1;
                Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl, (String)"o1");
                if (Intrinsics.areEqual((Object)pluginId, (Object)ideaPluginDescriptorImpl.getPluginId())) {
                    n = -1;
                } else {
                    IdeaPluginDescriptorImpl ideaPluginDescriptorImpl2 = o2;
                    Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptorImpl2, (String)"o2");
                    n = Intrinsics.areEqual((Object)pluginId, (Object)ideaPluginDescriptorImpl2.getPluginId()) ? 1 : this.$comparator.compare(o1, o2);
                }
                return n;
            }
            {
                this.$comparator = comparator2;
            }
        });
        return sortedRequired;
    }

    @NotNull
    public static final CachingSemiGraph<IdeaPluginDescriptorImpl> createPluginIdGraph(@NotNull Collection<IdeaPluginDescriptorImpl> descriptors2, @NotNull PluginSet pluginSet, boolean withOptional) {
        Intrinsics.checkNotNullParameter(descriptors2, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        PluginId pluginId = PluginManagerCore.ALL_MODULES_MARKER;
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginManagerCore.ALL_MODULES_MARKER");
        boolean hasAllModules = pluginSet.isPluginEnabled(pluginId);
        Supplier javaDep2 = new Supplier(pluginSet){
            final /* synthetic */ PluginSet $pluginSet;

            @Nullable
            public final IdeaPluginDescriptorImpl get() {
                PluginId pluginId = PluginManagerCore.JAVA_MODULE_ID;
                Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"PluginManagerCore.JAVA_MODULE_ID");
                return this.$pluginSet.findEnabledPlugin(pluginId);
            }
            {
                this.$pluginSet = pluginSet;
            }
        };
        HashSet uniqueCheck = new HashSet();
        HashMap<IdeaPluginDescriptorImpl, List> pluginToDirectDependencies = new HashMap<IdeaPluginDescriptorImpl, List>(descriptors2.size());
        ArrayList list2 = new ArrayList(32);
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors2) {
            CachingSemiGraphKt.collectDirectDependencies(descriptor2, pluginSet, withOptional, hasAllModules, javaDep2, uniqueCheck, list2);
            if (list2.isEmpty()) continue;
            pluginToDirectDependencies.put(descriptor2, Java11Shim.INSTANCE.copyOf((List)list2));
            list2.clear();
        }
        return new CachingSemiGraph<IdeaPluginDescriptorImpl>(descriptors2, (Map)pluginToDirectDependencies);
    }

    private static final void collectDirectDependencies(IdeaPluginDescriptorImpl rootDescriptor, PluginSet pluginSet, boolean withOptional, boolean hasAllModules, Supplier<IdeaPluginDescriptorImpl> javaDep2, Set<IdeaPluginDescriptorImpl> uniqueCheck, List<IdeaPluginDescriptorImpl> result2) {
        IdeaPluginDescriptorImpl dep;
        IdeaPluginDescriptorImpl implicitDep = hasAllModules ? PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep2) : null;
        uniqueCheck.clear();
        if (implicitDep != null) {
            if (rootDescriptor == implicitDep) {
                PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
            } else {
                uniqueCheck.add(implicitDep);
                result2.add(implicitDep);
            }
        }
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            if (!withOptional && dependency.isOptional()) continue;
            if (pluginSet.findEnabledPlugin(dependency.getPluginId()) == null) {
                continue;
            }
            if (rootDescriptor == dep) {
                if (!(Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)rootDescriptor.getPluginId()) ^ true)) continue;
                PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                continue;
            }
            if (!uniqueCheck.add(dep)) continue;
            result2.add(dep);
        }
        CachingSemiGraphKt.directDependenciesOfModule(rootDescriptor, pluginSet, uniqueCheck, result2);
        if (Intrinsics.areEqual((Object)rootDescriptor.getId(), (Object)PluginManagerCore.CORE_ID) ^ true) {
            for (PluginContentDescriptor.ModuleItem module : rootDescriptor.content.modules) {
                CachingSemiGraphKt.directDependenciesOfModule(module.requireDescriptor(), pluginSet, uniqueCheck, result2);
            }
        }
        for (PluginId moduleId : rootDescriptor.incompatibilities) {
            dep = pluginSet.findEnabledPlugin(moduleId);
            if (dep == null || !uniqueCheck.add(dep)) continue;
            result2.add(dep);
        }
    }

    private static final void directDependenciesOfModule(IdeaPluginDescriptorImpl module, PluginSet pluginSet, Set<IdeaPluginDescriptorImpl> uniqueCheck, List<IdeaPluginDescriptorImpl> result2) {
        IdeaPluginDescriptorImpl it;
        boolean $i$f$processDirectDependencies = false;
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module.dependencies.modules) {
            IdeaPluginDescriptorImpl dep$iv = pluginSet.findEnabledModule(moduleReference.name);
            if (dep$iv == null) continue;
            it = dep$iv;
            boolean bl = false;
            if (!uniqueCheck.add(it)) continue;
            result2.add(it);
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : module.dependencies.plugins) {
            IdeaPluginDescriptorImpl descriptor$iv = pluginSet.findEnabledPlugin(pluginReference.id);
            if (descriptor$iv == null) continue;
            it = descriptor$iv;
            boolean bl = false;
            if (!uniqueCheck.add(it)) continue;
            result2.add(it);
        }
    }

    public static final void processDirectDependencies(@NotNull IdeaPluginDescriptorImpl module, @NotNull PluginSet pluginSet, @NotNull Function1<? super IdeaPluginDescriptorImpl, Unit> processor2) {
        int $i$f$processDirectDependencies = 0;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)pluginSet, (String)"pluginSet");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        for (ModuleDependenciesDescriptor.ModuleReference moduleReference : module.dependencies.modules) {
            IdeaPluginDescriptorImpl dep = pluginSet.findEnabledModule(moduleReference.name);
            if (dep == null) continue;
            processor2.invoke((Object)dep);
        }
        for (ModuleDependenciesDescriptor.PluginReference pluginReference : module.dependencies.plugins) {
            IdeaPluginDescriptorImpl descriptor2 = pluginSet.findEnabledPlugin(pluginReference.id);
            if (descriptor2 == null) continue;
            processor2.invoke((Object)descriptor2);
        }
    }
}

