/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum PluginEnabledState {
    ENABLED("plugins.configurable.enabled.for.all.projects", true, false),
    ENABLED_FOR_PROJECT("plugins.configurable.enabled.for.current.project", true, true),
    DISABLED("plugins.configurable.disabled.for.all.projects", false, false),
    DISABLED_FOR_PROJECT("plugins.configurable.disabled.for.current.project", false, true);

    @NotNull
    @PropertyKey(resourceBundle="messages.CoreBundle")
    private final @NotNull @PropertyKey(resourceBundle="messages.CoreBundle") String myPropertyKey;
    private final boolean myEnabled;
    private final boolean myPerProject;

    private PluginEnabledState(String propertyKey, boolean enabled, boolean perProject) {
        if (propertyKey == null) {
            PluginEnabledState.$$$reportNull$$$0(0);
        }
        this.myPropertyKey = propertyKey;
        this.myEnabled = enabled;
        this.myPerProject = perProject;
    }

    @NotNull
    @Nls
    public String toString() {
        String string = CoreBundle.message((String)this.myPropertyKey, (Object[])new Object[0]);
        if (string == null) {
            PluginEnabledState.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isDisabled() {
        return !this.myEnabled;
    }

    public boolean isPerProject() {
        return this.myPerProject;
    }

    @NotNull
    public PluginEnabledState getInverted() {
        return PluginEnabledState.getState(!this.myEnabled, this.isPerProject());
    }

    @NotNull
    public static PluginEnabledState getState(boolean enabled, boolean perProject) {
        for (PluginEnabledState value2 : PluginEnabledState.values()) {
            if (value2.myEnabled != enabled || value2.myPerProject != perProject) continue;
            PluginEnabledState pluginEnabledState = value2;
            if (pluginEnabledState == null) {
                PluginEnabledState.$$$reportNull$$$0(2);
            }
            return pluginEnabledState;
        }
        throw new IllegalArgumentException("Target state not found: enabled='" + enabled + "', perProject='" + perProject + "'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginEnabledState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginEnabledState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

