/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.newui.HiDPIPluginLogoIcon;
import com.intellij.ide.plugins.newui.LazyPluginLogoIcon;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginLogoIconProvider;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UIThemeProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginLogo {
    static final Logger LOG = Logger.getInstance(PluginLogo.class);
    private static final String CACHE_DIR = "imageCache";
    private static final String PLUGIN_ICON = "pluginIcon.svg";
    private static final String PLUGIN_ICON_DARK = "pluginIcon_dark.svg";
    private static final int PLUGIN_ICON_SIZE = 40;
    private static final int PLUGIN_ICON_SIZE_SCALED = 50;
    private static final Map<String, Pair<PluginLogoIconProvider, PluginLogoIconProvider>> ICONS = ContainerUtil.createWeakValueMap();
    private static PluginLogoIconProvider Default;
    private static List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> myPrepareToLoad;
    private static boolean lafListenerAdded;

    private static void initLafListener() {
        if (!lafListenerAdded) {
            lafListenerAdded = true;
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect().subscribe(LafManagerListener.TOPIC, source -> {
                Default = null;
                HiDPIPluginLogoIcon.clearCache();
            });
            UIThemeProvider.EP_NAME.addChangeListener(() -> {
                Default = null;
                HiDPIPluginLogoIcon.clearCache();
            }, (Disposable)application);
        }
    }

    @NotNull
    public static Icon getIcon(@NotNull IdeaPluginDescriptor descriptor2, boolean big, boolean error2, boolean disabled) {
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(0);
        }
        PluginLogo.initLafListener();
        Icon icon2 = PluginLogo.getIcon(descriptor2).getIcon(big, error2, disabled);
        if (icon2 == null) {
            PluginLogo.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @NotNull
    private static PluginLogoIconProvider getIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons;
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(2);
        }
        if ((icons = PluginLogo.getOrLoadIcon(descriptor2)) != null) {
            PluginLogoIconProvider pluginLogoIconProvider = JBColor.isBright() ? (PluginLogoIconProvider)icons.first : (PluginLogoIconProvider)icons.second;
            if (pluginLogoIconProvider == null) {
                PluginLogo.$$$reportNull$$$0(3);
            }
            return pluginLogoIconProvider;
        }
        return PluginLogo.getDefault();
    }

    public static void startBatchMode() {
        assert (myPrepareToLoad == null);
        myPrepareToLoad = new ArrayList<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>>();
    }

    public static void endBatchMode() {
        assert (myPrepareToLoad != null);
        List<Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> descriptors2 = myPrepareToLoad;
        myPrepareToLoad = null;
        PluginLogo.runLoadTask(descriptors2);
    }

    @NotNull
    static PluginLogoIconProvider getDefault() {
        if (Default == null) {
            Default = new HiDPIPluginLogoIcon(PluginLogo.reloadIcon(AllIcons.Plugins.PluginLogo, 40, 40, LOG), PluginLogo.reloadIcon(AllIcons.Plugins.PluginLogoDisabled, 40, 40, LOG), PluginLogo.reloadIcon(AllIcons.Plugins.PluginLogo, 50, 50, LOG), PluginLogo.reloadIcon(AllIcons.Plugins.PluginLogoDisabled, 50, 50, LOG));
        }
        PluginLogoIconProvider pluginLogoIconProvider = Default;
        if (pluginLogoIconProvider == null) {
            PluginLogo.$$$reportNull$$$0(4);
        }
        return pluginLogoIconProvider;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static Icon reloadIcon(@NotNull Icon icon, int width, int height, @Nullable Logger logger) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static Pair<PluginLogoIconProvider, PluginLogoIconProvider> getOrLoadIcon(@NotNull IdeaPluginDescriptor descriptor2) {
        String idPlugin;
        Pair<PluginLogoIconProvider, PluginLogoIconProvider> icons;
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(10);
        }
        if ((icons = ICONS.get(idPlugin = PluginLogo.getIdForKey(descriptor2))) != null) {
            return icons.first == null && icons.second == null ? null : icons;
        }
        LazyPluginLogoIcon lazyIcon = new LazyPluginLogoIcon(PluginLogo.getDefault());
        Pair lazyIcons = Pair.create((Object)lazyIcon, (Object)lazyIcon);
        ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)lazyIcons);
        Pair info2 = Pair.create((Object)descriptor2, (Object)lazyIcon);
        if (myPrepareToLoad == null) {
            PluginLogo.runLoadTask(Collections.singletonList(info2));
        } else {
            myPrepareToLoad.add((Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>)info2);
        }
        return lazyIcons;
    }

    private static void runLoadTask(@NotNull List<? extends Pair<IdeaPluginDescriptor, LazyPluginLogoIcon>> loadInfo) {
        if (loadInfo == null) {
            PluginLogo.$$$reportNull$$$0(11);
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            for (Pair info2 : loadInfo) {
                if (application.isDisposed()) {
                    return;
                }
                PluginLogo.loadPluginIcons((IdeaPluginDescriptor)info2.first, (LazyPluginLogoIcon)info2.second);
            }
        });
    }

    private static void loadPluginIcons(@NotNull IdeaPluginDescriptor descriptor2, @NotNull LazyPluginLogoIcon lazyIcon) {
        PluginLogoIconProvider dark;
        PluginLogoIconProvider light;
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(12);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(13);
        }
        String idPlugin = PluginLogo.getIdForKey(descriptor2);
        File path2 = descriptor2.getPath();
        if (path2 != null) {
            if (path2.isDirectory()) {
                if (System.getProperty("idea.required.plugins.id") != null && PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, new File(path2, "classes"))) {
                    return;
                }
                if (PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, path2)) {
                    return;
                }
                File libFile = new File(path2, "lib");
                if (!libFile.exists() || !libFile.isDirectory()) {
                    PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
                    return;
                }
                Object[] files2 = libFile.listFiles();
                if (ArrayUtil.isEmpty((Object[])files2)) {
                    PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
                    return;
                }
                for (Object file2 : files2) {
                    if (PluginLogo.tryLoadDirIcons(idPlugin, lazyIcon, (File)file2)) {
                        return;
                    }
                    if (!PluginLogo.tryLoadJarIcons(idPlugin, lazyIcon, (File)file2, false)) continue;
                    return;
                }
            } else {
                PluginLogo.tryLoadJarIcons(idPlugin, lazyIcon, path2, true);
                return;
            }
            PluginLogo.putIcon(idPlugin, lazyIcon, null, null);
            return;
        }
        String idFileName = FileUtil.sanitizeFileName((String)idPlugin);
        File cache2 = new File(PathManager.getPluginTempPath(), CACHE_DIR);
        File lightFile = new File(cache2, idFileName + ".svg");
        File darkFile = new File(cache2, idFileName + "_dark.svg");
        if (cache2.exists()) {
            light = PluginLogo.tryLoadIcon(lightFile);
            dark = PluginLogo.tryLoadIcon(darkFile);
            if (light != null || dark != null) {
                PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
                return;
            }
        }
        try {
            PluginLogo.downloadFile(idPlugin, lightFile, "");
            PluginLogo.downloadFile(idPlugin, darkFile, "&theme=DARCULA");
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        light = PluginLogo.tryLoadIcon(lightFile);
        dark = PluginLogo.tryLoadIcon(darkFile);
        PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
    }

    @NotNull
    private static String getIdForKey(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginLogo.$$$reportNull$$$0(14);
        }
        String string = descriptor2.getPluginId().getIdString() + (descriptor2.getPath() == null || MyPluginModel.getInstallingPlugins().contains(descriptor2) || InstalledPluginsState.getInstance().wasInstalled(descriptor2.getPluginId()) ? "" : "#local");
        if (string == null) {
            PluginLogo.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static boolean tryLoadDirIcons(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @NotNull File path2) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(16);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(17);
        }
        if (path2 == null) {
            PluginLogo.$$$reportNull$$$0(18);
        }
        PluginLogoIconProvider light = PluginLogo.tryLoadIcon(path2, true);
        PluginLogoIconProvider dark = PluginLogo.tryLoadIcon(path2, false);
        if (light != null || dark != null) {
            PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tryLoadJarIcons(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @NotNull File path2, boolean put2) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(19);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(20);
        }
        if (path2 == null) {
            PluginLogo.$$$reportNull$$$0(21);
        }
        if (!FileUtilRt.isJarOrZip((File)path2)) return false;
        if (!path2.exists()) {
            return false;
        }
        try (ZipFile zipFile = new ZipFile(path2);){
            PluginLogoIconProvider light = PluginLogo.tryLoadIcon(zipFile, true);
            PluginLogoIconProvider dark = PluginLogo.tryLoadIcon(zipFile, false);
            if (!put2 && light == null) {
                if (dark == null) return false;
            }
            PluginLogo.putIcon(idPlugin, lazyIcon, light, dark);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        return false;
    }

    private static void downloadFile(@NotNull String idPlugin, @NotNull File file2, @NotNull String theme) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            PluginLogo.$$$reportNull$$$0(23);
        }
        if (theme == null) {
            PluginLogo.$$$reportNull$$$0(24);
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        try {
            Url url = Urls.newFromEncoded((String)(ApplicationInfoImpl.getShadowInstance().getPluginManagerUrl() + "/api/icon?pluginId=" + URLUtil.encodeURIComponent((String)idPlugin) + theme));
            HttpRequests.request((Url)url).productNameAsUserAgent().saveToFile(file2, null);
        }
        catch (HttpRequests.HttpStatusException url) {
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    private static void putIcon(@NotNull String idPlugin, @NotNull LazyPluginLogoIcon lazyIcon, @Nullable PluginLogoIconProvider light, @Nullable PluginLogoIconProvider dark) {
        if (idPlugin == null) {
            PluginLogo.$$$reportNull$$$0(25);
        }
        if (lazyIcon == null) {
            PluginLogo.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (light == null && dark == null) {
                ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)Pair.empty());
                return;
            }
            Pair icons = Pair.create((Object)(light == null ? dark : light), (Object)(dark == null ? light : dark));
            ICONS.put(idPlugin, (Pair<PluginLogoIconProvider, PluginLogoIconProvider>)icons);
            lazyIcon.setLogoIcon(JBColor.isBright() ? (PluginLogoIconProvider)icons.first : (PluginLogoIconProvider)icons.second);
        }, ModalityState.any());
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull File dirFile, boolean light) {
        if (dirFile == null) {
            PluginLogo.$$$reportNull$$$0(27);
        }
        return PluginLogo.tryLoadIcon(new File(dirFile, PluginLogo.getIconFileName(light)));
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull File iconFile) {
        if (iconFile == null) {
            PluginLogo.$$$reportNull$$$0(28);
        }
        return iconFile.exists() && iconFile.length() > 0L ? PluginLogo.loadFileIcon((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> new FileInputStream(iconFile))) : null;
    }

    @Nullable
    private static PluginLogoIconProvider tryLoadIcon(@NotNull ZipFile zipFile, boolean light) {
        ZipEntry iconEntry;
        if (zipFile == null) {
            PluginLogo.$$$reportNull$$$0(29);
        }
        return (iconEntry = zipFile.getEntry(PluginLogo.getIconFileName(light))) == null ? null : PluginLogo.loadFileIcon((ThrowableComputable<? extends InputStream, ? extends IOException>)((ThrowableComputable)() -> zipFile.getInputStream(iconEntry)));
    }

    @NotNull
    public static String getIconFileName(boolean light) {
        String string = "META-INF/" + (light ? PLUGIN_ICON : PLUGIN_ICON_DARK);
        if (string == null) {
            PluginLogo.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static int height() {
        return 40;
    }

    public static int width() {
        return 40;
    }

    @Nullable
    private static PluginLogoIconProvider loadFileIcon(@NotNull ThrowableComputable<? extends InputStream, ? extends IOException> provider2) {
        if (provider2 == null) {
            PluginLogo.$$$reportNull$$$0(31);
        }
        try {
            Icon logo40 = HiDPIPluginLogoIcon.loadSVG((InputStream)provider2.compute(), 40, 40);
            Icon logo80 = HiDPIPluginLogoIcon.loadSVG((InputStream)provider2.compute(), 50, 50);
            return new HiDPIPluginLogoIcon(logo40, logo80);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginLogo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadInfo";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyIcon";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPlugin";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginLogo";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForKey";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 30: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reloadIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadIcon";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runLoadTask";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadPluginIcons";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIdForKey";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadDirIcons";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadJarIcons";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "downloadFile";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "putIcon";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadIcon";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadFileIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

