/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static PsiDirectory mkdirs(PsiManager manager2, String path2) throws IncorrectOperationException {
        if (File.separatorChar != '/' && path2.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("separators must be '/'; path is " + path2);
        }
        PsiDirectory directory = DirectoryUtil.findLongestExistingDirectory(manager2, path2);
        if (directory == null) {
            return null;
        }
        String existingPath = directory.getVirtualFile().getPath();
        if (existingPath.equals(path2)) {
            return directory;
        }
        String postfix = path2.substring(existingPath.length() + 1);
        StringTokenizer tokenizer = new StringTokenizer(postfix, "/");
        while (tokenizer.hasMoreTokens()) {
            directory = directory.createSubdirectory(tokenizer.nextToken());
        }
        return directory;
    }

    @Nullable
    public static PsiDirectory findLongestExistingDirectory(@NotNull PsiManager manager2, @NotNull String path2) {
        if (manager2 == null) {
            DirectoryUtil.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            DirectoryUtil.$$$reportNull$$$0(1);
        }
        PsiDirectory directory = null;
        while (path2.length() > 0) {
            int index2;
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path2);
            if (file2 != null) {
                directory = manager2.findDirectory(file2);
                if (directory != null) break;
                return null;
            }
            if (StringUtil.endsWithChar((CharSequence)path2, (char)'/')) {
                path2 = path2.substring(0, path2.length() - 1);
                if (SystemInfo.isWindows && path2.length() == 2 && path2.charAt(1) == ':') {
                    return null;
                }
            }
            if ((index2 = path2.lastIndexOf(47)) == -1) {
                return null;
            }
            path2 = path2.substring(0, index2);
        }
        return directory;
    }

    public static PsiDirectory createSubdirectories(String subDirName, PsiDirectory baseDirectory, String delim) throws IncorrectOperationException {
        StringTokenizer tokenizer = new StringTokenizer(subDirName, delim);
        PsiDirectory dir = baseDirectory;
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String dirName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                if (firstToken && "~".equals(dirName)) {
                    VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                    if (userHomeDir == null) {
                        throw new IncorrectOperationException("User home directory not found");
                    }
                    PsiDirectory directory1 = baseDirectory.getManager().findDirectory(userHomeDir);
                    if (directory1 == null) {
                        throw new IncorrectOperationException("User home directory not found");
                    }
                    dir = directory1;
                    continue;
                }
                if ("..".equals(dirName)) {
                    if ((dir = dir.getParentDirectory()) != null) continue;
                    throw new IncorrectOperationException("Not a valid directory");
                }
                if (".".equals(dirName)) continue;
                PsiDirectory existingDir = dir.findSubdirectory(dirName);
                if (existingDir != null) {
                    dir = existingDir;
                    continue;
                }
            }
            dir = dir.createSubdirectory(dirName);
            firstToken = false;
        }
        return dir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/DirectoryUtil";
        objectArray[2] = "findLongestExistingDirectory";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

