/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PsiElementBackgroundPresentationComputerKt;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRendererComponent;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J8\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/util/PsiElementBackgroundListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/psi/PsiElement;", "renderer", "Lcom/intellij/ide/util/PsiElementListCellRenderer;", "(Lcom/intellij/ide/util/PsiElementListCellRenderer;)V", "myComponent", "Lcom/intellij/ide/util/PsiElementListCellRendererComponent;", "myLoadingComponentRenderer", "", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.platform.lang.impl"})
public final class PsiElementBackgroundListCellRenderer
implements ListCellRenderer<PsiElement> {
    private final ListCellRenderer<Object> myLoadingComponentRenderer;
    private final PsiElementListCellRendererComponent myComponent;
    private final PsiElementListCellRenderer<?> renderer;

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends PsiElement> list2, @NotNull PsiElement value2, int index2, boolean isSelected, boolean cellHasFocus) {
        Color color;
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Deferred<TargetPresentation> future2 = PsiElementBackgroundPresentationComputerKt.getComputer(list2).computePresentationAsync(this.renderer, value2);
        if (!future2.isCompleted()) {
            Component component2 = this.myLoadingComponentRenderer.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"myLoadingComponentRender\u2026isSelected, cellHasFocus)");
            return component2;
        }
        this.myComponent.removeAll();
        TargetPresentation presentation2 = (TargetPresentation)future2.getCompleted();
        if (isSelected) {
            color = UIUtil.getListSelectionBackground((boolean)cellHasFocus);
        } else {
            color = presentation2.getBackgroundColor();
            if (color == null) {
                Color color2 = UIUtil.getListBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getListBackground()");
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"if (isSelected) {\n      \u2026getListBackground()\n    }");
        Color bg = color;
        this.myComponent.setBackground(bg);
        String locationText = presentation2.getLocationText();
        if (locationText != null) {
            JPanel spacer = new JPanel();
            spacer.setBackground(bg);
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.myComponent.add((Component)spacer, "Center");
            ListCellRenderer rightRenderer2 = new DefaultListCellRenderer(bg, presentation2, locationText){
                final /* synthetic */ Color $bg;
                final /* synthetic */ TargetPresentation $presentation;
                final /* synthetic */ String $locationText;

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList<?> list2, @Nullable Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                    Component component2 = super.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                    this.setForeground(isSelected ? UIUtil.getListSelectionForeground((boolean)cellHasFocus) : UIUtil.getInactiveTextColor());
                    this.setBackground(this.$bg);
                    this.setIcon(this.$presentation.getLocationIcon());
                    this.setText(this.$locationText);
                    this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, UIUtil.getListCellHPadding()));
                    this.setHorizontalTextPosition(2);
                    this.setHorizontalAlignment(4);
                    Component component3 = component2;
                    Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"component");
                    return component3;
                }
                {
                    this.$bg = $captured_local_variable$0;
                    this.$presentation = $captured_local_variable$1;
                    this.$locationText = $captured_local_variable$2;
                }
            };
            Component rightRendererComponent = rightRenderer2.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
            this.myComponent.add(rightRendererComponent, "East");
        }
        ListCellRenderer leftRenderer2 = (ListCellRenderer)new ColoredListCellRenderer<PsiElement>(this, bg, presentation2, list2, value2){
            @NotNull
            private final PsiElementListCellRenderer.ItemMatchers itemMatchers;
            final /* synthetic */ PsiElementBackgroundListCellRenderer this$0;
            final /* synthetic */ Color $bg;
            final /* synthetic */ TargetPresentation $presentation;
            final /* synthetic */ JList $list;
            final /* synthetic */ PsiElement $value;

            @NotNull
            public final PsiElementListCellRenderer.ItemMatchers getItemMatchers() {
                return this.itemMatchers;
            }

            protected void customizeCellRenderer(@NotNull JList<? extends PsiElement> list2, @NotNull PsiElement value2, int index2, boolean selected2, boolean hasFocus) {
                block6: {
                    Object object;
                    String containerText;
                    block8: {
                        block7: {
                            Object object2;
                            block5: {
                                block4: {
                                    Intrinsics.checkNotNullParameter(list2, (String)"list");
                                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                                    this.setBackground(this.$bg);
                                    this.setIcon(this.$presentation.getIcon());
                                    object2 = this.$presentation.getPresentableTextAttributes();
                                    if (object2 == null) break block4;
                                    TextAttributes textAttributes = object2;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    TextAttributes p1 = textAttributes;
                                    boolean bl3 = false;
                                    object2 = SimpleTextAttributes.fromTextAttributes(p1);
                                    if (object2 != null) break block5;
                                }
                                object2 = new SimpleTextAttributes(0, UIUtil.getListForeground((boolean)selected2, (boolean)hasFocus));
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"presentation.presentable\u2026ound(selected, hasFocus))");
                            Object nameAttributes = object2;
                            SpeedSearchUtil.appendColoredFragmentForMatcher((String)this.$presentation.getPresentableText(), (SimpleColoredComponent)((SimpleColoredComponent)this), (SimpleTextAttributes)nameAttributes, (Matcher)this.itemMatchers.nameMatcher, (Color)this.$bg, (boolean)selected2);
                            containerText = this.$presentation.getContainerText();
                            if (containerText == null) break block6;
                            object = this.$presentation.getContainerTextAttributes();
                            if (object == null) break block7;
                            TextAttributes textAttributes = object;
                            boolean bl = false;
                            boolean bl4 = false;
                            TextAttributes it = textAttributes;
                            boolean bl5 = false;
                            object = SimpleTextAttributes.merge(SimpleTextAttributes.fromTextAttributes(it), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            if (object != null) break block8;
                        }
                        object = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    }
                    Object containerTextAttributes = object;
                    this.append(" (", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)containerText, (SimpleColoredComponent)((SimpleColoredComponent)this), (SimpleTextAttributes)containerTextAttributes, (Matcher)this.itemMatchers.locationMatcher, (Color)this.$bg, (boolean)selected2);
                    this.append(")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
            {
                this.this$0 = this$0;
                this.$bg = $captured_local_variable$1;
                this.$presentation = $captured_local_variable$2;
                this.$list = $captured_local_variable$3;
                this.$value = $captured_local_variable$4;
                PsiElementListCellRenderer.ItemMatchers itemMatchers = PsiElementBackgroundListCellRenderer.access$getRenderer$p(this$0).getItemMatchers($captured_local_variable$3, $captured_local_variable$4);
                Intrinsics.checkNotNullExpressionValue((Object)itemMatchers, (String)"renderer.getItemMatchers(list, value)");
                this.itemMatchers = itemMatchers;
            }
        };
        Component leftRendererComponent = leftRenderer2.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
        this.myComponent.add(leftRendererComponent, "West");
        return this.myComponent;
    }

    public PsiElementBackgroundListCellRenderer(@NotNull PsiElementListCellRenderer<?> renderer2) {
        Intrinsics.checkNotNullParameter(renderer2, (String)"renderer");
        this.renderer = renderer2;
        this.myLoadingComponentRenderer = (ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Object> list2, @Nullable Object value2, int index2, boolean selected2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                this.setBackground(UIUtil.getListBackground((boolean)selected2, (boolean)hasFocus));
                this.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                this.append(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
            }
        };
        this.myComponent = new PsiElementListCellRendererComponent();
    }

    public static final /* synthetic */ PsiElementListCellRenderer access$getRenderer$p(PsiElementBackgroundListCellRenderer $this) {
        return $this.renderer;
    }
}

