/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.OpenFilesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeChooserUtils {
    private ScopeChooserUtils() {
    }

    @NotNull
    public static GlobalSearchScope findScopeByName(@NotNull Project project, @Nullable String scopePresentableName) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(0);
        }
        if (scopePresentableName == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        if (OpenFilesScope.getNameText().equals(scopePresentableName)) {
            return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopes.openFilesScope((Project)project));
        }
        if (PredefinedSearchScopeProviderImpl.getCurrentFileScopeName().equals(scopePresentableName)) {
            Object[] array2 = FileEditorManager.getInstance((Project)project).getSelectedFiles();
            List files2 = ContainerUtil.createMaybeSingletonList((Object)((VirtualFile)ArrayUtil.getFirstElement((Object[])array2)));
            GlobalSearchScope scope2 = GlobalSearchScope.filesScope((Project)project, (Collection)files2, (String)PredefinedSearchScopeProviderImpl.getCurrentFileScopeName());
            return ScopeChooserUtils.intersectWithContentScope(project, scope2);
        }
        PredefinedSearchScopeProvider scopeProvider = PredefinedSearchScopeProvider.getInstance();
        for (SearchScope scope3 : scopeProvider.getPredefinedScopes(project, null, false, false, false, false, true)) {
            if (!(scope3 instanceof GlobalSearchScope) || !scope3.getDisplayName().equals(scopePresentableName)) continue;
            if (scope3 instanceof ScratchesSearchScope) {
                ScratchesSearchScope scratchesSearchScope = (ScratchesSearchScope)scope3;
                if (scratchesSearchScope == null) {
                    ScopeChooserUtils.$$$reportNull$$$0(2);
                }
                return scratchesSearchScope;
            }
            return ScopeChooserUtils.intersectWithContentScope(project, (GlobalSearchScope)scope3);
        }
        for (FindInProjectExtension extension2 : FindInProjectExtension.EP_NAME.getExtensionList()) {
            for (NamedScope namedScope : extension2.getFilteredNamedScopes(project)) {
                if (!namedScope.getPresentableName().equals(scopePresentableName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope));
            }
        }
        for (Iterator<Object> iterator2 : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            NamedScope[] scopes;
            for (NamedScope scope5 : scopes = iterator2.getEditableScopes()) {
                if (!scope5.getScopeId().equals(scopePresentableName)) continue;
                return ScopeChooserUtils.intersectWithContentScope(project, GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)scope5));
            }
        }
        if (scopePresentableName.startsWith("Module '") && scopePresentableName.endsWith("'")) {
            GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
            if (globalSearchScope == null) {
                ScopeChooserUtils.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope intersectWithContentScope(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        if (project == null) {
            ScopeChooserUtils.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            ScopeChooserUtils.$$$reportNull$$$0(6);
        }
        GlobalSearchScope globalSearchScope = scope2.intersectWith(ProjectScope.getContentScope((Project)project));
        if (globalSearchScope == null) {
            ScopeChooserUtils.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWithContentScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithContentScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

