/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.diagnostic.DefaultIdeaErrorLogger;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.VMOptions;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ExceptionUtil;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeaLogger
extends Log4jBasedLogger {
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final String REPORT_EVERY_NTH_FREQUENT_EXCEPTION_PROPERTY = "idea.logger.report.every.nth.exception";
    final int REPORT_EVERY_NTH_FREQUENT_EXCEPTION;
    private static final int EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES;
    private static final Supplier<String> ourApplicationInfoProvider;
    private static final ThrowableRenderer ourThrowableRenderer;

    static void setMutedExceptionFrequency(String frequency) {
        System.setProperty(REPORT_EVERY_NTH_FREQUENT_EXCEPTION_PROPERTY, frequency);
    }

    public static void dropFrequentExceptionsCaches() {
        MyCache.cache.invalidateAll();
        MyCache.cache.cleanUp();
    }

    private boolean isTooFrequentException(@Nullable Throwable t, @NotNull Level level) {
        if (level == null) {
            IdeaLogger.$$$reportNull$$$0(0);
        }
        if (t == null || !IdeaLogger.isMutingFrequentExceptionsEnabled() || !LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return false;
        }
        int hash = ThrowableInterner.computeAccurateTraceHashCode((Throwable)t);
        AtomicInteger counter = MyCache.getOrCreate(hash, t);
        int occurrences = counter.incrementAndGet();
        if (occurrences == 1) {
            return false;
        }
        if (occurrences > 1 && occurrences % this.REPORT_EVERY_NTH_FREQUENT_EXCEPTION == 0) {
            this.myLogger.log((Priority)level, (Object)IdeaLogger.getExceptionWasAlreadyReportedNTimesMessage(t, occurrences));
        }
        return true;
    }

    @NotNull
    static String getExceptionWasAlreadyReportedNTimesMessage(@NotNull Throwable t, int occurrences) {
        if (t == null) {
            IdeaLogger.$$$reportNull$$$0(1);
        }
        String string = "Exception '" + t + "' was reported " + occurrences + " times";
        if (string == null) {
            IdeaLogger.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void reportToFus(@NotNull Throwable t) {
        PluginUtil pluginUtil;
        if (t == null) {
            IdeaLogger.$$$reportNull$$$0(3);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isUnitTestMode() && !app.isDisposed() && (pluginUtil = PluginUtil.getInstance()) != null) {
            PluginId pluginId = pluginUtil.findPluginId(t);
            VMOptions.MemoryKind kind = DefaultIdeaErrorLogger.getOOMErrorKind(t);
            LifecycleUsageTriggerCollector.onError(pluginId, t, kind);
        }
    }

    static boolean isMutingFrequentExceptionsEnabled() {
        return EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES > 0;
    }

    @NotNull
    public static ThrowableRenderer getThrowableRenderer() {
        ThrowableRenderer throwableRenderer = ourThrowableRenderer;
        if (throwableRenderer == null) {
            IdeaLogger.$$$reportNull$$$0(4);
        }
        return throwableRenderer;
    }

    IdeaLogger(@NotNull Logger logger) {
        if (logger == null) {
            IdeaLogger.$$$reportNull$$$0(5);
        }
        super(logger);
        this.REPORT_EVERY_NTH_FREQUENT_EXCEPTION = Integer.getInteger(REPORT_EVERY_NTH_FREQUENT_EXCEPTION_PROPERTY, 10);
        LoggerRepository repository = this.myLogger.getLoggerRepository();
        if (repository instanceof ThrowableRendererSupport) {
            ((ThrowableRendererSupport)repository).setThrowableRenderer(ourThrowableRenderer);
        }
    }

    public void error(Object message2) {
        if (message2 instanceof IdeaLoggingEvent) {
            this.myLogger.error(message2);
        } else {
            super.error(message2);
        }
    }

    public void error(String message2, @Nullable Throwable t, Attachment ... attachments) {
        if (attachments == null) {
            IdeaLogger.$$$reportNull$$$0(6);
        }
        if (this.isTooFrequentException(t, Level.ERROR)) {
            return;
        }
        this.myLogger.error((Object)LogMessage.createEvent(t != null ? t : new Throwable(), message2, attachments));
        if (t != null) {
            IdeaLogger.reportToFus(t);
        }
    }

    public void warn(String message2, @Nullable Throwable t) {
        if (this.isTooFrequentException(t, Level.WARN)) {
            return;
        }
        super.warn(message2, IdeaLogger.ensureNotControlFlow((Throwable)t));
    }

    public void error(String message2, @Nullable Throwable t, String ... details) {
        if (details == null) {
            IdeaLogger.$$$reportNull$$$0(7);
        }
        if (this.isTooFrequentException(t, Level.ERROR)) {
            return;
        }
        this.doLogError(message2, t, details);
        this.logErrorHeader(t);
        if (t != null) {
            IdeaLogger.reportToFus(t);
        }
    }

    private void doLogError(String message2, @Nullable Throwable t, String ... details) {
        Object detailString;
        if (details == null) {
            IdeaLogger.$$$reportNull$$$0(8);
        }
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message2, IdeaLogger.ensureNotControlFlow((Throwable)t));
            ExceptionUtil.rethrow((Throwable)t);
        }
        if (!((String)(detailString = String.join((CharSequence)"\n", details))).isEmpty()) {
            detailString = "\nDetails: " + (String)detailString;
        }
        if (ourErrorsOccurred == null) {
            String mess = "Logger errors occurred. See IDEA logs for details. " + (String)(message2 == null || message2.isEmpty() ? "" : "Error message is '" + message2 + "'");
            ourErrorsOccurred = new Exception(mess + (String)detailString, t);
        }
        this.myLogger.error((Object)(message2 + (String)detailString), t);
    }

    private void logErrorHeader(@Nullable Throwable t) {
        ApplicationEx application;
        IdeaPluginDescriptor plugin2;
        this.myLogger.error((Object)ourApplicationInfoProvider.get());
        Properties properties = System.getProperties();
        this.myLogger.error((Object)("JDK: " + properties.getProperty("java.version", "unknown") + "; VM: " + properties.getProperty("java.vm.name", "unknown") + "; Vendor: " + properties.getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + properties.getProperty("os.name", "unknown")));
        if (t != null && PluginManagerCore.arePluginsInitialized() && (plugin2 = PluginManagerCore.getPlugin(PluginUtilImpl.doFindPluginId(t))) != null && (!plugin2.isBundled() || plugin2.allowBundledUpdate())) {
            this.myLogger.error((Object)("Plugin to blame: " + plugin2.getName() + " version: " + plugin2.getVersion()));
        }
        if ((application = ApplicationManagerEx.getApplicationEx()) != null && application.isComponentCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = (CommandProcessor)application.getServiceIfCreated(CommandProcessor.class)) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    static {
        EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES = Integer.getInteger("idea.logger.exception.expiration.minutes", 5);
        ourApplicationInfoProvider = () -> {
            ApplicationInfoEx info2 = ApplicationInfoImpl.getShadowInstance();
            return info2.getFullApplicationName() + "  Build #" + info2.getBuild().asString();
        };
        ourThrowableRenderer = t -> {
            int maxExtraSize;
            int maxStackSize;
            String[] lines2 = DefaultThrowableRenderer.render((Throwable)t);
            if (lines2.length > (maxStackSize = 1024) + (maxExtraSize = 256)) {
                String[] res2 = new String[maxStackSize + maxExtraSize + 1];
                System.arraycopy(lines2, 0, res2, 0, maxStackSize);
                res2[maxStackSize] = "\t...";
                System.arraycopy(lines2, lines2.length - maxExtraSize, res2, maxStackSize + 1, maxExtraSize);
                return res2;
            }
            return lines2;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/IdeaLogger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionWasAlreadyReportedNTimesMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTooFrequentException";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionWasAlreadyReportedNTimesMessage";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportToFus";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doLogError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyCache {
        private static final Cache<@NotNull String, @NotNull AtomicInteger> cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess((long)Math.max(EXPIRE_FREQUENT_EXCEPTIONS_AFTER_MINUTES, 0), TimeUnit.MINUTES).build();

        private MyCache() {
        }

        @NotNull
        private static AtomicInteger getOrCreate(int hash, @NotNull Throwable t) {
            if (t == null) {
                MyCache.$$$reportNull$$$0(0);
            }
            AtomicInteger atomicInteger = (AtomicInteger)cache.get((Object)(hash + ":" + t), __ -> new AtomicInteger());
            if (atomicInteger == null) {
                MyCache.$$$reportNull$$$0(1);
            }
            return atomicInteger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "t";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/idea/IdeaLogger$MyCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/idea/IdeaLogger$MyCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreate";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

