/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.DialogAppender;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.DOMConfigurator;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.adapters.DOMAdapter;
import org.jdom.adapters.JAXPDOMAdapter;
import org.jdom.output.DOMOutputter;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public final class LoggerFactory
implements Logger.Factory {
    private static final String SYSTEM_MACRO = "$SYSTEM_DIR$";
    private static final String APPLICATION_MACRO = "$APPLICATION_DIR$";
    private static final String LOG_DIR_MACRO = "$LOG_DIR$";
    public static final String LOG_FILE_NAME = "idea.log";

    @NotNull
    public static Path getLogFilePath() {
        Path path2 = Path.of(PathManager.getLogPath(), LOG_FILE_NAME);
        if (path2 == null) {
            LoggerFactory.$$$reportNull$$$0(0);
        }
        return path2;
    }

    LoggerFactory() throws Exception {
        System.setProperty("log4j.defaultInitOverride", "true");
        String configPath = System.getProperty("idea.log.config.file");
        if (configPath != null) {
            Path configFile = Path.of(configPath, new String[0]);
            if (!configFile.isAbsolute()) {
                configFile = Path.of(PathManager.getBinPath(), new String[0]).resolve(configPath);
            }
            if (Files.exists(configFile, new LinkOption[0])) {
                LoggerFactory.configureFromXmlFile(configFile);
                return;
            }
        }
        LoggerFactory.configureProgrammatically();
    }

    @NotNull
    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String name) {
        if (name == null) {
            LoggerFactory.$$$reportNull$$$0(1);
        }
        return new IdeaLogger(LogManager.getLoggerRepository().getLogger(name));
    }

    private static void configureFromXmlFile(Path xmlFile) throws Exception {
        String text2 = Files.readString(xmlFile);
        text2 = text2.replace(SYSTEM_MACRO, PathManager.getSystemPath().replace("\\", "\\\\"));
        text2 = text2.replace(APPLICATION_MACRO, PathManager.getHomePath().replace("\\", "\\\\"));
        text2 = text2.replace(LOG_DIR_MACRO, PathManager.getLogPath().replace("\\", "\\\\"));
        Document document = JDOMUtil.loadDocument((Reader)new StringReader(text2));
        Element element2 = new DOMOutputter((DOMAdapter)new JAXPDOMAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public org.w3c.dom.Document createDocument() throws JDOMException {
                String key = "javax.xml.parsers.DocumentBuilderFactory";
                String property2 = System.setProperty(key, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                try {
                    org.w3c.dom.Document document = super.createDocument();
                    return document;
                }
                finally {
                    if (property2 == null) {
                        System.clearProperty(key);
                    } else {
                        System.setProperty(key, property2);
                    }
                }
            }
        }, null, null).output(document).getDocumentElement();
        new DOMConfigurator().doConfigure(element2, LogManager.getLoggerRepository());
    }

    private static void configureProgrammatically() throws IOException {
        Logger root = LogManager.getRootLogger();
        root.removeAllAppenders();
        root.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%d [%7r] %6p - %30.30c - %m \n");
        RollingFileAppender ideaLog = new RollingFileAppender(){

            public void rollOver() {
                super.rollOver();
                IdeaLogger.dropFrequentExceptionsCaches();
            }
        };
        ideaLog.setFile(LoggerFactory.getLogFilePath().toString());
        ideaLog.setLayout((Layout)layout);
        ideaLog.setAppend(true);
        ideaLog.setEncoding(StandardCharsets.UTF_8.name());
        ideaLog.setMaxBackupIndex(12);
        ideaLog.setMaximumFileSize(10000000L);
        ideaLog.activateOptions();
        root.addAppender((Appender)ideaLog);
        ConsoleAppender consoleWarn = new ConsoleAppender((Layout)layout, "System.err");
        LevelRangeFilter warnFilter = new LevelRangeFilter();
        warnFilter.setLevelMin(Level.WARN);
        consoleWarn.addFilter((Filter)warnFilter);
        root.addAppender((Appender)consoleWarn);
        DialogAppender appender2 = new DialogAppender();
        LevelRangeFilter filter = new LevelRangeFilter();
        filter.setLevelMin(Level.INFO);
        appender2.addFilter((Filter)filter);
        root.addAppender((Appender)appender2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/LoggerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/LoggerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

