/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComputeVirtualFileNameStatAction
extends AnAction
implements DumbAware {
    TObjectIntHashMap<String> suffixes = new TObjectIntHashMap();
    TObjectIntHashMap<String> nameCount = new TObjectIntHashMap();

    public ComputeVirtualFileNameStatAction() {
        super(ActionsBundle.messagePointer((String)"action.ComputeVirtualFileNameStatAction.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile[] roots;
        if (e == null) {
            ComputeVirtualFileNameStatAction.$$$reportNull$$$0(0);
        }
        long start2 = System.currentTimeMillis();
        this.suffixes.clear();
        this.nameCount.clear();
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance())) {
            this.compute(root);
        }
        final ArrayList names2 = new ArrayList(this.nameCount.size());
        this.nameCount.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String name, int count) {
                names2.add(Pair.create((Object)name, (Object)count));
                return true;
            }
        });
        names2.sort((o1, o2) -> (Integer)o2.second - (Integer)o1.second);
        System.out.println("Most frequent names (" + names2.size() + " total):");
        int saveByIntern = 0;
        for (Pair pair : names2) {
            int count = (Integer)pair.second;
            String name = (String)pair.first;
            System.out.println(name + " -> " + count);
            saveByIntern += count * name.length();
            if (count != 1) continue;
            break;
        }
        System.out.println("Total save if names were interned: " + saveByIntern + "; ------------");
        System.out.println("Suffix counts:(" + this.suffixes.size() + " total)");
        ComputeVirtualFileNameStatAction.show(this.suffixes);
        final TObjectIntHashMap save2 = new TObjectIntHashMap();
        this.suffixes.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String s, int count) {
                save2.put((Object)s, count * s.length());
                return true;
            }
        });
        System.out.println("Supposed save by stripping suffixes: (" + save2.size() + " total)");
        final List<Pair<String, Integer>> saveSorted = ComputeVirtualFileNameStatAction.show((TObjectIntHashMap<String>)save2);
        final ArrayList<String> picked = new ArrayList<String>();
        while (picked.size() != 15) {
            Pair<String, Integer> cp = saveSorted.get(0);
            String candidate = (String)cp.first;
            picked.add(candidate);
            System.out.println("Candidate: '" + candidate + "', save = " + cp.second);
            picked.sort((o1, o2) -> o2.length() - o1.length());
            saveSorted.clear();
            this.suffixes.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

                public boolean execute(String s, int count) {
                    for (int i2 = picked.size() - 1; i2 >= 0; --i2) {
                        String pick2 = (String)picked.get(i2);
                        if (!pick2.endsWith(s)) continue;
                        count -= ComputeVirtualFileNameStatAction.this.suffixes.get((Object)pick2);
                        break;
                    }
                    saveSorted.add(Pair.create((Object)s, (Object)(s.length() * count)));
                    return true;
                }
            });
            saveSorted.sort((o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        }
        System.out.println("Picked: " + StringUtil.join(picked, s -> "\"" + s + "\"", (String)","));
        picked.sort((o1, o2) -> o2.length() - o1.length());
        int saved = 0;
        for (int i2 = 0; i2 < picked.size(); ++i2) {
            String s2 = (String)picked.get(i2);
            int count = this.suffixes.get((Object)s2);
            for (int k = 0; k < i2; ++k) {
                String prev2 = (String)picked.get(k);
                if (!prev2.endsWith(s2)) continue;
                count -= this.suffixes.get((Object)prev2);
                break;
            }
            saved += count * s2.length();
        }
        System.out.println("total saved = " + saved);
        System.out.println("Time spent: " + (System.currentTimeMillis() - start2));
    }

    private static List<Pair<String, Integer>> show(TObjectIntHashMap<String> prefixes) {
        final ArrayList<Pair<String, Integer>> prefs = new ArrayList<Pair<String, Integer>>(prefixes.size());
        prefixes.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String s, int count) {
                prefs.add(Pair.create((Object)s, (Object)count));
                return true;
            }
        });
        prefs.sort((o1, o2) -> ((Integer)o2.second).compareTo((Integer)o1.second));
        int i2 = 0;
        for (Pair pair : prefs) {
            Integer count = (Integer)pair.second;
            System.out.printf("%60.60s : %d\n", pair.first, count);
            if (i2++ <= 100) continue;
            System.out.println("\n.......<" + count + "...\n");
            break;
        }
        return prefs;
    }

    private void compute(VirtualFile root) {
        String name = root.getName();
        if (!this.nameCount.increment((Object)name)) {
            this.nameCount.put((Object)name, 1);
        }
        for (int i2 = 1; i2 <= name.length(); ++i2) {
            String suffix = name.substring(name.length() - i2);
            if (this.suffixes.increment((Object)suffix)) continue;
            this.suffixes.put((Object)suffix, 1);
        }
        Collection cachedChildren = ((VirtualFileSystemEntry)root).getCachedChildren();
        for (VirtualFile cachedChild : cachedChildren) {
            this.compute(cachedChild);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/ComputeVirtualFileNameStatAction", "actionPerformed"));
    }
}

