/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IconsLoadTime
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(IconsLoadTime.class);
    private static final IntList svgStats = new IntArrayList();
    private static final IntList pngStats = new IntArrayList();

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            IconsLoadTime.$$$reportNull$$$0(0);
        }
        IconsLoadTime.log(false);
    }

    public static void log(boolean measureStartupLoad) {
        IconsLoadTime.log(measureStartupLoad, false);
        IconsLoadTime.log(measureStartupLoad, true);
    }

    private static void log(boolean measureStartupLoad, boolean isSvg) {
        StatData data2 = IconsLoadTime.getStatData(measureStartupLoad, isSvg);
        if (data2 != null) {
            LOG.info(data2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static StatData getStatData(boolean measureStartupLoad, boolean isSvg) {
        IntList stats = IconsLoadTime.getStats(isSvg);
        if (stats.isEmpty()) {
            return null;
        }
        IntList intList = stats;
        synchronized (intList) {
            int size2 = stats.size();
            int sum = stats.stream().mapToInt(Integer::intValue).sum();
            int average = sum / size2;
            int median = size2 % 2 == 0 ? (Integer)stats.get(size2 / 2 - 1) + (Integer)stats.get(size2 / 2) : (Integer)stats.get(size2 / 2);
            return new StatData(isSvg, measureStartupLoad, sum, average, median, size2);
        }
    }

    @NotNull
    private static IntList getStats(boolean isSvg) {
        IntList intList = isSvg ? svgStats : pngStats;
        if (intList == null) {
            IconsLoadTime.$$$reportNull$$$0(1);
        }
        return intList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/IconsLoadTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/IconsLoadTime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class StatData {
        public final boolean isSvg;
        public final boolean startup;
        public final int count;
        public final float totalTime;
        public final float averageTime;
        public final float medianTime;

        private StatData(boolean isSvg, boolean startup, int totalTime, int averageTime, int medianTime, int count) {
            this.isSvg = isSvg;
            this.startup = startup;
            this.count = count;
            this.totalTime = (float)totalTime / 1000000.0f;
            this.averageTime = (float)averageTime / 1000000.0f;
            this.medianTime = (float)medianTime / 1000000.0f;
        }

        public String toString() {
            return "load time: " + (this.startup ? "ide_startup=" : "total=") + String.format("%.02fms", Float.valueOf(this.totalTime)) + ", average=" + String.format("%.02fms", Float.valueOf(this.averageTime)) + ", median=" + String.format("%.02fms", Float.valueOf(this.medianTime)) + ", isSvg=" + this.isSvg + "; number of icons: " + this.count;
        }
    }
}

