/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedValueProfilerDumpHelper
implements CachedValueProfiler.EventConsumer {
    private static final int VERSION = 1;
    private final Project myProject;
    private final File myFileTmp;
    private final MyWriter myWriter;
    private final MyQueue myQueue;
    private static final String _VERSION = "version";
    private static final String _DATA = "data";
    private static final String _FRAME_ENTER = "enter";
    private static final String _FRAME_EXIT = "exit";
    private static final String _VALUE_COMPUTED = "computed";
    private static final String _VALUE_USED = "used";
    private static final String _VALUE_INVALIDATED = "invalidated";
    private static final String _VALUE_REJECTED = "rejected";
    private static final String _TYPE = "e";
    private static final String _FRAME_ID = "fid";
    private static final String _FRAME_PID = "fpid";
    private static final String _PLACE = "p";
    private static final String _T1 = "t1";
    private static final String _T2 = "t2";
    private static final String _T3 = "t3";

    static void toggleProfiling(@NotNull Project project) {
        CachedValueProfiler.EventConsumer prev2;
        if (project == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(0);
        }
        if ((prev2 = CachedValueProfiler.setEventConsumer(null)) == null) {
            try {
                CachedValueProfiler.setEventConsumer((CachedValueProfiler.EventConsumer)new CachedValueProfilerDumpHelper(project));
            }
            catch (IOException ex) {
                CachedValueProfilerDumpHelper.notifyFailure(project, ex);
            }
        } else if (prev2 instanceof CachedValueProfilerDumpHelper) {
            ((CachedValueProfilerDumpHelper)prev2).close();
        }
    }

    private CachedValueProfilerDumpHelper(@NotNull Project project) throws IOException {
        if (project == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFileTmp = CachedValueProfilerDumpHelper.newFile(true);
        this.myWriter = new MyWriter(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(this.myFileTmp))));
        this.myQueue = new MyQueue();
    }

    void close() {
        IOException error2 = null;
        for (Closeable c : Arrays.asList(this.myQueue, this.myWriter)) {
            try {
                c.close();
            }
            catch (IOException ex) {
                if (error2 != null) continue;
                error2 = ex;
            }
        }
        if (error2 == null) {
            error2 = this.myWriter.myError;
        }
        if (error2 != null) {
            CachedValueProfilerDumpHelper.notifyFailure(this.myProject, error2);
            FileUtil.delete((File)this.myFileTmp);
        } else {
            File file2 = CachedValueProfilerDumpHelper.newFile(false);
            try {
                FileUtil.rename((File)this.myFileTmp, (File)file2);
                CachedValueProfilerDumpHelper.notifySuccess(this.myProject, file2);
            }
            catch (IOException e) {
                CachedValueProfilerDumpHelper.notifyFailure(this.myProject, e);
            }
        }
    }

    @NotNull
    private static File newFile(boolean tmp) {
        String fileName = "caches-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(System.currentTimeMillis())) + ".cvperf" + (tmp ? ".tmp" : "");
        return new File(new File(PathManager.getLogPath()), fileName);
    }

    public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
        this.myQueue.offer(() -> this.myWriter.onFrameEnter(frameId, place, parentId, time));
    }

    public void onFrameExit(long frameId, long start2, long computed, long time) {
        this.myQueue.offer(() -> this.myWriter.onFrameExit(frameId, start2, computed, time));
    }

    public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start2, long time) {
        this.myQueue.offer(() -> this.myWriter.onValueComputed(frameId, place, start2, time));
    }

    public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
        this.myQueue.offer(() -> this.myWriter.onValueUsed(frameId, place, computed, time));
    }

    public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
        this.myQueue.offer(() -> this.myWriter.onValueInvalidated(frameId, place, used, time));
    }

    public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start2, long computed, long time) {
        this.myQueue.offer(() -> this.myWriter.onValueRejected(frameId, place, start2, computed, time));
    }

    private static String placeToString(StackTraceElement place) {
        return place.getClassName() + "|" + place.getMethodName() + "|" + place.getFileName() + "|" + place.getLineNumber();
    }

    private static StackTraceElement placeFromString(String place) {
        List split2 = StringUtil.split((String)place, (String)"|", (boolean)true, (boolean)false);
        return new StackTraceElement((String)split2.get(0), (String)split2.get(1), (String)split2.get(2), Integer.parseInt((String)split2.get(3)));
    }

    private static void notifySuccess(final Project project, File file2) {
        String url = FileUtil.getUrl((File)file2);
        boolean fileTypeAvailable = "CVP".equals(FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getName()).getName());
        String message2 = MessageFormat.format("Cached values snapshot is captured to<br>{0}.<br>" + (fileTypeAvailable ? "<a href=\"editor:{1}\">Open in Editor</a><br/>" : "") + "<a href=\"{1}\">{2}</a>", file2.getPath(), url, RevealFileAction.getActionName());
        NotificationGroupManager.getInstance().getNotificationGroup("Cached value profiling").createNotification(message2, NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e.getDescription().startsWith("editor:")) {
                    VirtualFile virtualFile2;
                    VirtualFile virtualFile3 = virtualFile2 = project.isDisposed() ? null : LocalFileSystem.getInstance().findFileByPath(VfsUtilCore.urlToPath((String)VfsUtilCore.fixURLforIDEA((String)URLUtil.unescapePercentSequences((String)e.getDescription().substring(7)))));
                    if (virtualFile2 != null) {
                        new OpenFileDescriptor(project, virtualFile2).navigate(true);
                    }
                } else {
                    RevealFileAction.FILE_SELECTING_LISTENER.hyperlinkUpdate(notification, e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = CachedValueProfilerDumpHelper._TYPE;
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
    }

    private static void notifyFailure(@NotNull Project project, @NotNull Throwable exception) {
        if (project == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(2);
        }
        if (exception == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(3);
        }
        NotificationGroupManager.getInstance().getNotificationGroup("Cached value profiling").createNotification("Failed to capture snapshot: " + exception.getMessage(), NotificationType.ERROR).notify(project);
    }

    @NotNull
    static CachedValueProfiler.EventPlace eventPlace(final @Nullable StackTraceElement place) {
        return new CachedValueProfiler.EventPlace(){

            public StackTraceElement getStackFrame() {
                return place;
            }

            public StackTraceElement @Nullable [] getStackTrace() {
                return null;
            }
        };
    }

    public static void loadDump(@NotNull File file2, @NotNull CachedValueProfiler.EventConsumer consumer) throws IOException {
        if (file2 == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            CachedValueProfilerDumpHelper.$$$reportNull$$$0(5);
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(file2))), StandardCharsets.UTF_8));){
            reader.beginObject();
            int version2 = 0;
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (_VERSION.equals(name)) {
                    version2 = reader.nextInt();
                }
                if (!_DATA.equals(name)) continue;
                break;
            }
            if (version2 != 1) {
                throw new IOException("Unsupported version: " + version2 + " (1 required)");
            }
            reader.beginArray();
            String type = "";
            Map places = FactoryMap.create(o -> CachedValueProfilerDumpHelper.placeFromString(o));
            while (reader.hasNext()) {
                StackTraceElement place = null;
                long frame = 0L;
                long parent = 0L;
                long t1 = 0L;
                long t2 = 0L;
                long t3 = 0L;
                reader.beginObject();
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    if (_TYPE.equals(name)) {
                        type = reader.nextString();
                        continue;
                    }
                    if (_PLACE.equals(name)) {
                        place = (StackTraceElement)places.get(reader.nextString());
                        continue;
                    }
                    if (_FRAME_ID.equals(name)) {
                        frame = reader.nextLong();
                        continue;
                    }
                    if (_FRAME_PID.equals(name)) {
                        parent = reader.nextLong();
                        continue;
                    }
                    if (_T1.equals(name)) {
                        t1 = reader.nextLong();
                        continue;
                    }
                    if (_T2.equals(name)) {
                        t2 = reader.nextLong();
                        continue;
                    }
                    if (_T3.equals(name)) {
                        t3 = reader.nextLong();
                        continue;
                    }
                    throw new IOException("unexpected: " + name);
                }
                reader.endObject();
                if (_FRAME_ENTER.equals(type)) {
                    consumer.onFrameEnter(frame, CachedValueProfilerDumpHelper.eventPlace(place), parent, t1);
                    continue;
                }
                if (_FRAME_EXIT.equals(type)) {
                    consumer.onFrameExit(frame, t1, t2, t3);
                    continue;
                }
                if (_VALUE_COMPUTED.equals(type)) {
                    consumer.onValueComputed(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2);
                    continue;
                }
                if (_VALUE_USED.equals(type)) {
                    consumer.onValueUsed(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2);
                    continue;
                }
                if (_VALUE_INVALIDATED.equals(type)) {
                    consumer.onValueInvalidated(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2);
                    continue;
                }
                if (!_VALUE_REJECTED.equals(type)) continue;
                consumer.onValueRejected(frame, CachedValueProfilerDumpHelper.eventPlace(place), t1, t2, t3);
            }
            reader.endArray();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CachedValueProfilerDumpHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toggleProfiling";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyFailure";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDump";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyWriter
    implements CachedValueProfiler.EventConsumer,
    Closeable {
        final JsonWriter myWriter;
        IOException myError;

        MyWriter(OutputStream out) throws IOException {
            this.myWriter = new JsonWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
            this.myWriter.beginObject();
            this.myWriter.name(CachedValueProfilerDumpHelper._VERSION).value(1L);
            this.myWriter.name(CachedValueProfilerDumpHelper._DATA);
            this.myWriter.beginArray();
        }

        @Override
        public void close() throws IOException {
            this.myWriter.endArray();
            this.myWriter.endObject();
            this.myWriter.close();
        }

        public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._FRAME_ENTER, frameId, place, 1, time, parentId, -1L);
        }

        public void onFrameExit(long frameId, long start2, long computed, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._FRAME_EXIT, frameId, null, 3, start2, computed, time);
        }

        public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start2, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_COMPUTED, frameId, place, 2, start2, time, -1L);
        }

        public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_USED, frameId, place, 2, computed, time, -1L);
        }

        public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_INVALIDATED, frameId, place, 2, used, time, -1L);
        }

        public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start2, long computed, long time) {
            this.writeImpl(CachedValueProfilerDumpHelper._VALUE_REJECTED, frameId, place, 3, start2, computed, time);
        }

        private void writeImpl(String type, long frameId, CachedValueProfiler.EventPlace place, int t_num, long t1, long t2, long t3) {
            block7: {
                try {
                    this.myWriter.beginObject();
                    this.myWriter.name(CachedValueProfilerDumpHelper._TYPE).value(type);
                    this.myWriter.name(CachedValueProfilerDumpHelper._FRAME_ID).value(frameId);
                    if (type == CachedValueProfilerDumpHelper._FRAME_ENTER) {
                        this.myWriter.name(CachedValueProfilerDumpHelper._FRAME_PID).value(t2);
                    }
                    if (place != null) {
                        StackTraceElement frame = place.getStackFrame();
                        this.myWriter.name(CachedValueProfilerDumpHelper._PLACE).value(frame == null ? null : CachedValueProfilerDumpHelper.placeToString(frame));
                    }
                    if (t_num > 0) {
                        this.myWriter.name(CachedValueProfilerDumpHelper._T1).value(t1);
                    }
                    if (t_num > 1) {
                        this.myWriter.name(CachedValueProfilerDumpHelper._T2).value(t2);
                    }
                    if (t_num > 2) {
                        this.myWriter.name(CachedValueProfilerDumpHelper._T3).value(t3);
                    }
                    this.myWriter.endObject();
                }
                catch (IOException e) {
                    if (this.myError == null) break block7;
                    this.myError = e;
                }
            }
        }
    }

    static class MyQueue
    extends ConcurrentLinkedQueue<Runnable>
    implements Runnable,
    Closeable {
        volatile boolean closed;
        final Future<?> future = ProcessIOExecutorService.INSTANCE.submit(this);

        MyQueue() {
        }

        private void drainQueue() {
            Runnable r;
            while ((r = (Runnable)this.poll()) != null) {
                r.run();
            }
        }

        @Override
        public boolean offer(Runnable runnable2) {
            if (this.closed) {
                return false;
            }
            return super.offer(runnable2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.closed) {
                this.drainQueue();
                Future<?> future2 = this.future;
                synchronized (future2) {
                    try {
                        this.future.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.closed = true;
            try {
                Future<?> future2 = this.future;
                synchronized (future2) {
                    this.future.notifyAll();
                }
                this.future.get(500L, TimeUnit.MILLISECONDS);
                this.drainQueue();
            }
            catch (ExecutionException ex) {
                throw new IOException(ex);
            }
            catch (InterruptedException | TimeoutException exception) {
                // empty catch block
            }
        }
    }
}

