/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.catboost;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.function.Function;

public class NaiveCatBoostModel {
    private final int[] floatFeaturesIndex;
    private final int floatFeatureCount;
    private final int binaryFeatureCount;
    private final int treeCount;
    private final ArrayList<double[]> floatFeatureBorders;
    private final int[] treeDepth;
    private final int[] treeSplitBorder;
    private final int[] treeSplitFeatureIndex;
    private final int[] treeSplitXorMask;
    private final double[] leafValues;
    private final double scale;
    private final double bias;

    private NaiveCatBoostModel(int[] floatFeaturesIndex, int floatFeatureCount, int binaryFeatureCount, int treeCount, ArrayList<double[]> borders, int[] treeDepth, int[] treeSplitBorder, int[] treeSplitFeatureIndex, int[] treeSplitXorMask, double[] values2, double scale, double bias) {
        this.floatFeaturesIndex = floatFeaturesIndex;
        this.floatFeatureCount = floatFeatureCount;
        this.binaryFeatureCount = binaryFeatureCount;
        this.treeCount = treeCount;
        this.floatFeatureBorders = borders;
        this.treeDepth = treeDepth;
        this.treeSplitBorder = treeSplitBorder;
        this.treeSplitFeatureIndex = treeSplitFeatureIndex;
        this.treeSplitXorMask = treeSplitXorMask;
        this.leafValues = values2;
        this.scale = scale;
        this.bias = bias;
    }

    public double makePredict(double[] features) {
        assert (features.length >= this.floatFeatureCount);
        int[] binaryFeatures = new int[this.binaryFeatureCount];
        for (int i2 = 0; i2 < this.binaryFeatureCount; ++i2) {
            double[] borders;
            for (double border : borders = this.floatFeatureBorders.get(i2)) {
                int index2 = this.floatFeaturesIndex[i2];
                int n = i2;
                binaryFeatures[n] = binaryFeatures[n] + (features[index2] > border ? 1 : 0);
            }
        }
        double result2 = 0.0;
        int treeSplitsIndex = 0;
        int currentTreeLeafValuesIndex = 0;
        for (int treeId = 0; treeId < this.treeCount; ++treeId) {
            int current_tree_depth = this.treeDepth[treeId];
            int index3 = 0;
            for (int depth = 0; depth < current_tree_depth; ++depth) {
                int feature_index = this.treeSplitFeatureIndex[treeSplitsIndex + depth];
                int xor_mask = this.treeSplitXorMask[treeSplitsIndex + depth];
                int border_val = this.treeSplitBorder[treeSplitsIndex + depth];
                int res2 = (binaryFeatures[feature_index] ^ xor_mask) >= border_val ? 1 : 0;
                index3 |= res2 << depth;
            }
            result2 += this.leafValues[currentTreeLeafValuesIndex + index3];
            treeSplitsIndex += current_tree_depth;
            currentTreeLeafValuesIndex += 1 << current_tree_depth;
        }
        return this.scale * result2 + this.bias;
    }

    public static NaiveCatBoostModel loadModel(InputStream fileStream) throws IOException {
        DataInputStream stream = new DataInputStream(new BufferedInputStream(fileStream));
        int[] floatFeaturesIndex = NaiveCatBoostModel.readIntArray(stream);
        int floatFeatureCount = stream.readInt();
        int binaryFeatureCount = stream.readInt();
        int treeCount = stream.readInt();
        ArrayList<double[]> floatFeatureBorders = NaiveCatBoostModel.readArrayList(stream, s -> {
            try {
                return NaiveCatBoostModel.readDoubleArray(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        int[] treeDepth = NaiveCatBoostModel.readIntArray(stream);
        int[] treeSplitBorder = NaiveCatBoostModel.readIntArray(stream);
        int[] treeSplitFeatureIndex = NaiveCatBoostModel.readIntArray(stream);
        int[] treeSplitXorMask = NaiveCatBoostModel.readIntArray(stream);
        double[] leafValues = NaiveCatBoostModel.readDoubleArray(stream);
        double scale = stream.readDouble();
        double bias = stream.readDouble();
        return new NaiveCatBoostModel(floatFeaturesIndex, floatFeatureCount, binaryFeatureCount, treeCount, floatFeatureBorders, treeDepth, treeSplitBorder, treeSplitFeatureIndex, treeSplitXorMask, leafValues, scale, bias);
    }

    private static int[] readIntArray(DataInputStream stream) throws IOException {
        int length = stream.readInt();
        assert (length > 0);
        byte[] bytes = new byte[length * 4];
        int[] array2 = new int[length];
        stream.readFully(bytes);
        IntBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        buffer.get(array2);
        return array2;
    }

    private static double[] readDoubleArray(DataInputStream stream) throws IOException {
        int length = stream.readInt();
        assert (length > 0);
        byte[] bytes = new byte[length * 8];
        double[] array2 = new double[length];
        stream.readFully(bytes);
        DoubleBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).asDoubleBuffer();
        buffer.get(array2);
        return array2;
    }

    private static <T> ArrayList<T> readArrayList(DataInputStream stream, Function<? super DataInputStream, ? extends T> readElement) throws IOException {
        int size2 = stream.readInt();
        assert (size2 > 0);
        ArrayList<T> list2 = new ArrayList<T>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            T element2 = readElement.apply(stream);
            list2.add(element2);
        }
        return list2;
    }
}

