/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml.ngram;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u001a\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u00110\u0010H\u0007J\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u0011J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/internal/ml/ngram/NGramRecentTokens;", "Ljava/io/Externalizable;", "maxSequenceSize", "", "(I)V", "maxTokenIndex", "nextTokenIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "recent", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "contains", "", "token", "getRecentTokens", "", "Lkotlin/Pair;", "lastIndex", "readExternal", "", "ins", "Ljava/io/ObjectInput;", "removeEldest", "resetTokenIndex", "setMaxTokenIndex", "newMax", "size", "update", "writeExternal", "out", "Ljava/io/ObjectOutput;", "intellij.platform.ml.impl"})
public final class NGramRecentTokens
implements Externalizable {
    private int maxTokenIndex;
    private final AtomicInteger nextTokenIndex;
    private final LinkedHashMap<String, Integer> recent;
    private final int maxSequenceSize;

    public final synchronized void update(@NotNull String token2) {
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        if (this.recent.containsKey(token2)) {
            this.recent.remove(token2);
        }
        ((Map)this.recent).put(token2, this.nextTokenIndex.getAndIncrement());
        if (this.nextTokenIndex.get() > this.maxTokenIndex) {
            this.resetTokenIndex();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void resetTokenIndex() {
        int first = this.nextTokenIndex.get() - this.maxSequenceSize;
        int newLast = 0;
        Object object = this.recent;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            int n = 0;
            object = (String)entry3.getKey();
            entry3 = entry2;
            n = 0;
            int value2 = ((Number)entry3.getValue()).intValue();
            n = value2 - first + 1;
            int n2 = 0;
            boolean bl2 = false;
            int newIdx = Math.max(n, n2);
            ((Map)this.recent).put(key, newIdx);
            n = 0;
            newLast = Math.max(newLast, newIdx);
        }
        this.nextTokenIndex.set(newLast + 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Pair<String, Integer> removeEldest() {
        void token2;
        Map.Entry entry2;
        Map.Entry entry3 = this.recent;
        boolean bl = false;
        entry3 = entry2 = entry3.entrySet().iterator().next();
        bl = false;
        String string = (String)entry3.getKey();
        entry3 = entry2;
        bl = false;
        int id2 = ((Number)entry3.getValue()).intValue();
        this.recent.remove(token2);
        return TuplesKt.to((Object)token2, (Object)id2);
    }

    public final synchronized boolean contains(@NotNull String token2) {
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        Map map2 = this.recent;
        boolean bl = false;
        Map map3 = map2;
        boolean bl2 = false;
        return map3.containsKey(token2);
    }

    public final synchronized int lastIndex() {
        return this.nextTokenIndex.get() - 1;
    }

    public final synchronized int size() {
        return this.recent.size();
    }

    @Override
    public synchronized void writeExternal(@NotNull ObjectOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInt(this.nextTokenIndex.get());
        out.writeInt(this.recent.size());
        Map map2 = this.recent;
        boolean bl = false;
        for (Map.Entry entry2 : map2.entrySet()) {
            out.writeObject(entry2.getKey());
            out.writeInt(((Number)entry2.getValue()).intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void readExternal(@NotNull ObjectInput ins) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ins, (String)"ins");
        this.nextTokenIndex.set(ins.readInt());
        int recentSize = ins.readInt();
        int n = 0;
        int n2 = recentSize;
        while (n < n2) {
            void i2;
            Object object = ins.readObject();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            ((Map)this.recent).put((String)object, ins.readInt());
            ++i2;
        }
    }

    @TestOnly
    public final void setMaxTokenIndex(int newMax) {
        this.maxTokenIndex = newMax;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final List<Pair<String, Integer>> getRecentTokens() {
        boolean bl = false;
        ArrayList<Pair> recentTokens = new ArrayList<Pair>();
        Object object = this.recent;
        boolean bl2 = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry entry2;
            Map.Entry entry3 = entry2 = iterator2.next();
            boolean bl3 = false;
            object = (String)entry3.getKey();
            entry3 = entry2;
            bl3 = false;
            int value2 = ((Number)entry3.getValue()).intValue();
            recentTokens.add(TuplesKt.to((Object)key, (Object)value2));
        }
        return recentTokens;
    }

    public NGramRecentTokens(int maxSequenceSize) {
        this.maxSequenceSize = maxSequenceSize;
        this.maxTokenIndex = 0x7FFFFFFE;
        this.nextTokenIndex = new AtomicInteger(1);
        this.recent = new LinkedHashMap();
    }
}

