/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.retype.RetypeFileAction;
import com.intellij.internal.retype.RetypeOptions;
import com.intellij.internal.retype.RetypeOptionsDialog;
import com.intellij.internal.retype.RetypeQueue;
import com.intellij.internal.retype.RetypeSession;
import com.intellij.internal.retype.RetypeSessionKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/retype/RetypeFileAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "collectSizeSampledFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "extension", "", "count", "", "queue", "Lcom/intellij/internal/retype/RetypeQueue;", "update", "CandidateFile", "intellij.platform.lang.impl"})
public final class RetypeFileAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        RetypeSession existingSession;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.EDITOR);
        if (!(object instanceof EditorImpl)) {
            object = null;
        }
        EditorImpl editor = (EditorImpl)object;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData(CommonDataKeys.PROJECT) ?: return");
        Project project2 = project;
        EditorImpl editorImpl = editor;
        RetypeSession retypeSession = existingSession = editorImpl != null ? (RetypeSession)editorImpl.getUserData(RetypeSessionKt.getRETYPE_SESSION_KEY()) : null;
        if (existingSession != null) {
            existingSession.stop(false);
        } else {
            RetypeOptions retypeOptions = new RetypeOptions(project2);
            RetypeOptionsDialog retypeOptionsDialog = new RetypeOptionsDialog(project2, retypeOptions, editor);
            if (!retypeOptionsDialog.showAndGet()) {
                return;
            }
            StringBuilder scriptBuilder = retypeOptions.getRecordScript() ? new StringBuilder() : null;
            int largeIndexFileCount = retypeOptions.getEnableLargeIndexing() ? retypeOptions.getLargeIndexFilesCount() : -1;
            LatenciometerKt.getLatencyMap().clear();
            if (retypeOptions.getRetypeCurrentFile()) {
                EditorImpl editorImpl2 = editor;
                Intrinsics.checkNotNull((Object)editorImpl2);
                int n = largeIndexFileCount;
                boolean bl = retypeOptions.getRestoreOriginalText();
                RetypeSession session2 = new RetypeSession(project2, editorImpl2, retypeOptions.getRetypeDelay(), scriptBuilder, retypeOptions.getThreadDumpDelay(), null, n, bl, 32, null);
                session2.start();
            } else {
                RetypeQueue queue2 = new RetypeQueue(project2, retypeOptions.getRetypeDelay(), retypeOptions.getThreadDumpDelay(), scriptBuilder, largeIndexFileCount, retypeOptions.getRestoreOriginalText());
                if (!this.collectSizeSampledFiles(project2, StringsKt.removePrefix((String)retypeOptions.getRetypeExtension(), (CharSequence)"."), retypeOptions.getFileCount(), queue2)) {
                    return;
                }
                queue2.processNext();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean collectSizeSampledFiles(Project project, String extension2, int count, RetypeQueue queue2) {
        int n;
        boolean bl = false;
        List candidates = new ArrayList();
        boolean result2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(project, extension2, candidates){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $extension;
            final /* synthetic */ List $candidates;

            public final void run() {
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                projectRootManager.getFileIndex().iterateContent(new ContentIterator(this){
                    final /* synthetic */ collectSizeSampledFiles.result.1 this$0;

                    public final boolean processFile(@NotNull VirtualFile file2) {
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        ProgressManager.checkCanceled();
                        if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)this.this$0.$extension) && file2.getLength() > 0L) {
                            this.this$0.$candidates.add(new CandidateFile(file2, file2.getLength()));
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
                this.$extension = string;
                this.$candidates = list2;
            }
        }, "Scanning files", true, project);
        if (!result2) {
            return false;
        }
        List $this$sortBy$iv = candidates;
        int $i$f$sortBy = 0;
        if ($this$sortBy$iv.size() > 1) {
            n = 0;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    CandidateFile it = (CandidateFile)a;
                    boolean bl2 = false;
                    Comparable comparable = Long.valueOf(it.getSize());
                    it = (CandidateFile)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Long l = it.getSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            });
        }
        if (count == 1) {
            queue2.getFiles().add(((CandidateFile)candidates.get(new Random().nextInt(candidates.size()))).getVirtualFile());
        } else {
            int stride = candidates.size() / (count - 1);
            int n2 = 0;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(n2, candidates.size())), (int)stride);
            $i$f$sortBy = intProgression.getFirst();
            n = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = $i$f$sortBy;
            int n5 = n;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void index2;
                    queue2.getFiles().add(((CandidateFile)candidates.get(RangesKt.coerceAtMost((int)index2, (int)(candidates.size() - 1)))).getVirtualFile());
                    if (index2 == n) break;
                    index2 += n3;
                }
            }
        }
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        RetypeSession retypeSession;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(e.getProject() != null);
        Editor editor2 = editor;
        RetypeSession retypeSession2 = retypeSession = editor2 != null ? (RetypeSession)editor2.getUserData(RetypeSessionKt.getRETYPE_SESSION_KEY()) : null;
        if (retypeSession != null) {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setText("Stop Retyping");
        } else {
            Presentation presentation4 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
            presentation4.setText("Retype File(s)");
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/retype/RetypeFileAction$CandidateFile;", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "size", "", "(Lcom/intellij/openapi/vfs/VirtualFile;J)V", "getSize", "()J", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class CandidateFile {
        @NotNull
        private final VirtualFile virtualFile;
        private final long size;

        @NotNull
        public final VirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        public final long getSize() {
            return this.size;
        }

        public CandidateFile(@NotNull VirtualFile virtualFile2, long size2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            this.virtualFile = virtualFile2;
            this.size = size2;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.virtualFile;
        }

        public final long component2() {
            return this.size;
        }

        @NotNull
        public final CandidateFile copy(@NotNull VirtualFile virtualFile2, long size2) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            return new CandidateFile(virtualFile2, size2);
        }

        public static /* synthetic */ CandidateFile copy$default(CandidateFile candidateFile, VirtualFile virtualFile2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = candidateFile.virtualFile;
            }
            if ((n & 2) != 0) {
                l = candidateFile.size;
            }
            return candidateFile.copy(virtualFile2, l);
        }

        @NotNull
        public String toString() {
            return "CandidateFile(virtualFile=" + this.virtualFile + ", size=" + this.size + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.virtualFile;
            return (virtualFile2 != null ? virtualFile2.hashCode() : 0) * 31 + Long.hashCode(this.size);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CandidateFile)) break block3;
                    CandidateFile candidateFile = (CandidateFile)object;
                    if (!Intrinsics.areEqual((Object)this.virtualFile, (Object)candidateFile.virtualFile) || this.size != candidateFile.size) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

