/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.navigation;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.json.JsonUtil;
import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import org.jetbrains.annotations.Nullable;

public class JsonQualifiedNameProvider
implements QualifiedNameProvider {
    @Override
    @Nullable
    public PsiElement adjustElementToCopy(PsiElement element2) {
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName(PsiElement element2) {
        return JsonQualifiedNameProvider.generateQualifiedName(element2, JsonQualifiedNameKind.Qualified);
    }

    public static String generateQualifiedName(PsiElement element2, JsonQualifiedNameKind qualifiedNameKind) {
        if (!(element2 instanceof JsonElement)) {
            return null;
        }
        JsonElement parentProperty2 = (JsonElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        StringBuilder builder2 = new StringBuilder();
        while (parentProperty2 != null) {
            if (parentProperty2 instanceof JsonProperty) {
                String name = parentProperty2.getName();
                if (qualifiedNameKind == JsonQualifiedNameKind.JsonPointer) {
                    name = name == null ? null : JsonPointerUtil.escapeForJsonPointer(name);
                }
                builder2.insert(0, name);
                builder2.insert(0, qualifiedNameKind == JsonQualifiedNameKind.JsonPointer ? "/" : ".");
            } else {
                int index2 = JsonUtil.getArrayIndexOfItem(element2 instanceof JsonProperty ? element2.getParent() : element2);
                if (index2 == -1) {
                    return null;
                }
                builder2.insert(0, qualifiedNameKind == JsonQualifiedNameKind.JsonPointer ? "/" + index2 : "[" + index2 + "]");
            }
            element2 = parentProperty2;
            parentProperty2 = (JsonElement)PsiTreeUtil.getParentOfType((PsiElement)parentProperty2, (Class[])new Class[]{JsonProperty.class, JsonArray.class});
        }
        if (builder2.length() == 0) {
            return null;
        }
        if (builder2.charAt(0) == '[') {
            builder2.insert(0, "$");
        }
        return StringUtil.trimStart((String)builder2.toString(), (String)".");
    }

    @Override
    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        return null;
    }
}

