/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.surroundWith;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.surroundWith.JsonSurrounderBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonWithObjectLiteralSurrounder
extends JsonSurrounderBase {
    public String getTemplateDescription() {
        return JsonBundle.message("surround.with.object.literal.desc", new Object[0]);
    }

    @Override
    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(0);
        }
        return !JsonPsiUtil.isPropertyKey(elements[0]) && (elements[0] instanceof JsonProperty || elements.length == 1);
    }

    @Override
    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        JsonValue newNameElement;
        if (project == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(3);
        }
        if (!this.isApplicable(elements)) {
            return null;
        }
        JsonElementGenerator generator2 = new JsonElementGenerator(project);
        PsiElement firstElement = elements[0];
        if (firstElement instanceof JsonValue) {
            assert (elements.length == 1) : "Only single JSON value can be wrapped in object literal";
            JsonObject replacement = (JsonObject)generator2.createValue(this.createReplacementText(firstElement.getText()));
            replacement = (JsonObject)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getPropertyList().get(0).getNameElement();
        } else {
            assert (firstElement instanceof JsonProperty);
            String propertiesText = JsonWithObjectLiteralSurrounder.getTextAndRemoveMisc(firstElement, elements[elements.length - 1]);
            JsonObject tempJsonObject = (JsonObject)generator2.createValue(this.createReplacementText("{\n" + propertiesText) + "\n}");
            JsonProperty replacement = tempJsonObject.getPropertyList().get(0);
            replacement = (JsonProperty)firstElement.replace((PsiElement)replacement);
            newNameElement = replacement.getNameElement();
        }
        TextRange rangeWithQuotes = newNameElement.getTextRange();
        return new TextRange(rangeWithQuotes.getStartOffset() + 1, rangeWithQuotes.getEndOffset() - 1);
    }

    @Override
    @NotNull
    protected String createReplacementText(@NotNull String textInRange) {
        if (textInRange == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(4);
        }
        String string = "{\n\"property\": " + textInRange + "\n}";
        if (string == null) {
            JsonWithObjectLiteralSurrounder.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textInRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/surroundWith/JsonWithObjectLiteralSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/surroundWith/JsonWithObjectLiteralSurrounder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "surroundElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReplacementText";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

