/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.psi;

import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JsonPathPsiUtils {
    private static final String ourEscapesTable = "\"\"\\\\//b\bf\fn\nr\rt\t";
    static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("JSONPATH string fragments");

    private JsonPathPsiUtils() {
    }

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull JsonPathStringLiteral literal) {
        int contentEnd;
        List cached;
        if (literal == null) {
            JsonPathPsiUtils.$$$reportNull$$$0(0);
        }
        if ((cached = (List)literal.getUserData(STRING_FRAGMENTS)) != null) {
            List list2 = cached;
            if (list2 == null) {
                JsonPathPsiUtils.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<Pair<TextRange, String>> result2 = new ArrayList<Pair>();
        String text2 = literal.getText();
        int length = text2.length();
        int pos = 1;
        int unescapedSequenceStart = 1;
        while (pos < length) {
            if (text2.charAt(pos) == '\\') {
                if (unescapedSequenceStart != pos) {
                    result2.add(Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text2.substring(unescapedSequenceStart, pos)));
                }
                if (pos == length - 1) {
                    result2.add(Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                    break;
                }
                char next = text2.charAt(pos + 1);
                switch (next) {
                    case '\"': 
                    case '/': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        int idx = ourEscapesTable.indexOf(next);
                        result2.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)ourEscapesTable.substring(idx + 1, idx + 2)));
                        pos += 2;
                        break;
                    }
                    case 'u': {
                        int i2;
                        for (i2 = pos + 2; i2 < pos + 6 && i2 != length && StringUtil.isHexDigit((char)text2.charAt(i2)); ++i2) {
                        }
                        result2.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, i2), (Object)text2.substring(pos, i2)));
                        pos = i2;
                        break;
                    }
                    default: {
                        result2.add((Pair<TextRange, String>)Pair.create((Object)new TextRange(pos, pos + 2), (Object)text2.substring(pos, pos + 2)));
                        pos += 2;
                    }
                }
                unescapedSequenceStart = pos;
                continue;
            }
            ++pos;
        }
        int n = contentEnd = text2.charAt(0) == text2.charAt(length - 1) ? length - 1 : length;
        if (unescapedSequenceStart < contentEnd) {
            result2.add(Pair.create((Object)new TextRange(unescapedSequenceStart, contentEnd), (Object)text2.substring(unescapedSequenceStart, contentEnd)));
        }
        result2 = Collections.unmodifiableList(result2);
        literal.putUserData(STRING_FRAGMENTS, result2);
        ArrayList<Pair<TextRange, String>> arrayList = result2;
        if (arrayList == null) {
            JsonPathPsiUtils.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsonpath/psi/JsonPathPsiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsonpath/psi/JsonPathPsiUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTextFragments";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

