/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiUtilCore;

public final class LanguageTokenSeparatorGenerators
extends LanguageExtension<TokenSeparatorGenerator> {
    public static final LanguageTokenSeparatorGenerators INSTANCE = new LanguageTokenSeparatorGenerators();

    private LanguageTokenSeparatorGenerators() {
        super("com.intellij.lang.tokenSeparatorGenerator", (Object)new TokenSeparatorGenerator(){

            public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
                ParserDefinition parserDefinition;
                Language l = PsiUtilCore.getNotAnyLanguage((ASTNode)left);
                Language rightLang = PsiUtilCore.getNotAnyLanguage((ASTNode)right);
                if (rightLang.isKindOf(l)) {
                    l = rightLang;
                }
                if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l)) != null) {
                    LeafElement generatedWhitespace;
                    PsiManager manager2 = right.getTreeParent().getPsi().getManager();
                    switch (parserDefinition.spaceExistenceTypeBetweenTokens(left, right)) {
                        case MUST: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, " ", 0, 1, null, manager2);
                            break;
                        }
                        case MUST_LINE_BREAK: {
                            generatedWhitespace = Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager2);
                            break;
                        }
                        default: {
                            generatedWhitespace = null;
                        }
                    }
                    return generatedWhitespace;
                }
                return null;
            }
        });
    }
}

