/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.XmlCodeFoldingSettings;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlEmbeddedContentImpl;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.IXmlAttributeElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlCodeFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final TokenSet XML_ATTRIBUTE_SET = TokenSet.forAllMatching(el -> el instanceof IXmlAttributeElementType);
    private static final int MIN_TEXT_RANGE_LENGTH = 3;

    public void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> foldings, @NotNull PsiElement psiElement, @NotNull Document document, boolean quick) {
        XmlTag rootTag;
        XmlDocument xmlDocument;
        if (foldings == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof XmlFile) {
            XmlFile file2 = (XmlFile)psiElement;
            xmlDocument = file2.getDocument();
        } else {
            xmlDocument = psiElement instanceof XmlDocument ? (XmlDocument)psiElement : (XmlDocument)PsiTreeUtil.getChildOfType((PsiElement)psiElement, XmlDocument.class);
        }
        XmlTag xmlTag = rootTag = xmlDocument == null ? null : xmlDocument.getRootTag();
        if (rootTag == null) {
            rootTag = xmlDocument;
        }
        if (rootTag != null) {
            this.doAddForChildren((XmlElement)xmlDocument, foldings, document);
        }
    }

    protected void addElementsToFold(List<FoldingDescriptor> foldings, XmlElement tag2, Document document) {
        this.addToFold(foldings, (PsiElement)tag2, document);
        this.doAddForChildren(tag2, foldings, document);
    }

    protected void doAddForChildren(XmlElement tag2, List<FoldingDescriptor> foldings, Document document) {
        PsiElement[] children2;
        for (PsiElement child2 : children2 = tag2.getChildren()) {
            FoldingBuilder foldingBuilder;
            ProgressManager.checkCanceled();
            if (child2 instanceof XmlTag || child2 instanceof XmlConditionalSection) {
                this.addElementsToFold(foldings, (XmlElement)child2, document);
                continue;
            }
            if (child2 instanceof XmlComment) {
                this.addToFold(foldings, child2, document);
                continue;
            }
            if (child2 instanceof XmlText || child2 instanceof XmlProlog) {
                PsiElement[] grandChildren;
                for (PsiElement grandChild : grandChildren = child2.getChildren()) {
                    ProgressManager.checkCanceled();
                    if (!(grandChild instanceof XmlComment) && !XmlCodeFoldingBuilder.isEntity(grandChild)) continue;
                    this.addToFold(foldings, grandChild, document);
                }
                continue;
            }
            if (XmlCodeFoldingBuilder.isEntity(child2) || child2 instanceof XmlAttribute && XmlCodeFoldingBuilder.isAttributeShouldBeFolded((XmlAttribute)child2)) {
                this.addToFold(foldings, child2, document);
                continue;
            }
            Language language = child2.getLanguage();
            if ((language instanceof XMLLanguage || language == Language.ANY) && !(child2 instanceof HtmlEmbeddedContentImpl) || (foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language)) == null) continue;
            Object[] foldingDescriptors = foldingBuilder.buildFoldRegions(child2.getNode(), document);
            ContainerUtil.addAll(foldings, (Object[])foldingDescriptors);
        }
    }

    @Nullable
    public TextRange getRangeToFold(PsiElement element2) {
        if (element2 instanceof XmlTag) {
            ASTNode tagNode = element2.getNode();
            XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element2));
            if (tagNameElement == null) {
                return null;
            }
            int nameEnd = tagNameElement.getTextRange().getEndOffset();
            int end = tagNode.getLastChildNode().getTextRange().getEndOffset() - 1;
            ASTNode[] attributes2 = tagNode.getChildren(XML_ATTRIBUTE_SET);
            if (attributes2.length > 0) {
                ASTNode lastAttribute = attributes2[attributes2.length - 1];
                ASTNode lastAttributeBeforeCR = null;
                for (ASTNode child2 = tagNode.getFirstChildNode(); child2 != lastAttribute.getTreeNext(); child2 = child2.getTreeNext()) {
                    if (child2.getElementType() == XmlElementType.XML_ATTRIBUTE) {
                        lastAttributeBeforeCR = child2;
                        continue;
                    }
                    if (child2.getPsi() instanceof PsiWhiteSpace && child2.textContains('\n')) break;
                }
                if (lastAttributeBeforeCR != null) {
                    int attributeEnd = lastAttributeBeforeCR.getTextRange().getEndOffset();
                    return new UnfairTextRange(attributeEnd, end);
                }
            }
            return new UnfairTextRange(nameEnd, end);
        }
        if (element2 instanceof XmlComment) {
            XmlComment xmlComment = (XmlComment)element2;
            TextRange textRange = element2.getTextRange();
            int commentStartOffset = this.getCommentStartOffset(xmlComment);
            int commentEndOffset = this.getCommentStartEnd(xmlComment);
            if (textRange.getEndOffset() - textRange.getStartOffset() > commentStartOffset + commentEndOffset) {
                return new TextRange(textRange.getStartOffset() + commentStartOffset, textRange.getEndOffset() - commentEndOffset);
            }
            return null;
        }
        if (element2 instanceof XmlConditionalSection) {
            XmlConditionalSection conditionalSection = (XmlConditionalSection)element2;
            TextRange textRange = element2.getTextRange();
            PsiElement bodyStart = conditionalSection.getBodyStart();
            int startOffset = bodyStart != null ? bodyStart.getStartOffsetInParent() : 3;
            int endOffset = 3;
            if (textRange.getEndOffset() - textRange.getStartOffset() > startOffset + endOffset) {
                return new TextRange(textRange.getStartOffset() + startOffset, textRange.getEndOffset() - endOffset);
            }
            return null;
        }
        if (element2 instanceof XmlAttribute) {
            XmlAttributeValue valueElement = ((XmlAttribute)element2).getValueElement();
            return valueElement != null ? valueElement.getValueTextRange() : null;
        }
        if (XmlCodeFoldingBuilder.isEntity(element2)) {
            return element2.getTextRange();
        }
        return null;
    }

    protected int getCommentStartOffset(XmlComment element2) {
        return 4;
    }

    protected int getCommentStartEnd(XmlComment element2) {
        return 3;
    }

    protected boolean addToFold(List<? super FoldingDescriptor> foldings, PsiElement elementToFold, Document document) {
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range2 = this.getRangeToFold(elementToFold);
        if (range2 == null) {
            return false;
        }
        if (range2.getStartOffset() >= 0 && range2.getEndOffset() <= elementToFold.getContainingFile().getTextRange().getEndOffset() && range2.getEndOffset() <= document.getTextLength()) {
            int startLine = document.getLineNumber(range2.getStartOffset());
            int endLine = document.getLineNumber(range2.getEndOffset() - 1);
            boolean entity = XmlCodeFoldingBuilder.isEntity(elementToFold);
            if ((startLine < endLine || elementToFold instanceof XmlAttribute || entity) && (range2.getStartOffset() + 3 < range2.getEndOffset() || entity)) {
                ASTNode node2 = elementToFold.getNode();
                String placeholder = this.getLanguagePlaceholderText(node2, range2);
                foldings.add((FoldingDescriptor)(placeholder != null ? new FoldingDescriptor(node2, range2, null, placeholder) : new FoldingDescriptor(node2, range2)));
                return true;
            }
        }
        return false;
    }

    public String getLanguagePlaceholderText(@NotNull ASTNode node2, @NotNull TextRange range2) {
        PsiElement psi;
        FoldingBuilder foldingBuilder;
        if (node2 == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range2 == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((foldingBuilder = LanguageFolding.INSTANCE.forLanguage((psi = node2.getPsi()).getLanguage())) == this || foldingBuilder instanceof CompositeFoldingBuilder) {
            String value2;
            if (psi instanceof XmlAttribute && "src".equalsIgnoreCase(((XmlAttribute)psi).getName())) {
                return "data:";
            }
            if (psi instanceof XmlTag || psi instanceof XmlComment || psi instanceof XmlAttribute || psi instanceof XmlConditionalSection) {
                return "...";
            }
            if (XmlCodeFoldingBuilder.isEntity(psi) && (value2 = XmlCodeFoldingBuilder.getEntityPlaceholder(psi)) != null) {
                return value2;
            }
            return null;
        }
        return foldingBuilder instanceof CustomFoldingBuilder ? ((CustomFoldingBuilder)foldingBuilder).getPlaceholderText(node2, range2) : null;
    }

    @Nullable
    public static String getEntityPlaceholder(@NotNull PsiElement psi) {
        String text2;
        String fastPath;
        if (psi == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (!StringUtil.equals((CharSequence)(fastPath = StringUtil.unescapeXmlEntities((String)(text2 = psi.getText()))), (CharSequence)text2)) {
            return fastPath;
        }
        if (psi.isValid()) {
            XmlAttributeValue value2;
            XmlEntityDecl resolve2 = XmlEntityRefImpl.resolveEntity((XmlElement)psi, text2, psi.getContainingFile());
            XmlAttributeValue xmlAttributeValue = value2 = resolve2 != null ? resolve2.getValueElement() : null;
            if (value2 != null) {
                return XmlCodeFoldingBuilder.getEntityValue(value2.getValue());
            }
        }
        return null;
    }

    @Nullable
    public static String getEntityValue(@Nullable String value2) {
        int i2;
        int n = i2 = value2 != null ? value2.indexOf(35) : -1;
        if (i2 > 0) {
            int radix = 10;
            String number = value2.substring(i2 + 1);
            if (StringUtil.startsWithIgnoreCase((String)number, (String)"x")) {
                radix = 16;
                number = number.substring(1);
            }
            try {
                int charNum = Integer.parseInt(StringUtil.trimEnd((String)number, (String)";"), radix);
                return String.valueOf((char)charNum);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isRegionCollapsedByDefault(@NotNull ASTNode node2) {
        PsiElement psi;
        FoldingBuilder foldingBuilder;
        if (node2 == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(6);
        }
        if ((foldingBuilder = LanguageFolding.INSTANCE.forLanguage((psi = node2.getPsi()).getLanguage())) == this || foldingBuilder instanceof CompositeFoldingBuilder) {
            return this.isPsiElementCollapsedByDefault(psi);
        }
        return foldingBuilder.isCollapsedByDefault(node2);
    }

    private boolean isPsiElementCollapsedByDefault(PsiElement psi) {
        XmlCodeFoldingSettings foldingSettings = this.getFoldingSettings();
        return psi instanceof XmlTag && foldingSettings.isCollapseXmlTags() || psi instanceof XmlAttribute && (XmlCodeFoldingBuilder.foldStyle((XmlAttribute)psi, foldingSettings) || XmlCodeFoldingBuilder.foldSrc((XmlAttribute)psi, foldingSettings)) || XmlCodeFoldingBuilder.isEntity(psi) && foldingSettings.isCollapseEntities() && XmlCodeFoldingBuilder.hasEntityPlaceholder(psi);
    }

    public boolean isRegionCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor) {
        PsiElement psi;
        FoldingBuilder foldingBuilder;
        if (foldingDescriptor == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(7);
        }
        if ((foldingBuilder = LanguageFolding.INSTANCE.forLanguage((psi = foldingDescriptor.getElement().getPsi()).getLanguage())) == this || foldingBuilder instanceof CompositeFoldingBuilder) {
            return this.isPsiElementCollapsedByDefault(psi);
        }
        return foldingBuilder.isCollapsedByDefault(foldingDescriptor);
    }

    private static boolean hasEntityPlaceholder(PsiElement psi) {
        try {
            return XmlCodeFoldingBuilder.getEntityPlaceholder(psi) != null;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    private static boolean foldSrc(XmlAttribute psi, XmlCodeFoldingSettings settings2) {
        return settings2.isCollapseDataUri() && "src".equals(psi.getName());
    }

    private static boolean foldStyle(XmlAttribute psi, XmlCodeFoldingSettings settings2) {
        return settings2.isCollapseHtmlStyleAttribute() && "style".equalsIgnoreCase(psi.getName());
    }

    private static boolean isEntity(PsiElement psi) {
        return psi instanceof XmlEntityRef || psi instanceof XmlTokenImpl && ((XmlTokenImpl)psi).getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF;
    }

    private static boolean isAttributeShouldBeFolded(XmlAttribute child2) {
        return HtmlUtil.isHtmlFile((PsiElement)child2.getContainingFile()) && ("style".equalsIgnoreCase(child2.getName()) || "src".equals(child2.getName()) && child2.getValue() != null && URLUtil.isDataUri((String)child2.getValue()));
    }

    protected abstract XmlCodeFoldingSettings getFoldingSettings();

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node2) {
        if (node2 == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(8);
        }
        return node2.getElementType() == XmlElementType.XML_TAG;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node2) {
        if (node2 == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(9);
        }
        return node2.getElementType() == XmlTokenType.XML_COMMENT_CHARACTERS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/XmlCodeFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEntityPlaceholder";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

