/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search.searchTask;

import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.largeFilesEditor.search.searchTask.FrameSearcher;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskBase;
import com.intellij.largeFilesEditor.search.searchTask.SearchTaskOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CloseSearchTask
extends SearchTaskBase {
    private static final Logger logger = Logger.getInstance(CloseSearchTask.class);
    private final Callback myCallback;

    public CloseSearchTask(SearchTaskOptions options2, Project project, FileDataProviderForSearch fileDataProviderForSearch, Callback callback2) {
        super(options2, project, fileDataProviderForSearch);
        this.myCallback = callback2;
    }

    @Override
    public void doRun() {
        FrameSearcher searcher = this.createFrameSearcher(this.options, this.project);
        int tailLength = CloseSearchTask.getTailLength(this.options);
        try {
            long pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
            long curPageNumber = CloseSearchTask.getPageNumberForBeginning(pagesAmount, this.options);
            if (CloseSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                this.myCallback.tellSearchIsFinished(this, curPageNumber);
                return;
            }
            String prevPageText = curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
            String curPageText = this.fileDataProviderForSearch.getPage_wait(curPageNumber).getText();
            String nextPageText = curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
            String tailText = CloseSearchTask.getTailFromPage(nextPageText, tailLength);
            char prefixSymbol = CloseSearchTask.getPrefixSymbol(prevPageText);
            char postfixSymbol = CloseSearchTask.getPostfixSymbol(nextPageText, tailLength);
            this.myCallback.tellSearchProgress(this, curPageNumber, pagesAmount);
            searcher.setFrame(curPageNumber, prefixSymbol, curPageText, tailText, postfixSymbol);
            ArrayList<SearchResult> allMatchesAtFrame = searcher.findAllMatchesAtFrame();
            int index2 = CloseSearchTask.tryGetClosestResult(allMatchesAtFrame, this.options);
            if (index2 != -1) {
                this.myCallback.tellClosestResultFound(this, allMatchesAtFrame, index2);
                return;
            }
            do {
                pagesAmount = this.fileDataProviderForSearch.getPagesAmount();
                if (this.options.searchForwardDirection) {
                    prevPageText = curPageText;
                    curPageText = nextPageText;
                    nextPageText = ++curPageNumber < pagesAmount - 1L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber + 1L).getText() : "";
                } else {
                    nextPageText = curPageText;
                    curPageText = prevPageText;
                    String string = prevPageText = --curPageNumber > 0L ? this.fileDataProviderForSearch.getPage_wait(curPageNumber - 1L).getText() : "";
                }
                if (CloseSearchTask.isTheEndOfSearchingCycle(curPageNumber, pagesAmount, this.options)) {
                    this.myCallback.tellSearchIsFinished(this, CloseSearchTask.getPreviousPageNumber(curPageNumber, this.options));
                    return;
                }
                if (this.isShouldStop()) {
                    this.myCallback.tellSearchWasStopped(this, curPageNumber);
                    return;
                }
                tailText = CloseSearchTask.getTailFromPage(nextPageText, tailLength);
                prefixSymbol = CloseSearchTask.getPrefixSymbol(prevPageText);
                postfixSymbol = CloseSearchTask.getPostfixSymbol(nextPageText, tailLength);
                this.myCallback.tellSearchProgress(this, curPageNumber, pagesAmount);
                searcher.setFrame(curPageNumber, prefixSymbol, curPageText, tailText, postfixSymbol);
            } while ((allMatchesAtFrame = searcher.findAllMatchesAtFrame()).size() <= 0);
            this.myCallback.tellClosestResultFound(this, allMatchesAtFrame, this.options.searchForwardDirection ? 0 : allMatchesAtFrame.size() - 1);
            return;
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            this.myCallback.tellSearchWasCatchedException(this, e);
            return;
        }
    }

    private static int tryGetClosestResult(ArrayList<SearchResult> allMatchesAtFrame, SearchTaskOptions options2) {
        block6: {
            if (allMatchesAtFrame.isEmpty()) break block6;
            if (options2.searchForwardDirection) {
                if (options2.leftBoundPageNumber == -1L) {
                    return 0;
                }
                for (int i2 = 0; i2 < allMatchesAtFrame.size(); ++i2) {
                    SearchResult searchResult = allMatchesAtFrame.get(i2);
                    if (searchResult.startPosition.pageNumber <= options2.leftBoundPageNumber && (searchResult.startPosition.pageNumber != options2.leftBoundPageNumber || searchResult.startPosition.symbolOffsetInPage < options2.leftBoundCaretPageOffset)) continue;
                    return i2;
                }
            } else {
                if (options2.rightBoundPageNumber == -1L) {
                    return allMatchesAtFrame.size() - 1;
                }
                for (int i3 = allMatchesAtFrame.size() - 1; i3 >= 0; --i3) {
                    SearchResult searchResult = allMatchesAtFrame.get(i3);
                    if (searchResult.endPostion.pageNumber >= options2.rightBoundPageNumber && (searchResult.endPostion.pageNumber != options2.rightBoundPageNumber || searchResult.endPostion.symbolOffsetInPage >= options2.rightBoundCaretPageOffset)) continue;
                    return i3;
                }
            }
        }
        return -1;
    }

    public static interface Callback {
        public void tellSearchIsFinished(CloseSearchTask var1, long var2);

        public void tellSearchProgress(CloseSearchTask var1, long var2, long var4);

        public void tellSearchWasStopped(CloseSearchTask var1, long var2);

        public void tellSearchWasCatchedException(CloseSearchTask var1, IOException var2);

        public void tellClosestResultFound(CloseSearchTask var1, List<? extends SearchResult> var2, int var3);
    }
}

