/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance(NotificationsUtil.class);
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;
    @NlsSafe
    private static final String P_TAG = "<p/>";
    @NlsSafe
    private static final String BR_TAG = "<br>";

    @NotNull
    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(0);
        }
        String title2 = notification.getTitle();
        String content2 = notification.getContent();
        if (title2.length() > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title2 + "\nContent=" + content2);
            title2 = StringUtil.trimLog((String)title2, (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        return NotificationsUtil.buildHtml(title2, null, content2, style, "#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()), null, null);
    }

    @NotNull
    @Nls
    public static String buildHtml(@NotNull Notification notification, @Nullable String style, boolean isContent, @Nullable Color color, @Nullable String contentStyle) {
        String content2;
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(1);
        }
        String title2 = !isContent ? notification.getTitle() : "";
        String subtitle = !isContent ? notification.getSubtitle() : null;
        String string = content2 = isContent ? notification.getContent() : "";
        if (title2.length() > 1000 || StringUtil.length((CharSequence)subtitle) > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title2 + "\nSubtitle=" + subtitle + "\nContent=" + content2);
            title2 = StringUtil.trimLog((String)title2, (int)1000);
            subtitle = StringUtil.trimLog((String)StringUtil.notNullize((String)subtitle), (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        if (isContent) {
            content2 = StringUtil.replace((String)content2, (String)P_TAG, (String)BR_TAG);
        }
        String colorText = color == null ? null : "#" + ColorUtil.toHex((Color)color);
        return NotificationsUtil.buildHtml(title2, subtitle, content2, style, isContent ? null : colorText, (String)((Object)(isContent ? colorText : null)), contentStyle);
    }

    @NotNull
    @Nls
    public static String buildHtml(@Nullable @Nls String title2, @Nullable @Nls String subtitle, @Nullable @Nls String content2, @Nullable String style, @Nullable String titleColor, @Nullable String contentColor, @Nullable String contentStyle) {
        if (Notification.isEmpty((String)title2) && !Notification.isEmpty((String)subtitle)) {
            title2 = subtitle;
            subtitle = null;
        } else if (!Notification.isEmpty((String)title2) && !Notification.isEmpty((String)subtitle)) {
            title2 = (String)title2 + ":";
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        if (!Notification.isEmpty((String)title2)) {
            HtmlChunk.Element titleChunk = HtmlChunk.raw((String)title2).bold();
            if (StringUtil.isNotEmpty((String)titleColor)) {
                titleChunk = titleChunk.attr("color", titleColor);
            }
            htmlBuilder.append((HtmlChunk)titleChunk);
        }
        if (!Notification.isEmpty((String)subtitle)) {
            htmlBuilder.nbsp().append((HtmlChunk)(StringUtil.isNotEmpty((String)titleColor) ? HtmlChunk.span().attr("color", titleColor).addText(subtitle) : HtmlChunk.raw((String)subtitle)));
        }
        if (!Notification.isEmpty((String)content2)) {
            HtmlChunk.Element contentChunk = HtmlChunk.raw((String)content2).wrapWith(HtmlChunk.div());
            if (StringUtil.isNotEmpty((String)contentStyle)) {
                contentChunk = contentChunk.style(contentStyle);
            }
            if (StringUtil.isNotEmpty((String)contentColor)) {
                contentChunk = contentChunk.attr("color", contentColor);
            }
            htmlBuilder.append((HtmlChunk)contentChunk);
        }
        String string = StringUtil.isNotEmpty((String)style) ? htmlBuilder.wrapWith(HtmlChunk.div((String)style)).wrapWith(HtmlChunk.html()).toString() : htmlBuilder.wrapWithHtmlBody().toString();
        if (string == null) {
            NotificationsUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String getFontStyle() {
        String fontName = NotificationsUtil.getFontName();
        return StringUtil.isEmpty((String)fontName) ? null : "font-family:" + fontName + ";";
    }

    @Nullable
    public static Integer getFontSize() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return uiSettings.getFontSize();
        }
        Font font = UIUtil.getLabelFont();
        return font == null ? null : Integer.valueOf(font.getSize());
    }

    @Nullable
    public static String getFontName() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return uiSettings.getFontFace();
        }
        Font font = UIUtil.getLabelFont();
        return font == null ? null : font.getName();
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        NotificationListener listener2;
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(3);
        }
        if ((listener2 = notification.getListener()) == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    NotificationCollector.getInstance().logHyperlinkClicked(notification);
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    @NotNull
    public static Icon getIcon(@NotNull Notification notification) {
        Icon icon2;
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(4);
        }
        if ((icon2 = notification.getIcon()) != null) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                NotificationsUtil.$$$reportNull$$$0(5);
            }
            return icon3;
        }
        switch (notification.getType()) {
            case WARNING: {
                Icon icon4 = AllIcons.General.BalloonWarning;
                if (icon4 == null) {
                    NotificationsUtil.$$$reportNull$$$0(6);
                }
                return icon4;
            }
            case ERROR: {
                Icon icon5 = AllIcons.General.BalloonError;
                if (icon5 == null) {
                    NotificationsUtil.$$$reportNull$$$0(7);
                }
                return icon5;
            }
        }
        Icon icon6 = AllIcons.General.BalloonInformation;
        if (icon6 == null) {
            NotificationsUtil.$$$reportNull$$$0(8);
        }
        return icon6;
    }

    @NotNull
    public static MessageType getMessageType(@NotNull Notification notification) {
        if (notification == null) {
            NotificationsUtil.$$$reportNull$$$0(9);
        }
        switch (notification.getType()) {
            case WARNING: {
                MessageType messageType = MessageType.WARNING;
                if (messageType == null) {
                    NotificationsUtil.$$$reportNull$$$0(10);
                }
                return messageType;
            }
            case ERROR: {
                MessageType messageType = MessageType.ERROR;
                if (messageType == null) {
                    NotificationsUtil.$$$reportNull$$$0(11);
                }
                return messageType;
            }
        }
        MessageType messageType = MessageType.INFO;
        if (messageType == null) {
            NotificationsUtil.$$$reportNull$$$0(12);
        }
        return messageType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/ui/NotificationsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/ui/NotificationsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtml";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildHtml";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMessageType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

