/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.InvokeQuickListAction;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManagerKt;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.BundledQuickListsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "", "()V", "allQuickLists", "", "Lcom/intellij/openapi/actionSystem/ex/QuickList;", "getAllQuickLists", "()[Lcom/intellij/openapi/actionSystem/ex/QuickList;", "schemeManager", "Lcom/intellij/openapi/options/SchemeManager;", "getSchemeManager", "()Lcom/intellij/openapi/options/SchemeManager;", "registerActions", "", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "setQuickLists", "quickLists", "", "Companion", "QuickListActionCustomizer", "intellij.platform.ide.impl"})
public final class QuickListsManager {
    @NotNull
    private final SchemeManager<QuickList> schemeManager = SchemeManagerFactory.create$default(SchemeManagerFactory.Companion.getInstance(), "quicklists", new LazySchemeProcessor<QuickList, QuickList>("display"){

        @NotNull
        public QuickList createScheme(@NotNull SchemeDataHolder<? super QuickList> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider2, boolean isBundled) {
            Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(attributeProvider2, (String)"attributeProvider");
            QuickList item = new QuickList();
            item.readExternal(dataHolder.read());
            dataHolder.updateDigest(item);
            return item;
        }
    }, IdeBundle.message((String)"quick.lists.presentable.name", (Object[])new Object[0]), null, 8, null);
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SchemeManager<QuickList> getSchemeManager() {
        return this.schemeManager;
    }

    @NotNull
    public final QuickList[] getAllQuickLists() {
        Collection $this$toTypedArray$iv = this.schemeManager.getAllSchemes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        QuickList[] quickListArray = thisCollection$iv.toArray(new QuickList[0]);
        if (quickListArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return quickListArray;
    }

    private final void registerActions(ActionManager actionManager) {
        HashSet<String> registeredIds = new HashSet<String>();
        for (QuickList scheme2 : this.schemeManager.getAllSchemes()) {
            String actionId;
            Intrinsics.checkNotNullExpressionValue((Object)scheme2.getActionId(), (String)"scheme.actionId");
            if (!registeredIds.add(actionId)) continue;
            actionManager.registerAction(actionId, (AnAction)new InvokeQuickListAction(scheme2));
        }
    }

    public final void setQuickLists(@NotNull List<? extends QuickList> quickLists) {
        Intrinsics.checkNotNullParameter(quickLists, (String)"quickLists");
        ActionManager actionManager = ActionManager.getInstance();
        for (String oldId : actionManager.getActionIdList("QuickList.")) {
            actionManager.unregisterAction(oldId);
        }
        SchemeManager.setSchemes$default(this.schemeManager, quickLists, null, null, 6, null);
        ActionManager actionManager2 = actionManager;
        Intrinsics.checkNotNullExpressionValue((Object)actionManager2, (String)"actionManager");
        this.registerActions(actionManager2);
    }

    public QuickListsManager() {
        QuickListsManagerKt.access$getEP_NAME$p().processWithPluginDescriptor(new BiConsumer(){

            public final void accept(BundledQuickListsProvider provider2, PluginDescriptor pluginDescriptor) {
                BundledQuickListsProvider bundledQuickListsProvider = provider2;
                Intrinsics.checkNotNullExpressionValue((Object)bundledQuickListsProvider, (String)"provider");
                for (String path2 : bundledQuickListsProvider.getBundledListsRelativePaths()) {
                    SchemeManager<QuickList> schemeManager2 = this.getSchemeManager();
                    String string = path2;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                    String string2 = StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null) ? path2 : path2 + ".xml";
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (path.endsWith(\".xml\")) path else \"$path.xml\"");
                    schemeManager2.loadBundledScheme(string2, null, pluginDescriptor);
                }
            }
        });
        this.schemeManager.loadSchemes();
    }

    @JvmStatic
    @NotNull
    public static final QuickListsManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager$QuickListActionCustomizer;", "Lcom/intellij/openapi/actionSystem/impl/ActionConfigurationCustomizer;", "()V", "customize", "", "manager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "intellij.platform.ide.impl"})
    public static final class QuickListActionCustomizer
    implements ActionConfigurationCustomizer {
        @Override
        public void customize(@NotNull ActionManager manager2) {
            Intrinsics.checkNotNullParameter((Object)manager2, (String)"manager");
            Companion.getInstance().registerActions(manager2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/actionSystem/ex/QuickListsManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/actionSystem/ex/QuickListsManager;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final QuickListsManager getInstance() {
            boolean $i$f$service = false;
            Class<QuickListsManager> serviceClass$iv = QuickListsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (QuickListsManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

