/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AlwaysPerformingActionGroup;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionUpdateEdtExecutor;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EDT;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;

final class ActionUpdater {
    private static final Logger LOG = Logger.getInstance(ActionUpdater.class);
    static final Executor ourBeforePerformedExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Action Updater (Exclusive)", (int)1);
    private static final Executor ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Action Updater (Common)", (int)2);
    private static final List<CancellablePromise<?>> ourPromises = new CopyOnWriteArrayList();
    private final boolean myModalContext;
    private final PresentationFactory myPresentationFactory;
    private final DataContext myDataContext;
    private final String myPlace;
    private final boolean myContextMenuAction;
    private final boolean myToolbarAction;
    @Nullable
    private final Project myProject;
    private final Map<AnAction, Presentation> myUpdatedPresentations;
    private final Map<ActionGroup, List<AnAction>> myGroupChildren;
    private final Map<ActionGroup, Boolean> myCanBePerformedCache;
    private final UpdateStrategy myRealUpdateStrategy;
    private final UpdateStrategy myCheapStrategy;
    private boolean myAllowPartialExpand;
    private boolean myPreCacheSlowDataKeys;
    private boolean myForceAsync;
    private final Function<AnActionEvent, AnActionEvent> myEventTransform;
    private final Consumer<Runnable> myLaterInvocator;
    private final int myTestDelayMillis;
    private static final ConcurrentMap<AsyncPromise<?>, String> ourDebugPromisesMap = CollectionFactory.createConcurrentWeakIdentityMap();

    ActionUpdater(boolean isInModalContext, @NotNull PresentationFactory presentationFactory, @NotNull DataContext dataContext, @NotNull String place, boolean isContextMenuAction, boolean isToolbarAction) {
        if (presentationFactory == null) {
            ActionUpdater.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            ActionUpdater.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ActionUpdater.$$$reportNull$$$0(2);
        }
        this(isInModalContext, presentationFactory, dataContext, place, isContextMenuAction, isToolbarAction, null, null);
    }

    ActionUpdater(boolean isInModalContext, @NotNull PresentationFactory presentationFactory, @NotNull DataContext dataContext, @NotNull String place, boolean isContextMenuAction, boolean isToolbarAction, @Nullable Function<AnActionEvent, AnActionEvent> eventTransform, @Nullable Consumer<Runnable> laterInvocator) {
        if (presentationFactory == null) {
            ActionUpdater.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ActionUpdater.$$$reportNull$$$0(4);
        }
        if (place == null) {
            ActionUpdater.$$$reportNull$$$0(5);
        }
        this.myUpdatedPresentations = new ConcurrentHashMap<AnAction, Presentation>();
        this.myGroupChildren = new ConcurrentHashMap<ActionGroup, List<AnAction>>();
        this.myCanBePerformedCache = new ConcurrentHashMap<ActionGroup, Boolean>();
        this.myAllowPartialExpand = true;
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        this.myModalContext = isInModalContext;
        this.myPresentationFactory = presentationFactory;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myContextMenuAction = isContextMenuAction;
        this.myToolbarAction = isToolbarAction;
        this.myEventTransform = eventTransform;
        this.myLaterInvocator = laterInvocator;
        this.myPreCacheSlowDataKeys = Utils.isAsyncDataContext(dataContext);
        this.myForceAsync = Registry.is((String)"actionSystem.update.actions.async.unsafe");
        Op updateOp = this.myEventTransform == null || Registry.is((String)"actionSystem.update.actions.call.beforeActionPerformedUpdate.once") ? Op.update : Op.beforeActionPerformedUpdate;
        this.myRealUpdateStrategy = new UpdateStrategy((NullableFunction<? super AnAction, Presentation>)((NullableFunction)action2 -> this.updateActionReal((AnAction)action2, updateOp)), (NotNullFunction<? super ActionGroup, ? extends AnAction[]>)((NotNullFunction)group2 -> this.callAction((AnAction)group2, Op.getChildren, () -> ActionUpdater.doGetChildren(group2, this.createActionEvent((AnAction)group2, this.orDefault((AnAction)group2, this.myUpdatedPresentations.get(group2)))))), group2 -> this.callAction((AnAction)group2, Op.canBePerformed, () -> ActionUpdater.doCanBePerformed(group2, this.myDataContext)));
        this.myCheapStrategy = new UpdateStrategy((NullableFunction<? super AnAction, Presentation>)((NullableFunction)this.myPresentationFactory::getPresentation), (NotNullFunction<? super ActionGroup, ? extends AnAction[]>)((NotNullFunction)group2 -> ActionUpdater.doGetChildren(group2, null)), group2 -> true);
        LOG.assertTrue(updateOp != Op.beforeActionPerformedUpdate || ActionPlaces.isShortcutPlace((String)this.myPlace), (Object)("beforeActionPerformed requested in '" + this.myPlace + "'"));
        this.myTestDelayMillis = "GoToAction".equals(this.myPlace) || ActionPlaces.isShortcutPlace((String)this.myPlace) ? 0 : Registry.intValue((String)"actionSystem.update.actions.async.test.delay", (int)0);
    }

    @Nullable
    private Presentation updateActionReal(@NotNull AnAction action2, @NotNull Op operation2) {
        Supplier<Boolean> doUpdate2;
        boolean success2;
        boolean isBeforePerformed;
        if (action2 == null) {
            ActionUpdater.$$$reportNull$$$0(6);
        }
        if (operation2 == null) {
            ActionUpdater.$$$reportNull$$$0(7);
        }
        if (this.myPreCacheSlowDataKeys) {
            ReadAction.run(this::ensureSlowDataKeysPreCached);
        }
        Presentation presentation2 = this.myPresentationFactory.getPresentation(action2).clone();
        boolean bl = isBeforePerformed = operation2 == Op.beforeActionPerformedUpdate;
        if (!ActionPlaces.isShortcutPlace((String)this.myPlace)) {
            presentation2.setEnabledAndVisible(true);
        }
        return (success2 = this.callAction(action2, operation2, doUpdate2 = () -> ActionUpdater.doUpdate(this.myModalContext, action2, this.createActionEvent(action2, presentation2), isBeforePerformed)).booleanValue()) ? presentation2 : null;
    }

    void applyPresentationChanges() {
        for (Map.Entry<AnAction, Presentation> entry2 : this.myUpdatedPresentations.entrySet()) {
            AnAction action2 = entry2.getKey();
            Presentation orig = this.myPresentationFactory.getPresentation(action2);
            Presentation copy2 = entry2.getValue();
            if (action2 instanceof CustomComponentAction) {
                JComponent copyC = (JComponent)copy2.getClientProperty(CustomComponentAction.COMPONENT_KEY);
                JComponent origC = (JComponent)orig.getClientProperty(CustomComponentAction.COMPONENT_KEY);
                if (copyC == null && origC != null) {
                    copy2.putClientProperty(CustomComponentAction.COMPONENT_KEY, (Object)origC);
                }
            }
            orig.copyFrom(copy2);
            ActionUpdater.reflectSubsequentChangesInOriginalPresentation(orig, copy2);
        }
    }

    private static void reflectSubsequentChangesInOriginalPresentation(@NotNull Presentation original, @NotNull Presentation cloned) {
        if (original == null) {
            ActionUpdater.$$$reportNull$$$0(8);
        }
        if (cloned == null) {
            ActionUpdater.$$$reportNull$$$0(9);
        }
        cloned.addPropertyChangeListener(e -> {
            if (EDT.isCurrentThreadEdt()) {
                original.copyFrom(cloned);
            }
        });
    }

    private <T> T callAction(@NotNull AnAction action2, @NotNull Op operation2, @NotNull Supplier<? extends T> call) {
        if (action2 == null) {
            ActionUpdater.$$$reportNull$$$0(10);
        }
        if (operation2 == null) {
            ActionUpdater.$$$reportNull$$$0(11);
        }
        if (call == null) {
            ActionUpdater.$$$reportNull$$$0(12);
        }
        boolean canAsync = Utils.isAsyncDataContext(this.myDataContext) && operation2 != Op.beforeActionPerformedUpdate;
        boolean shallAsync = this.myForceAsync || canAsync && UpdateInBackground.isUpdateInBackground((AnAction)action2);
        boolean isEDT = EDT.isCurrentThreadEdt();
        if (isEDT && canAsync && shallAsync && !SlowOperations.isInsideActivity((String)"action.perform")) {
            LOG.error("Calling " + operation2 + " on EDT on `" + action2.getClass().getName() + "` " + (this.myForceAsync ? "(forceAsync=true)" : "(isUpdateInBackground=true)"));
        }
        if (isEDT || canAsync && shallAsync) {
            try (AccessToken ignored = ProhibitAWTEvents.start(operation2.name());){
                T t = call.get();
                return t;
            }
        }
        ProgressIndicator progress2 = Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator());
        return (T)this.computeOnEdt(() -> {
            long start2 = System.nanoTime();
            try {
                Object object = ProgressManager.getInstance().runProcess(() -> ActionUpdater.lambda$callAction$9(operation2, (Supplier)call), (ProgressIndicator)ProgressWrapper.wrap(progress2));
                return object;
            }
            finally {
                long elapsed = TimeoutUtil.getDurationMillis((long)start2);
                if (elapsed > 100L) {
                    LOG.warn("Slow (" + elapsed + " ms) '" + operation2 + "' on action " + action2 + " of " + action2.getClass() + ". Consider speeding it up and/or implementing UpdateInBackground.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AnAction> expandActionGroup(ActionGroup group2, boolean hideDisabled) {
        try {
            List<AnAction> list2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
            return list2;
        }
        finally {
            this.applyPresentationChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AnAction> expandActionGroupFull(ActionGroup group2, boolean hideDisabled) {
        try {
            this.myAllowPartialExpand = false;
            List<AnAction> list2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
            return list2;
        }
        finally {
            this.myAllowPartialExpand = true;
            this.applyPresentationChanges();
        }
    }

    private List<AnAction> expandActionGroup(ActionGroup group2, boolean hideDisabled, UpdateStrategy strategy) {
        return ActionUpdater.removeUnnecessarySeparators(this.doExpandActionGroup(group2, hideDisabled, strategy));
    }

    @NotNull
    List<AnAction> expandActionGroupWithTimeout(ActionGroup group2, boolean hideDisabled) {
        List<AnAction> list2 = this.expandActionGroupWithTimeout(group2, hideDisabled, Registry.intValue((String)"actionSystem.update.timeout.ms"));
        if (list2 == null) {
            ActionUpdater.$$$reportNull$$$0(13);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<AnAction> expandActionGroupWithTimeout(ActionGroup group2, boolean hideDisabled, int timeoutMs) {
        List<AnAction> result2 = (List<AnAction>)ProgressIndicatorUtils.withTimeout(timeoutMs, () -> this.expandActionGroup(group2, hideDisabled));
        List<AnAction> list2 = result2 != null ? result2 : this.expandActionGroup(group2, hideDisabled, this.myCheapStrategy);
        List<AnAction> list3 = list2;
        if (list3 == null) {
            ActionUpdater.$$$reportNull$$$0(14);
        }
        return list3;
        finally {
            this.applyPresentationChanges();
        }
    }

    @NotNull
    CancellablePromise<List<AnAction>> expandActionGroupAsync(ActionGroup group2, boolean hideDisabled) {
        Application disposableParent = this.myProject != null ? this.myProject : ApplicationManager.getApplication();
        AsyncPromise promise = ActionUpdater.newPromise(this.myPlace);
        EmptyProgressIndicator indicator2 = new EmptyProgressIndicator();
        promise.onError(arg_0 -> this.lambda$expandActionGroupAsync$12((ProgressIndicator)indicator2, (ComponentManager)disposableParent, arg_0));
        if (this.myLaterInvocator != null && SlowOperations.isInsideActivity((String)"  fast track  ")) {
            ActionUpdater.cancelAllUpdates("fast-track requested by '" + this.myPlace + "'");
        }
        if (this.myToolbarAction) {
            ActionUpdater.cancelOnUserActivity(promise, (Disposable)disposableParent);
        } else if (this.myContextMenuAction) {
            ActionUpdater.cancelAllUpdates("context menu requested");
        }
        Runnable runnable2 = () -> this.lambda$expandActionGroupAsync$14((ProgressIndicator)indicator2, group2, hideDisabled, promise);
        ourPromises.add((CancellablePromise<?>)promise);
        ClientId clientId = ClientId.getCurrent();
        ourExecutor.execute(() -> this.lambda$expandActionGroupAsync$19(clientId, (ComponentManager)disposableParent, promise, runnable2, (ProgressIndicator)indicator2));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ActionUpdater.$$$reportNull$$$0(15);
        }
        return asyncPromise;
    }

    static void cancelAllUpdates(@NotNull String reason) {
        if (reason == null) {
            ActionUpdater.$$$reportNull$$$0(16);
        }
        if (ourPromises.isEmpty()) {
            return;
        }
        CancellablePromise[] copy2 = ourPromises.toArray(new CancellablePromise[0]);
        ourPromises.clear();
        for (CancellablePromise promise : copy2) {
            ActionUpdater.cancelPromise(promise, reason + " (cancelling all updates)");
        }
    }

    private void waitTheTestDelay() {
        if (this.myTestDelayMillis <= 0) {
            return;
        }
        ProgressIndicator progress2 = Objects.requireNonNull(ProgressIndicatorProvider.getGlobalProgressIndicator());
        long start2 = System.currentTimeMillis();
        while (true) {
            progress2.checkCanceled();
            if (System.currentTimeMillis() - start2 > (long)this.myTestDelayMillis) break;
            TimeoutUtil.sleep((long)1L);
        }
    }

    private void ensureSlowDataKeysPreCached() {
        if (!this.myPreCacheSlowDataKeys) {
            return;
        }
        long start2 = System.currentTimeMillis();
        for (DataKey<?> key : DataKey.allKeys()) {
            this.myDataContext.getData(key);
        }
        this.myPreCacheSlowDataKeys = false;
        long time = System.currentTimeMillis() - start2;
        if (time > 500L) {
            LOG.debug("ensureAsyncDataKeysPreCached() took: " + time + " ms");
        }
    }

    private static void cancelOnUserActivity(@NotNull CancellablePromise<?> promise, @NotNull Disposable disposableParent) {
        if (promise == null) {
            ActionUpdater.$$$reportNull$$$0(17);
        }
        if (disposableParent == null) {
            ActionUpdater.$$$reportNull$$$0(18);
        }
        Disposable disposable2 = Disposer.newDisposable((String)"Action Update");
        Disposer.register((Disposable)disposableParent, (Disposable)disposable2);
        IdeEventQueue.getInstance().addPostprocessor(event -> {
            if (event instanceof KeyEvent && event.getID() == 401 || event instanceof MouseEvent && event.getID() == 501) {
                ActionUpdater.cancelPromise(promise, event);
            }
            return false;
        }, disposable2);
        promise.onProcessed(__ -> Disposer.dispose((Disposable)disposable2));
    }

    private List<AnAction> doExpandActionGroup(ActionGroup group2, boolean hideDisabled, UpdateStrategy strategy) {
        if (group2 instanceof ActionGroupStub) {
            throw new IllegalStateException("Trying to expand non-unstubbed group");
        }
        if (this.myAllowPartialExpand) {
            ProgressManager.checkCanceled();
        }
        boolean prevForceAsync = this.myForceAsync;
        this.myForceAsync |= group2 instanceof UpdateInBackground.Recursive;
        Presentation presentation2 = this.update((AnAction)group2, strategy);
        if (presentation2 == null || !presentation2.isVisible()) {
            return Collections.emptyList();
        }
        List<AnAction> children2 = this.getGroupChildren(group2, strategy);
        List result2 = ContainerUtil.concat(children2, child2 -> (Collection)TimeoutUtil.compute(() -> this.expandGroupChild((AnAction)child2, hideDisabled, strategy), (long)1000L, ms -> LOG.warn(ms + " ms to expand group child " + ActionManager.getInstance().getId(child2))));
        this.myForceAsync = prevForceAsync;
        return group2.postProcessVisibleChildren(result2, this.asUpdateSession(strategy));
    }

    private List<AnAction> getGroupChildren(ActionGroup group2, UpdateStrategy strategy) {
        return this.myGroupChildren.computeIfAbsent(group2, __ -> {
            Object[] children2 = (AnAction[])TimeoutUtil.compute(() -> (AnAction[])strategy.getChildren.fun((Object)group2), (long)1000L, ms -> LOG.warn(ms + " ms to expand group child " + ActionManager.getInstance().getId((AnAction)group2)));
            int nullIndex = ArrayUtil.indexOf((Object[])children2, null);
            if (nullIndex < 0) {
                return Arrays.asList(children2);
            }
            LOG.error("action is null: i=" + nullIndex + " group=" + group2 + " group id=" + ActionManager.getInstance().getId((AnAction)group2));
            return ContainerUtil.filter((Object[])children2, (Condition)Conditions.notNull());
        });
    }

    private List<AnAction> expandGroupChild(AnAction child2, boolean hideDisabled, UpdateStrategy strategy) {
        Presentation presentation2 = this.update(child2, strategy);
        if (presentation2 == null) {
            return Collections.emptyList();
        }
        if (!presentation2.isVisible() || !presentation2.isEnabled() && hideDisabled) {
            return Collections.emptyList();
        }
        if (child2 instanceof ActionGroup) {
            ActionGroup actionGroup2 = (ActionGroup)child2;
            boolean isPopup = actionGroup2.isPopup(this.myPlace);
            boolean hasEnabled = false;
            boolean hasVisible = false;
            if (child2 instanceof AlwaysVisibleActionGroup) {
                hasVisible = true;
                hasEnabled = true;
            } else if (hideDisabled || isPopup) {
                Presentation p;
                AnAction action2;
                JBIterable<AnAction> childrenIterable = this.iterateGroupChildren(actionGroup2, strategy);
                Iterator iterator2 = childrenIterable.take(100).iterator();
                while (!(!iterator2.hasNext() || !((action2 = (AnAction)iterator2.next()) instanceof Separator) && (p = this.update(action2, strategy)) != null && ((hasEnabled |= p.isEnabled()) && hasVisible || hideDisabled && hasEnabled && !isPopup || isPopup && (hasVisible |= p.isVisible()) && !hideDisabled))) {
                }
            }
            if (hideDisabled && !hasEnabled) {
                return Collections.emptyList();
            }
            if (isPopup) {
                boolean canBePerformed = this.canBePerformed(actionGroup2, strategy);
                boolean performOnly = canBePerformed && (actionGroup2 instanceof AlwaysPerformingActionGroup || !hasVisible);
                presentation2.putClientProperty("actionGroup.perform.only", (Object)(performOnly ? Boolean.valueOf(true) : null));
                if (!hasVisible && actionGroup2.disableIfNoVisibleChildren()) {
                    if (actionGroup2.hideIfNoVisibleChildren()) {
                        return Collections.emptyList();
                    }
                    if (!canBePerformed) {
                        presentation2.setEnabled(false);
                    }
                }
                if (hideDisabled && !(child2 instanceof CompactActionGroup)) {
                    return Collections.singletonList(new EmptyAction.DelegatingCompactActionGroup((ActionGroup)child2));
                }
                return Collections.singletonList(child2);
            }
            return this.doExpandActionGroup((ActionGroup)child2, hideDisabled || actionGroup2 instanceof CompactActionGroup, strategy);
        }
        return Collections.singletonList(child2);
    }

    private boolean canBePerformed(ActionGroup group2, UpdateStrategy strategy) {
        return this.myCanBePerformedCache.computeIfAbsent(group2, __ -> strategy.canBePerformed.test((ActionGroup)group2));
    }

    private Presentation orDefault(AnAction action2, Presentation presentation2) {
        return presentation2 != null ? presentation2 : this.myPresentationFactory.getPresentation(action2).clone();
    }

    @NotNull
    static List<AnAction> removeUnnecessarySeparators(@NotNull List<? extends AnAction> visible) {
        if (visible == null) {
            ActionUpdater.$$$reportNull$$$0(19);
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        for (AnAction anAction2 : visible) {
            if (anAction2 instanceof Separator && (result2.isEmpty() || ContainerUtil.getLastItem(result2) instanceof Separator) && StringUtil.isEmpty((String)((Separator)anAction2).getText())) continue;
            result2.add(anAction2);
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            ActionUpdater.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private AnActionEvent createActionEvent(AnAction action2, Presentation presentation2) {
        AnActionEvent event = new AnActionEvent(null, this.myDataContext, this.myPlace, presentation2, ActionManager.getInstance(), 0, this.myContextMenuAction, this.myToolbarAction);
        if (this.myEventTransform != null) {
            event = this.myEventTransform.apply(event);
        }
        event.setUpdateSession(this.asUpdateSession());
        return event;
    }

    private <T> T computeOnEdt(@NotNull Supplier<? extends T> supplier2) {
        if (supplier2 == null) {
            ActionUpdater.$$$reportNull$$$0(21);
        }
        return ActionUpdateEdtExecutor.computeOnEdt(supplier2, this.myLaterInvocator);
    }

    @NotNull
    UpdateSession asUpdateSession() {
        return this.asUpdateSession(this.myRealUpdateStrategy);
    }

    @NotNull
    UpdateSession asFastUpdateSession(@Nullable Consumer<? super String> missedKeys, @Nullable Consumer<Runnable> laterInvocator) {
        DataContext frozenContext = Utils.freezeDataContext(this.myDataContext, missedKeys);
        ActionUpdater updater = new ActionUpdater(this.myModalContext, this.myPresentationFactory, frozenContext, this.myPlace, this.myContextMenuAction, this.myToolbarAction, this.myEventTransform, Objects.requireNonNull((Consumer)ObjectUtils.coalesce(laterInvocator, this.myLaterInvocator)));
        updater.myPreCacheSlowDataKeys = false;
        UpdateSession updateSession = updater.asUpdateSession();
        if (updateSession == null) {
            ActionUpdater.$$$reportNull$$$0(22);
        }
        return updateSession;
    }

    @NotNull
    private UpdateSession asUpdateSession(UpdateStrategy strategy) {
        return new UpdateSessionImpl(this, strategy);
    }

    @NotNull
    private JBIterable<AnAction> iterateGroupChildren(@NotNull ActionGroup group2, @NotNull UpdateStrategy strategy) {
        if (group2 == null) {
            ActionUpdater.$$$reportNull$$$0(23);
        }
        if (strategy == null) {
            ActionUpdater.$$$reportNull$$$0(24);
        }
        boolean isDumb = this.myProject != null && DumbService.getInstance((Project)this.myProject).isDumb();
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(o -> {
            if (o == group2) {
                return null;
            }
            if (isDumb && !o.isDumbAware()) {
                return null;
            }
            if (!(o instanceof ActionGroup)) {
                return null;
            }
            ActionGroup oo = (ActionGroup)o;
            Presentation presentation2 = this.update((AnAction)oo, strategy);
            if (presentation2 == null || !presentation2.isVisible()) {
                return null;
            }
            if (oo.isPopup(this.myPlace) || strategy.canBePerformed.test((ActionGroup)oo)) {
                return null;
            }
            return this.getGroupChildren(oo, strategy);
        }).withRoots(this.getGroupChildren(group2, strategy))).unique()).traverse(TreeTraversal.LEAVES_DFS).filter(o -> !isDumb || o.isDumbAware());
        if (jBIterable == null) {
            ActionUpdater.$$$reportNull$$$0(25);
        }
        return jBIterable;
    }

    private static void handleException(@NotNull Op op, @NotNull AnAction action2, @Nullable AnActionEvent event, @NotNull Throwable ex) {
        if (op == null) {
            ActionUpdater.$$$reportNull$$$0(26);
        }
        if (action2 == null) {
            ActionUpdater.$$$reportNull$$$0(27);
        }
        if (ex == null) {
            ActionUpdater.$$$reportNull$$$0(28);
        }
        if (ex instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)ex;
        }
        String id2 = ActionManager.getInstance().getId(action2);
        String text2 = event == null ? null : event.getPresentation().getText();
        String message2 = op.name() + " failed for " + (action2 instanceof ActionGroup ? "ActionGroup" : "AnAction") + "(" + action2.getClass().getName() + (String)(id2 != null ? ", id=" + id2 : "") + ")" + (String)(StringUtil.isNotEmpty((String)text2) ? " with text=" + event.getPresentation().getText() : "");
        LOG.error(message2, ex);
    }

    @Nullable
    private Presentation update(AnAction action2, UpdateStrategy strategy) {
        Presentation cached = this.myUpdatedPresentations.get(action2);
        if (cached != null) {
            return cached;
        }
        Presentation presentation2 = (Presentation)strategy.update.fun((Object)action2);
        if (presentation2 != null) {
            this.myUpdatedPresentations.put(action2, presentation2);
        }
        return presentation2;
    }

    static boolean doUpdate(boolean isInModalContext, AnAction action2, AnActionEvent e, boolean beforeActionPerformed) {
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        try {
            return !ActionUtil.performDumbAwareUpdate((boolean)isInModalContext, (AnAction)action2, (AnActionEvent)e, (boolean)beforeActionPerformed);
        }
        catch (Throwable ex) {
            ActionUpdater.handleException(beforeActionPerformed ? Op.beforeActionPerformedUpdate : Op.update, action2, e, ex);
            return false;
        }
    }

    private static AnAction @NotNull [] doGetChildren(@NotNull ActionGroup group2, @Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        if (group2 == null) {
            ActionUpdater.$$$reportNull$$$0(29);
        }
        try {
            anActionArray = group2.getChildren(e);
        }
        catch (Throwable ex) {
            ActionUpdater.handleException(Op.getChildren, (AnAction)group2, e, ex);
            if (AnAction.EMPTY_ARRAY == null) {
                ActionUpdater.$$$reportNull$$$0(31);
            }
            return AnAction.EMPTY_ARRAY;
        }
        if (anActionArray == null) {
            ActionUpdater.$$$reportNull$$$0(30);
        }
        return anActionArray;
    }

    private static boolean doCanBePerformed(@NotNull ActionGroup group2, @NotNull DataContext context2) {
        if (group2 == null) {
            ActionUpdater.$$$reportNull$$$0(32);
        }
        if (context2 == null) {
            ActionUpdater.$$$reportNull$$$0(33);
        }
        try {
            return group2.canBePerformed(context2);
        }
        catch (Throwable ex) {
            ActionUpdater.handleException(Op.canBePerformed, (AnAction)group2, null, ex);
            return true;
        }
    }

    @NotNull
    static <T> AsyncPromise<T> newPromise(@NotNull String place) {
        if (place == null) {
            ActionUpdater.$$$reportNull$$$0(34);
        }
        AsyncPromise promise = new AsyncPromise();
        if (LOG.isDebugEnabled()) {
            ourDebugPromisesMap.put(promise, place);
            promise.onProcessed(__ -> ourDebugPromisesMap.remove(promise));
        }
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ActionUpdater.$$$reportNull$$$0(35);
        }
        return asyncPromise;
    }

    static void cancelPromise(@NotNull CancellablePromise<?> promise, @NotNull Object reason) {
        if (promise == null) {
            ActionUpdater.$$$reportNull$$$0(36);
        }
        if (reason == null) {
            ActionUpdater.$$$reportNull$$$0(37);
        }
        if (LOG.isDebugEnabled()) {
            String message2;
            String place = (String)ourDebugPromisesMap.remove(promise);
            if (place == null && promise.isDone()) {
                return;
            }
            LOG.debug(message2, (message2 = "'" + place + "' update cancelled: " + reason).contains("fast-track") || message2.contains("all updates") ? null : new ProcessCanceledException());
        }
        if (promise instanceof AsyncPromise) {
            ((AsyncPromise)promise).setError((Throwable)((Object)new Utils.ProcessCanceledWithReasonException(reason)));
        } else {
            promise.cancel();
        }
    }

    @NotNull
    static ActionUpdater getActionUpdater(@NotNull UpdateSession session2) {
        if (session2 == null) {
            ActionUpdater.$$$reportNull$$$0(38);
        }
        ActionUpdater actionUpdater = ((UpdateSessionImpl)session2).updater;
        if (actionUpdater == null) {
            ActionUpdater.$$$reportNull$$$0(39);
        }
        return actionUpdater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$expandActionGroupAsync$19(ClientId clientId, ComponentManager disposableParent, AsyncPromise promise, Runnable runnable2, ProgressIndicator indicator2) {
        boolean[] success2 = new boolean[]{false};
        try {
            ClientId.withClientId((ClientId)clientId, () -> {
                ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)disposableParent, () -> {
                    success2[0] = ProgressIndicatorUtils.runActionAndCancelBeforeWrite(applicationEx, () -> ActionUpdater.cancelPromise(promise, "write-action requested"), () -> applicationEx.tryRunReadAction(runnable2));
                }, indicator2);
                if (!success2[0] && !promise.isDone()) {
                    ActionUpdater.cancelPromise(promise, "read-action unavailable");
                }
            });
        }
        catch (Throwable e) {
            if (!promise.isDone()) {
                promise.setError(e);
            }
        }
        finally {
            ourPromises.remove(promise);
            if (!promise.isDone()) {
                ActionUpdater.cancelPromise(promise, "unknown reason");
                LOG.error(new Throwable("'" + this.myPlace + "' update exited incorrectly (" + success2[0] + ")"));
            }
        }
    }

    private /* synthetic */ void lambda$expandActionGroupAsync$14(ProgressIndicator indicator2, ActionGroup group2, boolean hideDisabled, AsyncPromise promise) {
        indicator2.checkCanceled();
        this.ensureSlowDataKeysPreCached();
        if (this.myTestDelayMillis > 0) {
            this.waitTheTestDelay();
        }
        List<AnAction> result2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
        this.computeOnEdt(() -> {
            try {
                this.applyPresentationChanges();
                promise.setResult((Object)result2);
            }
            catch (Throwable e) {
                promise.setError(e);
            }
            return null;
        });
    }

    private /* synthetic */ void lambda$expandActionGroupAsync$12(ProgressIndicator indicator2, ComponentManager disposableParent, Throwable __) {
        indicator2.cancel();
        ApplicationManager.getApplication().invokeLater(this::applyPresentationChanges, ModalityState.any(), disposableParent.getDisposed());
    }

    private static /* synthetic */ Object lambda$callAction$9(Op operation2, Supplier call) {
        try (AccessToken ignored = ProhibitAWTEvents.start(operation2.name());){
            Object t = call.get();
            return t;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 35: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 35: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFactory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 5: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: 
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cloned";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionUpdater";
                break;
            }
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 23: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionUpdater";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "expandActionGroupWithTimeout";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "expandActionGroupAsync";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUnnecessarySeparators";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "asFastUpdateSession";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateGroupChildren";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newPromise";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateActionReal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reflectSubsequentChangesInOriginalPresentation";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "callAction";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 35: 
            case 39: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cancelAllUpdates";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cancelOnUserActivity";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeUnnecessarySeparators";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeOnEdt";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "iterateGroupChildren";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doGetChildren";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doCanBePerformed";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newPromise";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "cancelPromise";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getActionUpdater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 35: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdateSessionImpl
    implements UpdateSession {
        final ActionUpdater updater;
        final UpdateStrategy strategy;

        UpdateSessionImpl(ActionUpdater updater, UpdateStrategy strategy) {
            this.updater = updater;
            this.strategy = strategy;
        }

        @NotNull
        public Iterable<? extends AnAction> expandedChildren(@NotNull ActionGroup actionGroup2) {
            if (actionGroup2 == null) {
                UpdateSessionImpl.$$$reportNull$$$0(0);
            }
            JBIterable<AnAction> jBIterable = this.updater.iterateGroupChildren(actionGroup2, this.strategy);
            if (jBIterable == null) {
                UpdateSessionImpl.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @NotNull
        public List<? extends AnAction> children(@NotNull ActionGroup actionGroup2) {
            if (actionGroup2 == null) {
                UpdateSessionImpl.$$$reportNull$$$0(2);
            }
            List<AnAction> list2 = this.updater.getGroupChildren(actionGroup2, this.strategy);
            if (list2 == null) {
                UpdateSessionImpl.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public Presentation presentation(@NotNull AnAction action2) {
            if (action2 == null) {
                UpdateSessionImpl.$$$reportNull$$$0(4);
            }
            Presentation presentation2 = this.updater.orDefault(action2, this.updater.update(action2, this.strategy));
            if (presentation2 == null) {
                UpdateSessionImpl.$$$reportNull$$$0(5);
            }
            return presentation2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionUpdater$UpdateSessionImpl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionUpdater$UpdateSessionImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expandedChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "children";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "expandedChildren";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "children";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "presentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UpdateStrategy {
        final NullableFunction<? super AnAction, Presentation> update;
        final NotNullFunction<? super ActionGroup, ? extends AnAction[]> getChildren;
        final Predicate<? super ActionGroup> canBePerformed;

        UpdateStrategy(NullableFunction<? super AnAction, Presentation> update2, NotNullFunction<? super ActionGroup, ? extends AnAction[]> getChildren, Predicate<? super ActionGroup> canBePerformed) {
            this.update = update2;
            this.getChildren = getChildren;
            this.canBePerformed = canBePerformed;
        }
    }

    private static enum Op {
        update,
        beforeActionPerformedUpdate,
        getChildren,
        canBePerformed;

    }
}

