/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.constraints;

import com.intellij.openapi.application.constraints.ConstrainedExecutionScheduler;
import com.intellij.openapi.application.constraints.Expiration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;

public class ConstrainedTaskExecutor
implements Executor {
    @NotNull
    private final ConstrainedExecutionScheduler myExecutionScheduler;
    @Nullable
    private final BooleanSupplier myCancellationCondition;
    @Nullable
    private final Expiration myExpiration;

    public ConstrainedTaskExecutor(@NotNull ConstrainedExecutionScheduler executionScheduler, @Nullable BooleanSupplier cancellationCondition, @Nullable Expiration expiration) {
        if (executionScheduler == null) {
            ConstrainedTaskExecutor.$$$reportNull$$$0(0);
        }
        this.myExecutionScheduler = executionScheduler;
        this.myCancellationCondition = cancellationCondition;
        this.myExpiration = expiration;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            ConstrainedTaskExecutor.$$$reportNull$$$0(1);
        }
        BooleanSupplier condition2 = this.myExpiration == null && this.myCancellationCondition == null ? null : () -> {
            if (this.myExpiration != null && this.myExpiration.isExpired()) {
                return false;
            }
            return this.myCancellationCondition == null || !this.myCancellationCondition.getAsBoolean();
        };
        this.myExecutionScheduler.scheduleWithinConstraints(command, condition2);
    }

    public CancellablePromise<Void> submit(@NotNull Runnable task2) {
        if (task2 == null) {
            ConstrainedTaskExecutor.$$$reportNull$$$0(2);
        }
        return this.submit(() -> {
            task2.run();
            return null;
        });
    }

    public <T> CancellablePromise<T> submit(@NotNull Callable<? extends T> task2) {
        if (task2 == null) {
            ConstrainedTaskExecutor.$$$reportNull$$$0(3);
        }
        AsyncPromise promise = new AsyncPromise();
        if (this.myExpiration != null) {
            Expiration.Handle expirationHandle = this.myExpiration.invokeOnExpiration(() -> ((AsyncPromise)promise).cancel());
            promise.onProcessed(value2 -> expirationHandle.unregisterHandler());
        }
        BooleanSupplier condition2 = () -> {
            if (promise.isCancelled()) {
                return false;
            }
            if (this.myExpiration != null && this.myExpiration.isExpired()) {
                return false;
            }
            if (this.myCancellationCondition != null && this.myCancellationCondition.getAsBoolean()) {
                promise.cancel();
                return false;
            }
            return true;
        };
        this.myExecutionScheduler.scheduleWithinConstraints(() -> {
            try {
                Object result2 = task2.call();
                promise.setResult(result2);
            }
            catch (Throwable e) {
                promise.setError(e);
            }
        }, condition2);
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionScheduler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/constraints/ConstrainedTaskExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "submit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

