/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.ex.ProgressSlide;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.XmlElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    public static final String DEFAULT_PLUGINS_HOST = "https://plugins.jetbrains.com";
    static final String IDEA_PLUGINS_HOST_PROPERTY = "idea.plugins.host";
    private static volatile ApplicationInfoImpl instance;
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private long myProgressColor;
    private long myCopyrightForeground;
    private long myAboutForeground;
    private long myAboutLinkColor;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight;
    private int myProgressY;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String myIconUrl;
    private String mySmallIconUrl;
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl;
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private boolean myShowLicensee;
    private String myWelcomeScreenDialog;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private int myWhatsNewEligibility;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> essentialPluginsIds;
    private String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myEvalLicenseUrl;
    private String myKeyConversionUrl;
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private List<ProgressSlide> progressSlides;
    private String myDefaultLightLaf;
    private String myDefaultDarkLaf;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    @NonInjectable
    ApplicationInfoImpl(@NotNull XmlElement element2) {
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myProgressColor = -1L;
        this.myCopyrightForeground = -1L;
        this.myAboutForeground = -1L;
        this.myAboutLinkColor = -1L;
        this.myProgressHeight = 2;
        this.myProgressY = 350;
        this.myIconUrl = "/icon.png";
        this.mySmallIconUrl = "/icon_small.png";
        this.myToolWindowIconUrl = "/toolwindows/toolWindowProject.svg";
        this.myShowLicensee = true;
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.essentialPluginsIds = new ArrayList<PluginId>();
        this.myEventLogSettingsUrl = "https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json";
        this.myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
        this.myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
        this.progressSlides = Collections.emptyList();
        block58: for (XmlElement child2 : element2.children) {
            switch (child2.name) {
                case "version": {
                    this.myMajorVersion = child2.getAttributeValue("major");
                    this.myMinorVersion = child2.getAttributeValue("minor");
                    this.myMicroVersion = child2.getAttributeValue("micro");
                    this.myPatchVersion = child2.getAttributeValue("patch");
                    this.myFullVersionFormat = child2.getAttributeValue("full");
                    this.myCodeName = child2.getAttributeValue("codename");
                    this.myEAP = Boolean.parseBoolean(child2.getAttributeValue("eap"));
                    this.myVersionSuffix = child2.getAttributeValue("suffix");
                    if (this.myVersionSuffix != null || !this.myEAP) break;
                    this.myVersionSuffix = "EAP";
                    break;
                }
                case "company": {
                    this.myCompanyName = child2.getAttributeValue("name", this.myCompanyName);
                    this.myShortCompanyName = child2.getAttributeValue("shortName", this.myCompanyName == null ? null : ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
                    this.myCompanyUrl = child2.getAttributeValue("url", this.myCompanyUrl);
                    this.myCopyrightStart = child2.getAttributeValue("copyrightStart", this.myCopyrightStart);
                    break;
                }
                case "build": {
                    this.readBuildInfo(child2);
                    break;
                }
                case "logo": {
                    this.readLogoInfo(child2);
                    break;
                }
                case "about": {
                    String c;
                    this.myAboutImageUrl = child2.getAttributeValue("url");
                    String v = child2.getAttributeValue("foreground");
                    if (v != null) {
                        this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
                    }
                    if ((v = child2.getAttributeValue("copyrightForeground")) != null) {
                        this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
                    }
                    if ((c = child2.getAttributeValue("linkColor")) != null) {
                        this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
                    }
                    String logoX = child2.getAttributeValue("logoX");
                    String logoY = child2.getAttributeValue("logoY");
                    String logoW = child2.getAttributeValue("logoW");
                    String logoH = child2.getAttributeValue("logoH");
                    if (logoX == null || logoY == null || logoW == null || logoH == null) continue block58;
                    try {
                        this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "icon": {
                    this.myIconUrl = child2.getAttributeValue("size32");
                    this.mySmallIconUrl = child2.getAttributeValue("size16", this.mySmallIconUrl);
                    this.myBigIconUrl = ApplicationInfoImpl.getAttributeValue(child2, "size128");
                    String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(child2, "size12");
                    if (toolWindowIcon != null) {
                        this.myToolWindowIconUrl = toolWindowIcon;
                    }
                    this.mySvgIconUrl = child2.getAttributeValue("svg");
                    this.mySmallSvgIconUrl = child2.getAttributeValue("svg-small");
                    break;
                }
                case "icon-eap": {
                    this.mySvgEapIconUrl = child2.getAttributeValue("svg");
                    this.mySmallSvgEapIconUrl = child2.getAttributeValue("svg-small");
                    break;
                }
                case "licensee": {
                    this.myShowLicensee = Boolean.parseBoolean(child2.getAttributeValue("show"));
                    break;
                }
                case "welcome-screen": {
                    this.myWelcomeScreenLogoUrl = child2.getAttributeValue("logo-url");
                    break;
                }
                case "welcome-wizard": {
                    this.myWelcomeScreenDialog = ApplicationInfoImpl.getAttributeValue(child2, "dialog");
                    break;
                }
                case "help": {
                    String attValue;
                    String webHelpUrl = ApplicationInfoImpl.getAttributeValue(child2, "webhelp-url");
                    if (webHelpUrl != null) {
                        this.myWebHelpUrl = webHelpUrl;
                    }
                    this.myHasHelp = (attValue = child2.getAttributeValue("has-help")) == null || Boolean.parseBoolean(attValue);
                    attValue = child2.getAttributeValue("has-context-help");
                    this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
                    break;
                }
                case "update-urls": {
                    this.myUpdateUrls = new UpdateUrlsImpl(child2);
                    break;
                }
                case "documentation": {
                    this.myDocumentationUrl = child2.getAttributeValue("url");
                    break;
                }
                case "support": {
                    this.mySupportUrl = child2.getAttributeValue("url");
                    break;
                }
                case "youtrack": {
                    this.myYoutrackUrl = child2.getAttributeValue("url");
                    break;
                }
                case "feedback": {
                    this.myFeedbackUrl = child2.getAttributeValue("url");
                    break;
                }
                case "whatsnew": {
                    this.myWhatsNewUrl = child2.getAttributeValue("url");
                    String eligibility = child2.getAttributeValue("eligibility");
                    if ("embed".equals(eligibility)) {
                        this.myWhatsNewEligibility = 1;
                        break;
                    }
                    if (!"auto".equals(eligibility)) continue block58;
                    this.myWhatsNewEligibility = 2;
                    break;
                }
                case "plugins": {
                    this.readPluginInfo(child2);
                    break;
                }
                case "keymap": {
                    this.myWinKeymapUrl = child2.getAttributeValue("win");
                    this.myMacKeymapUrl = child2.getAttributeValue("mac");
                    break;
                }
                case "essential-plugin": {
                    String id2 = child2.content;
                    if (id2 == null || id2.isEmpty()) continue block58;
                    this.essentialPluginsIds.add(PluginId.getId((String)id2));
                    break;
                }
                case "statistics": {
                    this.myEventLogSettingsUrl = child2.getAttributeValue("event-log-settings");
                    break;
                }
                case "jetbrains-tv": {
                    this.myJetBrainsTvUrl = child2.getAttributeValue("url");
                    break;
                }
                case "evaluation": {
                    String url = ApplicationInfoImpl.getAttributeValue(child2, "license-url");
                    if (url == null) continue block58;
                    this.myEvalLicenseUrl = url.trim();
                    break;
                }
                case "licensing": {
                    String url = ApplicationInfoImpl.getAttributeValue(child2, "key-conversion-url");
                    if (url == null) continue block58;
                    this.myKeyConversionUrl = url.trim();
                    break;
                }
                case "subscriptions": {
                    this.mySubscriptionFormId = child2.getAttributeValue("formid");
                    this.mySubscriptionNewsKey = child2.getAttributeValue("news-key");
                    this.mySubscriptionNewsValue = child2.getAttributeValue("news-value", "yes");
                    this.mySubscriptionTipsKey = child2.getAttributeValue("tips-key");
                    this.mySubscriptionTipsAvailable = Boolean.parseBoolean(child2.getAttributeValue("tips-available"));
                    this.mySubscriptionAdditionalFormData = child2.getAttributeValue("additional-form-data");
                    break;
                }
                case "default-laf": {
                    String laf = ApplicationInfoImpl.getAttributeValue(child2, "light");
                    if (laf != null) {
                        this.myDefaultLightLaf = laf.trim();
                    }
                    if ((laf = ApplicationInfoImpl.getAttributeValue(child2, "dark")) == null) break;
                    this.myDefaultDarkLaf = laf.trim();
                }
            }
        }
        this.essentialPluginsIds.sort(null);
    }

    private void readLogoInfo(@NotNull XmlElement element2) {
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element2, "url");
        String v = element2.getAttributeValue("progressColor");
        if (v != null && !v.isEmpty()) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = element2.getAttributeValue("progressTailIcon")) != null && !v.isEmpty()) {
            this.myProgressTailIconName = v;
        }
        if ((v = element2.getAttributeValue("progressHeight")) != null && !v.isEmpty()) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = element2.getAttributeValue("progressY")) != null && !v.isEmpty()) {
            this.myProgressY = Integer.parseInt(v);
        }
        if (!element2.children.isEmpty()) {
            this.progressSlides = new ArrayList<ProgressSlide>(element2.children.size());
            for (XmlElement child2 : element2.children) {
                if (!child2.name.equals("progressSlide")) continue;
                String slideUrl = Objects.requireNonNull(child2.getAttributeValue("url"));
                String progressPercent = Objects.requireNonNull(child2.getAttributeValue("progressPercent"));
                int progressPercentInt = Integer.parseInt(progressPercent);
                if (progressPercentInt < 0 || progressPercentInt > 100) {
                    throw new IllegalArgumentException("Expected [0, 100], got " + progressPercent);
                }
                float progressPercentFloat = (float)progressPercentInt / 100.0f;
                this.progressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
            }
        }
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        return ApplicationInfoImpl.getShadowInstanceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static ApplicationInfoImpl getShadowInstanceImpl() {
        ApplicationInfoImpl result2 = instance;
        if (result2 != null) {
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result2 = instance;
            if (result2 == null) {
                Activity activity = StartUpMeasurer.startActivity((String)"app info loading", (ActivityCategory)ActivityCategory.DEFAULT);
                try {
                    instance = result2 = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result2;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(3);
            }
            return applicationInfoImpl;
        }
    }

    @NotNull
    public static String orFromPluginsCompatibleBuild(@Nullable BuildNumber buildNumber) {
        BuildNumber number = buildNumber != null ? buildNumber : ApplicationInfoImpl.getShadowInstanceImpl().getPluginsCompatibleBuildAsNumber();
        String string = number.asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public Calendar getBuildDate() {
        if (this.myBuildDate == null) {
            this.myBuildDate = Calendar.getInstance();
        }
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString((String)this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        return buildNumber;
    }

    @NotNull
    public String getApiVersion() {
        String string = this.getApiVersionAsNumber().asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber api;
        BuildNumber build2 = this.getBuild();
        if (this.myApiVersion != null && (api = ApplicationInfoImpl.fromStringWithProductCode(this.myApiVersion, build2)) != null) {
            BuildNumber buildNumber = api;
            if (buildNumber == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(7);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build2;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        return buildNumber;
    }

    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @NotNull
    public String getFullVersion() {
        String result2 = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : ApplicationInfoImpl.requireNonNullElse(this.myMajorVersion) + '.' + ApplicationInfoImpl.requireNonNullElse(this.myMinorVersion);
        if (this.myVersionSuffix != null && !this.myVersionSuffix.isEmpty()) {
            result2 = result2 + " " + this.myVersionSuffix;
        }
        String string = result2;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getStrictVersion() {
        String string = this.myMajorVersion + "." + this.myMinorVersion + "." + ApplicationInfoImpl.requireNonNullElse(this.myMicroVersion) + "." + ApplicationInfoImpl.requireNonNullElse(this.myPatchVersion);
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && this.myCodeName != null && !this.myCodeName.isEmpty()) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    public String getCompanyName() {
        return this.myCompanyName;
    }

    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    @Override
    public long getProgressColor() {
        return this.myProgressColor;
    }

    @Override
    public long getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    @Override
    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    @Override
    public int getProgressY() {
        return this.myProgressY;
    }

    @Override
    @Nullable
    public String getProgressTailIcon() {
        return this.myProgressTailIconName;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public String getSmallIconUrl() {
        String string = this.mySmallIconUrl;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    @Nullable
    public String getApplicationSvgIconUrl() {
        return this.isEAP() && this.mySvgEapIconUrl != null ? this.mySvgEapIconUrl : this.mySvgIconUrl;
    }

    @Override
    @Nullable
    public String getSmallApplicationSvgIconUrl() {
        return this.getSmallApplicationSvgIconUrl(this.isEAP());
    }

    @Nullable
    public String getSmallApplicationSvgIconUrl(boolean isEap) {
        return isEap && this.mySmallSvgEapIconUrl != null ? this.mySmallSvgEapIconUrl : this.mySmallSvgIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    @Nullable
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getWelcomeWizardDialog() {
        return this.myWelcomeScreenDialog;
    }

    @Override
    public String getPackageCode() {
        return null;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public boolean isMajorEAP() {
        return this.myEAP && (this.myMinorVersion == null || this.myMinorVersion.indexOf(46) < 0);
    }

    @Override
    @Nullable
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getYoutrackUrl() {
        return this.myYoutrackUrl;
    }

    @Override
    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public boolean usesJetBrainsPluginRepository() {
        return DEFAULT_PLUGINS_HOST.equalsIgnoreCase(this.myPluginManagerUrl);
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    public boolean hasHelp() {
        return this.myHasHelp;
    }

    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public boolean isWhatsNewEligibleFor(int role) {
        return this.myWhatsNewEligibility >= role;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public long getAboutForeground() {
        return this.myAboutForeground;
    }

    @Override
    public long getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    @Override
    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    public String getEventLogSettingsUrl() {
        return this.myEventLogSettingsUrl;
    }

    public String getJetBrainsTvUrl() {
        return this.myJetBrainsTvUrl;
    }

    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    @Override
    public int @Nullable [] getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public String getSubscriptionNewsKey() {
        return this.mySubscriptionNewsKey;
    }

    @Override
    public String getSubscriptionNewsValue() {
        return this.mySubscriptionNewsValue;
    }

    @Override
    public String getSubscriptionTipsKey() {
        return this.mySubscriptionTipsKey;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @Override
    @Nullable
    public String getSubscriptionAdditionalFormData() {
        return this.mySubscriptionAdditionalFormData;
    }

    @Override
    @NotNull
    public List<ProgressSlide> getProgressSlides() {
        List<ProgressSlide> list2 = this.progressSlides;
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    @NlsSafe
    public String getPluginsCompatibleBuild() {
        String string = this.getPluginsCompatibleBuildAsNumber().asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public BuildNumber getPluginsCompatibleBuildAsNumber() {
        @Nullable BuildNumber compatibleBuild = BuildNumber.fromPluginsCompatibleBuild();
        BuildNumber version2 = compatibleBuild != null ? compatibleBuild : this.getApiVersionAsNumber();
        BuildNumber buildNumber = ApplicationInfoImpl.fromStringWithProductCode(version2.asString(), this.getBuild());
        BuildNumber buildNumber2 = Objects.requireNonNull(buildNumber);
        if (buildNumber2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        return buildNumber2;
    }

    @Nullable
    private static BuildNumber fromStringWithProductCode(@NotNull String version2, @NotNull BuildNumber buildNumber) {
        if (version2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(16);
        }
        return BuildNumber.fromStringWithProductCode((String)version2, (String)buildNumber.getProductCode());
    }

    @Nullable
    private static String getAttributeValue(@NotNull XmlElement element2, @NotNull String name) {
        String value2;
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(17);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(18);
        }
        return (value2 = element2.getAttributeValue(name)) == null || value2.isEmpty() ? null : value2;
    }

    private void readBuildInfo(@NotNull XmlElement element2) {
        String majorReleaseDateString;
        if (element2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(19);
        }
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element2, "number");
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element2, "apiVersion");
        String dateString = element2.getAttributeValue("date");
        if (dateString != null && !dateString.equals("__BUILD_DATE__")) {
            this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element2.getAttributeValue("majorReleaseDate")) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable XmlElement element2) {
        String pluginsHost;
        String pluginManagerUrl = DEFAULT_PLUGINS_HOST;
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element2 != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element2.getAttributeValue("url");
            if (url != null) {
                String string = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element2.getAttributeValue("list-url")) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element2.getAttributeValue("channel-list-url")) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element2.getAttributeValue("download-url")) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if ((builtinPluginsUrl = element2.getAttributeValue("builtin-url")) != null && !builtinPluginsUrl.isEmpty()) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginsHost = System.getProperty(IDEA_PLUGINS_HOST_PROPERTY)) != null) {
            pluginManagerUrl = pluginsHost.endsWith("/") ? pluginsHost.substring(0, pluginsHost.length() - 1) : pluginsHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    private static String shortenCompanyName(@NotNull String name) {
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(20);
        }
        if (name.endsWith(" s.r.o.")) {
            name = name.substring(0, name.length() - " s.r.o.".length());
        }
        if (name.endsWith(" Inc.")) {
            name = name.substring(0, name.length() - " Inc.".length());
        }
        return name;
    }

    @NotNull
    private static GregorianCalendar parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GregorianCalendar gregorianCalendar = calendar;
        if (gregorianCalendar == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(22);
        }
        return gregorianCalendar;
    }

    private static long parseColor(@NotNull String colorString) {
        if (colorString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return Long.parseLong(colorString, 16);
    }

    private static String requireNonNullElse(String s) {
        return s != null ? s : "0";
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(24);
        }
        return "com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId((String)pluginId));
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(25);
        }
        return PluginManagerCore.CORE_ID.equals((Object)pluginId) || Collections.binarySearch(this.essentialPluginsIds, pluginId) >= 0;
    }

    @Override
    @NotNull
    public List<PluginId> getEssentialPluginsIds() {
        List<PluginId> list2 = this.essentialPluginsIds;
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @Override
    @Nullable
    public String getDefaultLightLaf() {
        return this.myDefaultLightLaf;
    }

    @Override
    @Nullable
    public String getDefaultDarkLaf() {
        return this.myDefaultDarkLaf;
    }

    @Deprecated
    public static boolean isInStressTest() {
        return ApplicationManagerEx.isInStressTest();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstanceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "orFromPluginsCompatibleBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressSlides";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCompatibleBuild";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsCompatibleBuildAsNumber";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readLogoInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fromStringWithProductCode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readBuildInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shortenCompanyName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseColor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(@NotNull XmlElement element2) {
            if (element2 == null) {
                UpdateUrlsImpl.$$$reportNull$$$0(0);
            }
            this.myCheckingUrl = element2.getAttributeValue("check");
            this.myPatchesUrl = element2.getAttributeValue("patches");
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/application/impl/ApplicationInfoImpl$UpdateUrlsImpl", "<init>"));
        }
    }
}

