/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.constraints.BaseConstrainedExecution;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.AsyncExecutionServiceImpl;
import com.intellij.openapi.application.impl.InSmartMode;
import com.intellij.openapi.application.impl.SubmissionTracker;
import com.intellij.openapi.application.impl.WithDocumentsCommitted;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.RunnableCallable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
public final class NonBlockingReadActionImpl<T>
implements NonBlockingReadAction<T> {
    private static final Logger LOG = Logger.getInstance(NonBlockingReadActionImpl.class);
    private static final Executor SYNC_DUMMY_EXECUTOR = __ -> {
        throw new UnsupportedOperationException();
    };
    private final ModalityState myModalityState;
    private final Consumer<? super T> myUiThreadAction;
    private final ConstrainedExecution.ContextConstraint @NotNull [] myConstraints;
    private final BooleanSupplier @NotNull [] myCancellationConditions;
    private final Set<? extends Disposable> myDisposables;
    @Nullable
    private final List<?> myCoalesceEquality;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    private final Callable<? extends T> myComputation;
    private static final Set<Submission<?>> ourTasks = ContainerUtil.newConcurrentSet();
    private static final Map<List<?>, Submission<?>> ourTasksByEquality = new HashMap();
    private static final SubmissionTracker ourUnboundedSubmissionTracker = new SubmissionTracker();

    NonBlockingReadActionImpl(@NotNull Callable<? extends T> computation) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(0);
        }
        this(computation, null, null, new ConstrainedExecution.ContextConstraint[0], new BooleanSupplier[0], Collections.emptySet(), null, null);
    }

    private NonBlockingReadActionImpl(@NotNull Callable<? extends T> computation, @Nullable ModalityState modalityState, @Nullable Consumer<? super T> uiThreadAction, ConstrainedExecution.ContextConstraint @NotNull [] constraints2, BooleanSupplier @NotNull [] cancellationConditions, @NotNull Set<? extends Disposable> disposables, @Nullable List<?> coalesceEquality, @Nullable ProgressIndicator progressIndicator) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(1);
        }
        if (disposables == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(2);
        }
        if (constraints2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(3);
        }
        if (cancellationConditions == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(4);
        }
        this.myComputation = computation;
        this.myModalityState = modalityState;
        this.myUiThreadAction = uiThreadAction;
        this.myConstraints = constraints2;
        this.myCancellationConditions = cancellationConditions;
        this.myDisposables = disposables;
        this.myCoalesceEquality = coalesceEquality;
        this.myProgressIndicator = progressIndicator;
        if (modalityState == null != (uiThreadAction == null)) {
            throw new IllegalArgumentException("myModalityState and myUiThreadAction must be both null or both not-null but got: " + modalityState + ", " + uiThreadAction);
        }
    }

    @NotNull
    private NonBlockingReadActionImpl<T> withConstraint(@NotNull ConstrainedExecution.ContextConstraint constraint) {
        if (constraint == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(5);
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myModalityState, this.myUiThreadAction, (ConstrainedExecution.ContextConstraint[])ArrayUtil.append((Object[])this.myConstraints, (Object)constraint), this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    private static void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLaterOnWriteThread(runnable2, ModalityState.any());
    }

    @NotNull
    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(7);
        }
        NonBlockingReadAction<T> nonBlockingReadAction = this.withConstraint(new InSmartMode(project)).expireWith((Disposable)project);
        if (nonBlockingReadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(8);
        }
        return nonBlockingReadAction;
    }

    @NotNull
    public NonBlockingReadAction<T> withDocumentsCommitted(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(9);
        }
        NonBlockingReadAction<T> nonBlockingReadAction = this.withConstraint(new WithDocumentsCommitted(project, ModalityState.any())).expireWith((Disposable)project);
        if (nonBlockingReadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(10);
        }
        return nonBlockingReadAction;
    }

    @NotNull
    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        if (expireCondition == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(11);
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, (BooleanSupplier[])ArrayUtil.append((Object[])this.myCancellationConditions, (Object)expireCondition), this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> expireWith(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(12);
        }
        HashSet<? extends Disposable> disposables = new HashSet<Disposable>(this.myDisposables);
        disposables.add((Disposable)parentDisposable);
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, this.myCancellationConditions, disposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> wrapProgress(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(13);
        }
        LOG.assertTrue(this.myProgressIndicator == null, (Object)"Unspecified behaviour. Outer progress indicator is already set for the action.");
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, progressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<? super T> uiThreadAction) {
        if (modality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(14);
        }
        if (uiThreadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(15);
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, modality, uiThreadAction, this.myConstraints, this.myCancellationConditions, this.myDisposables, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @NotNull
    public NonBlockingReadAction<T> coalesceBy(Object ... equality) {
        if (equality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(16);
        }
        if (this.myCoalesceEquality != null) {
            throw new IllegalStateException("Setting equality twice is not allowed");
        }
        if (equality.length == 0) {
            throw new IllegalArgumentException("Equality should include at least one object");
        }
        if (equality.length == 1 && NonBlockingReadActionImpl.isTooCommon(equality[0])) {
            throw new IllegalArgumentException("Equality should be unique: passing " + equality[0] + " is likely to interfere with unrelated computations from different places");
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myModalityState, this.myUiThreadAction, this.myConstraints, this.myCancellationConditions, this.myDisposables, new ArrayList<Object>(Arrays.asList(equality)), this.myProgressIndicator);
    }

    private static boolean isTooCommon(Object o) {
        return o instanceof Project || o instanceof PsiElement || o instanceof Document || o instanceof VirtualFile || o instanceof Editor || o instanceof FileEditor || o instanceof Class || o instanceof KClass || o instanceof String || o == null;
    }

    public T executeSynchronously() throws ProcessCanceledException {
        if (this.myModalityState != null || this.myCoalesceEquality != null) {
            throw new IllegalStateException((this.myModalityState != null ? "finishOnUiThread" : "coalesceBy") + " is not supported with synchronous non-blocking read actions");
        }
        ProgressIndicator outerIndicator = this.myProgressIndicator != null ? this.myProgressIndicator : ProgressIndicatorProvider.getGlobalProgressIndicator();
        return new Submission(this, SYNC_DUMMY_EXECUTOR, outerIndicator).executeSynchronously();
    }

    @NotNull
    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        if (backgroundThreadExecutor == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(17);
        }
        Submission submission = new Submission(this, backgroundThreadExecutor, this.myProgressIndicator);
        if (this.myCoalesceEquality == null) {
            submission.transferToBgThread();
        } else {
            submission.submitOrScheduleCoalesced(this.myCoalesceEquality);
        }
        Submission submission2 = submission;
        if (submission2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(18);
        }
        return submission2;
    }

    @Nullable
    private ConstrainedExecution.ContextConstraint findUnsatisfiedConstraint() {
        return (ConstrainedExecution.ContextConstraint)ContainerUtil.find((Object[])this.myConstraints, t -> !t.isCorrectContext());
    }

    @TestOnly
    public static void waitForAsyncTaskCompletion() {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        for (Submission<?> task2 : ourTasks) {
            NonBlockingReadActionImpl.waitForTask(task2);
        }
    }

    @TestOnly
    private static void waitForTask(@NotNull Submission<?> task2) {
        if (task2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(19);
        }
        for (ConstrainedExecution.ContextConstraint constraint : task2.builder.myConstraints) {
            if (!(constraint instanceof InSmartMode) || constraint.isCorrectContext()) continue;
            return;
        }
        int iteration = 0;
        while (!task2.isDone() && iteration++ < 60000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                task2.blockingGet(1, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!task2.isDone()) {
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)("Too long async task " + task2));
        }
    }

    @TestOnly
    @NotNull
    static Map<List<?>, Submission<?>> getTasksByEquality() {
        Map<List<?>, Submission<?>> map2 = ourTasksByEquality;
        if (map2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(20);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposables";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationConditions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expireCondition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiThreadAction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundThreadExecutor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "inSmartMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withDocumentsCommitted";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksByEquality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withConstraint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inSmartMode";
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentsCommitted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expireWhen";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expireWith";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgress";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "finishOnUiThread";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "coalesceBy";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Submission<T>
    extends AsyncPromise<T> {
        @NotNull
        private final Executor backendExecutor;
        @Nullable
        private final String myStartTrace;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality;
        @Nullable
        private Submission<?> myReplacement;
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        @NotNull
        private final NonBlockingReadActionImpl<T> builder;
        private int myUseCount;
        private final AtomicBoolean myCleaned;
        private final List<Disposable> myExpirationDisposables;

        Submission(@NotNull NonBlockingReadActionImpl<T> builder2, @NotNull Executor backgroundThreadExecutor, @Nullable ProgressIndicator outerIndicator) {
            if (builder2 == null) {
                Submission.$$$reportNull$$$0(0);
            }
            if (backgroundThreadExecutor == null) {
                Submission.$$$reportNull$$$0(1);
            }
            this.creationModality = ModalityState.defaultModalityState();
            this.myCleaned = new AtomicBoolean();
            this.myExpirationDisposables = new ArrayList<Disposable>();
            this.backendExecutor = backgroundThreadExecutor;
            this.builder = builder2;
            if (builder2.myCoalesceEquality != null) {
                this.acquire();
            }
            this.myProgressIndicator = outerIndicator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating " + this);
            }
            String string = this.myStartTrace = this.hasUnboundedExecutor() ? ourUnboundedSubmissionTracker.preventTooManySubmissions() : null;
            if (this.shouldTrackInTests()) {
                ourTasks.add(this);
            }
            if (!builder2.myDisposables.isEmpty()) {
                ApplicationManager.getApplication().runReadAction(() -> this.expireWithDisposables(this.builder.myDisposables));
            }
        }

        private void expireWithDisposables(@NotNull Set<? extends Disposable> disposables) {
            if (disposables == null) {
                Submission.$$$reportNull$$$0(2);
            }
            for (Disposable disposable2 : disposables) {
                Disposable parentDisposable;
                if (disposable2 instanceof Project ? ((Project)disposable2).isDisposed() : Disposer.isDisposed((Disposable)disposable2)) {
                    this.cancel();
                    break;
                }
                Disposable child2 = new Disposable(){

                    public void dispose() {
                        this.cancel();
                    }
                };
                Disposable disposable3 = parentDisposable = disposable2 instanceof ProjectImpl && ((ProjectEx)disposable2).isLight() ? ((ProjectImpl)disposable2).getEarlyDisposable() : disposable2;
                if (!Disposer.tryRegister((Disposable)parentDisposable, (Disposable)child2)) {
                    this.cancel();
                    break;
                }
                this.myExpirationDisposables.add(child2);
            }
        }

        private boolean shouldTrackInTests() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR && ApplicationManager.getApplication().isUnitTestMode();
        }

        private boolean hasUnboundedExecutor() {
            return this.backendExecutor == AppExecutorUtil.getAppExecutorService();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result2 = super.cancel(mayInterruptIfRunning);
            this.cleanupIfNeeded();
            return result2;
        }

        public void setResult(@Nullable T t) {
            super.setResult(t);
            this.cleanupIfNeeded();
        }

        public boolean setError(@NotNull Throwable error2) {
            if (error2 == null) {
                Submission.$$$reportNull$$$0(3);
            }
            boolean result2 = super.setError(error2);
            this.cleanupIfNeeded();
            return result2;
        }

        protected boolean shouldLogErrors() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR;
        }

        private void cleanupIfNeeded() {
            if (this.myCleaned.compareAndSet(false, true)) {
                this.cleanup();
            }
        }

        private void cleanup() {
            ProgressIndicator indicator2;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cleaning " + this);
            }
            if ((indicator2 = this.currentIndicator) != null) {
                indicator2.cancel();
            }
            if (this.builder.myCoalesceEquality != null) {
                this.release();
            }
            for (Disposable disposable2 : this.myExpirationDisposables) {
                Disposer.dispose((Disposable)disposable2);
            }
            if (this.hasUnboundedExecutor()) {
                ourUnboundedSubmissionTracker.unregisterSubmission(this.myStartTrace);
            }
            if (this.shouldTrackInTests()) {
                ourTasks.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquire() {
            assert (this.builder.myCoalesceEquality != null);
            Map<List<?>, Submission<?>> map2 = ourTasksByEquality;
            synchronized (map2) {
                ++this.myUseCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release() {
            assert (this.builder.myCoalesceEquality != null);
            Map<List<?>, Submission<?>> map2 = ourTasksByEquality;
            synchronized (map2) {
                if (--this.myUseCount == 0 && ourTasksByEquality.get(this.builder.myCoalesceEquality) == this) {
                    this.scheduleReplacementIfAny();
                }
            }
        }

        private void scheduleReplacementIfAny() {
            if (this.myReplacement == null || this.myReplacement.isDone()) {
                ourTasksByEquality.remove(this.builder.myCoalesceEquality, (Object)this);
            } else {
                ourTasksByEquality.put(this.builder.myCoalesceEquality, this.myReplacement);
                this.myReplacement.transferToBgThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitOrScheduleCoalesced(@NotNull List<?> coalesceEquality) {
            if (coalesceEquality == null) {
                Submission.$$$reportNull$$$0(4);
            }
            Map<List<?>, Submission<?>> map2 = ourTasksByEquality;
            synchronized (map2) {
                if (this.isDone()) {
                    return;
                }
                Submission current2 = ourTasksByEquality.putIfAbsent(coalesceEquality, this);
                if (current2 == null) {
                    this.transferToBgThread();
                } else {
                    if (!current2.getComputationOrigin().equals(this.getComputationOrigin())) {
                        this.reportCoalescingConflict(current2);
                    }
                    if (current2.myReplacement != null) {
                        current2.myReplacement.cancel();
                        assert (current2 == ourTasksByEquality.get(coalesceEquality));
                    }
                    current2.myReplacement = this;
                    current2.cancel();
                }
            }
        }

        private void reportCoalescingConflict(@NotNull Submission<?> current2) {
            if (current2 == null) {
                Submission.$$$reportNull$$$0(5);
            }
            ourTasks.remove((Object)this);
            LOG.error("Same coalesceBy arguments are already used by " + current2.getComputationOrigin() + " so they can cancel each other. Please make them more unique.");
        }

        @NotNull
        private String getComputationOrigin() {
            String name;
            int dollars;
            Callable computation = this.builder.myComputation;
            if (computation instanceof RunnableCallable) {
                computation = ((RunnableCallable)computation).getDelegate();
            }
            String string = (dollars = (name = computation.getClass().getName()).indexOf("$$Lambda")) >= 0 ? name.substring(0, dollars) : name;
            if (string == null) {
                Submission.$$$reportNull$$$0(6);
            }
            return string;
        }

        void transferToBgThread() {
            ApplicationEx app;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting " + this);
            }
            if ((app = ApplicationManagerEx.getApplicationEx()).isWriteActionInProgress() || app.isWriteActionPending() || app.isReadAccessAllowed() && this.builder.findUnsatisfiedConstraint() != null) {
                this.rescheduleLater();
                return;
            }
            if (this.builder.myCoalesceEquality != null) {
                this.acquire();
            }
            this.backendExecutor.execute(ClientId.decorateRunnable(() -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running in background " + this);
                }
                try {
                    if (!this.attemptComputation()) {
                        this.rescheduleLater();
                    }
                }
                finally {
                    if (this.builder.myCoalesceEquality != null) {
                        this.release();
                    }
                }
            }));
        }

        T executeSynchronously() {
            do {
                this.attemptComputation();
                if (this.isCancelled()) {
                    throw new ProcessCanceledException();
                }
                if (this.isDone()) {
                    try {
                        return (T)this.blockingGet(0, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }
                Semaphore semaphore = new Semaphore(1);
                NonBlockingReadActionImpl.invokeLater(() -> {
                    if (this.checkObsolete()) {
                        semaphore.up();
                    } else {
                        BaseConstrainedExecution.scheduleWithinConstraints(() -> ((Semaphore)semaphore).up(), null, this.builder.myConstraints);
                    }
                });
                ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, this.myProgressIndicator);
            } while (!this.isCancelled());
            throw new ProcessCanceledException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean attemptComputation() {
            Object indicator2;
            Object object = indicator2 = this.myProgressIndicator == null ? new EmptyProgressIndicator(this.creationModality) : new SensitiveProgressWrapper(this.myProgressIndicator){

                @Override
                @NotNull
                public ModalityState getModalityState() {
                    ModalityState modalityState = creationModality;
                    if (modalityState == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return modalityState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission$2", "getModalityState"));
                }
            };
            if (this.myProgressIndicator != null) {
                indicator2.setIndeterminate(this.myProgressIndicator.isIndeterminate());
            }
            this.currentIndicator = indicator2;
            try {
                boolean success2;
                Ref unsatisfiedConstraint = Ref.create();
                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    this.insideReadAction((ProgressIndicator)indicator2, (Ref<ConstrainedExecution.ContextConstraint>)unsatisfiedConstraint);
                    success2 = true;
                    if (!unsatisfiedConstraint.isNull()) {
                        throw new IllegalStateException("Constraint " + unsatisfiedConstraint + " cannot be satisfied");
                    }
                } else {
                    if (this.myProgressIndicator != null) {
                        try {
                            this.myProgressIndicator.checkCanceled();
                        }
                        catch (ProcessCanceledException e) {
                            boolean bl = false;
                            this.currentIndicator = null;
                            return bl;
                        }
                    }
                    success2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> this.lambda$attemptComputation$3((ProgressIndicator)indicator2, unsatisfiedConstraint), (ProgressIndicator)indicator2);
                }
                boolean bl = success2 && unsatisfiedConstraint.isNull();
                return bl;
            }
            finally {
                this.currentIndicator = null;
            }
        }

        private void rescheduleLater() {
            if (Promises.isPending((Promise)this)) {
                NonBlockingReadActionImpl.invokeLater(() -> this.reschedule());
            }
        }

        private void reschedule() {
            if (!this.checkObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Rescheduling " + this);
                }
                BaseConstrainedExecution.scheduleWithinConstraints(() -> this.transferToBgThread(), null, this.builder.myConstraints);
            }
        }

        private void insideReadAction(@NotNull ProgressIndicator indicator2, @NotNull Ref<? super ConstrainedExecution.ContextConstraint> outUnsatisfiedConstraint) {
            if (indicator2 == null) {
                Submission.$$$reportNull$$$0(7);
            }
            if (outUnsatisfiedConstraint == null) {
                Submission.$$$reportNull$$$0(8);
            }
            try {
                if (this.checkObsolete()) {
                    return;
                }
                ConstrainedExecution.ContextConstraint constraint = this.builder.findUnsatisfiedConstraint();
                if (constraint != null) {
                    outUnsatisfiedConstraint.set((Object)constraint);
                    return;
                }
                Object result2 = this.builder.myComputation.call();
                if (this.builder.myModalityState != null) {
                    this.safeTransferToEdt(result2);
                } else {
                    this.setResult(result2);
                }
            }
            catch (ServiceNotReadyException e) {
                throw e;
            }
            catch (ProcessCanceledException e) {
                if (!indicator2.isCanceled()) {
                    this.setError(e);
                }
                throw e;
            }
            catch (Throwable e) {
                this.setError(e);
            }
        }

        private boolean checkObsolete() {
            if (Promises.isRejected((Promise)this)) {
                return true;
            }
            for (BooleanSupplier condition2 : this.builder.myCancellationConditions) {
                if (!condition2.getAsBoolean()) continue;
                this.cancel();
                return true;
            }
            if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                this.cancel();
                return true;
            }
            return false;
        }

        private void safeTransferToEdt(T result2) {
            if (Promises.isRejected((Promise)this)) {
                return;
            }
            long stamp = AsyncExecutionServiceImpl.getWriteActionCounter();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (stamp != AsyncExecutionServiceImpl.getWriteActionCounter()) {
                    this.reschedule();
                    return;
                }
                if (this.checkObsolete()) {
                    return;
                }
                this.setResult(result2);
                if (this.isSucceeded()) {
                    this.builder.myUiThreadAction.accept(result2);
                }
            }, this.builder.myModalityState, __ -> this.isCancelled());
        }

        public String toString() {
            return "Submission{" + this.builder.myComputation + ", " + this.getState() + "}";
        }

        private /* synthetic */ void lambda$attemptComputation$3(ProgressIndicator indicator2, Ref unsatisfiedConstraint) {
            this.insideReadAction(indicator2, (Ref<ConstrainedExecution.ContextConstraint>)unsatisfiedConstraint);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backgroundThreadExecutor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposables";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coalesceEquality";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outUnsatisfiedConstraint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComputationOrigin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "expireWithDisposables";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setError";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "submitOrScheduleCoalesced";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "reportCoalescingConflict";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "insideReadAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

