/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.Redo;
import com.intellij.openapi.command.impl.Undo;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandMerger {
    private final UndoManagerImpl myManager;
    private Reference<Object> myLastGroupId;
    private boolean myForcedGlobal;
    private boolean myTransparent;
    private @NlsContexts.Command String myCommandName;
    private boolean myValid;
    @NotNull
    private List<UndoableAction> myCurrentActions;
    @NotNull
    private Set<DocumentReference> myAllAffectedDocuments;
    @NotNull
    private Set<DocumentReference> myAdditionalAffectedDocuments;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private UndoConfirmationPolicy myUndoConfirmationPolicy;

    CommandMerger(@NotNull UndoManagerImpl manager2) {
        if (manager2 == null) {
            CommandMerger.$$$reportNull$$$0(0);
        }
        this.myValid = true;
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAllAffectedDocuments = new HashSet<DocumentReference>();
        this.myAdditionalAffectedDocuments = new HashSet<DocumentReference>();
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        this.myManager = manager2;
    }

    CommandMerger(@NotNull UndoManagerImpl manager2, boolean isTransparent) {
        if (manager2 == null) {
            CommandMerger.$$$reportNull$$$0(1);
        }
        this.myValid = true;
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAllAffectedDocuments = new HashSet<DocumentReference>();
        this.myAdditionalAffectedDocuments = new HashSet<DocumentReference>();
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        this.myManager = manager2;
        this.myTransparent = isTransparent;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    void addAction(@NotNull UndoableAction action2) {
        if (action2 == null) {
            CommandMerger.$$$reportNull$$$0(2);
        }
        this.myCurrentActions.add(action2);
        this.addActionToSharedStack(action2);
        DocumentReference[] refs = action2.getAffectedDocuments();
        if (refs != null) {
            Collections.addAll(this.myAllAffectedDocuments, refs);
        }
        this.myForcedGlobal |= action2.isGlobal();
    }

    private void addActionToSharedStack(@NotNull UndoableAction action2) {
        if (action2 == null) {
            CommandMerger.$$$reportNull$$$0(3);
        }
        if (action2 instanceof AdjustableUndoableAction) {
            AdjustableUndoableAction adjustable = (AdjustableUndoableAction)action2;
            DocumentReference[] affected = action2.getAffectedDocuments();
            if (affected == null) {
                return;
            }
            for (DocumentReference reference2 : affected) {
                for (ActionChangeRange changeRange : adjustable.getChangeRanges(reference2)) {
                    this.myManager.getSharedUndoStacksHolder().addToStack(reference2, changeRange);
                    this.myManager.getSharedRedoStacksHolder().addToStack(reference2, changeRange.createIndependentCopy(true));
                }
            }
        }
    }

    void commandFinished(@NlsContexts.Command String commandName2, Object groupId2, @NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(4);
        }
        if (!nextCommandToMerge.isTransparent() && nextCommandToMerge.hasActions()) {
            this.clearRedoStacks(nextCommandToMerge);
        }
        if (!this.shouldMerge(groupId2, nextCommandToMerge)) {
            this.flushCurrentCommand();
            this.myManager.compact();
        }
        this.merge(nextCommandToMerge);
        if (nextCommandToMerge.isTransparent() || !this.hasActions()) {
            return;
        }
        if (groupId2 != SoftReference.dereference(this.myLastGroupId)) {
            WeakReference<Object> weakReference = this.myLastGroupId = groupId2 == null ? null : new WeakReference<Object>(groupId2);
        }
        if (this.myCommandName == null) {
            this.myCommandName = commandName2;
        }
    }

    private boolean shouldMerge(Object groupId2, @NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(5);
        }
        if (nextCommandToMerge.isTransparent() && nextCommandToMerge.myStateAfter == null && this.myStateAfter != null) {
            return false;
        }
        if (this.isTransparent() && this.myStateBefore == null && nextCommandToMerge.myStateBefore != null) {
            return false;
        }
        if (this.isTransparent() || nextCommandToMerge.isTransparent()) {
            return !this.hasActions() || !nextCommandToMerge.hasActions() || this.myAllAffectedDocuments.equals(nextCommandToMerge.myAllAffectedDocuments);
        }
        return !this.myForcedGlobal && !nextCommandToMerge.myForcedGlobal && CommandMerger.canMergeGroup(groupId2, SoftReference.dereference(this.myLastGroupId));
    }

    void clearDocumentReferences(@NotNull Document document) {
        if (document == null) {
            CommandMerger.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentReference refByFile = DocumentReferenceManager.getInstance().create(document);
        DocumentReferenceByDocument refByDoc = new DocumentReferenceByDocument(document);
        this.myCurrentActions.removeIf(action2 -> {
            Object[] refs = (DocumentReference[])ObjectUtils.notNull((Object)action2.getAffectedDocuments(), (Object)DocumentReference.EMPTY_ARRAY);
            return ContainerUtil.and((Object[])refs, ref -> ref.equals(refByDoc) || ref.equals(refByFile));
        });
        this.myAllAffectedDocuments.remove(refByFile);
        this.myAllAffectedDocuments.remove(refByDoc);
        this.myAdditionalAffectedDocuments.remove(refByFile);
        this.myAdditionalAffectedDocuments.remove(refByDoc);
    }

    private static boolean refMatch(@NotNull Document document, VirtualFile file2, @NotNull DocumentReference ref) {
        if (document == null) {
            CommandMerger.$$$reportNull$$$0(7);
        }
        if (ref == null) {
            CommandMerger.$$$reportNull$$$0(8);
        }
        return file2 != null && file2.equals(ref.getFile()) || ref.getDocument() == document;
    }

    public static boolean canMergeGroup(Object groupId2, Object lastGroupId) {
        return groupId2 != null && Comparing.equal((Object)lastGroupId, (Object)groupId2);
    }

    private void merge(@NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(9);
        }
        this.setBeforeState(nextCommandToMerge.myStateBefore);
        this.myStateAfter = nextCommandToMerge.myStateAfter;
        if (this.myTransparent) {
            if (nextCommandToMerge.hasActions()) {
                this.myTransparent = nextCommandToMerge.myTransparent;
            }
        } else if (!this.hasActions()) {
            this.myTransparent = nextCommandToMerge.myTransparent;
        }
        this.myValid &= nextCommandToMerge.myValid;
        this.myForcedGlobal |= nextCommandToMerge.myForcedGlobal;
        this.myCurrentActions.addAll(nextCommandToMerge.myCurrentActions);
        this.myAllAffectedDocuments.addAll(nextCommandToMerge.myAllAffectedDocuments);
        this.myAdditionalAffectedDocuments.addAll(nextCommandToMerge.myAdditionalAffectedDocuments);
        this.mergeUndoConfirmationPolicy(nextCommandToMerge.getUndoConfirmationPolicy());
    }

    void mergeUndoConfirmationPolicy(UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.myUndoConfirmationPolicy == UndoConfirmationPolicy.DEFAULT) {
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
        } else if (this.myUndoConfirmationPolicy == UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && undoConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION) {
            this.myUndoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        }
    }

    void flushCurrentCommand() {
        this.flushCurrentCommand(this.myManager.nextCommandTimestamp(), this.myManager.getUndoStacksHolder());
    }

    void flushCurrentCommand(int commandTimestamp, @NotNull UndoRedoStacksHolder stacksHolder) {
        if (stacksHolder == null) {
            CommandMerger.$$$reportNull$$$0(10);
        }
        if (this.hasActions()) {
            if (!this.myAdditionalAffectedDocuments.isEmpty()) {
                DocumentReference[] refs = this.myAdditionalAffectedDocuments.toArray(DocumentReference.EMPTY_ARRAY);
                this.myCurrentActions.add((UndoableAction)new MyEmptyUndoableAction(refs));
            }
            stacksHolder.addToStacks(new UndoableGroup(this.myCommandName, this.isGlobal(), commandTimestamp, this.myStateBefore, this.myStateAfter, this.myCurrentActions, stacksHolder, this.myManager.getProject(), this.myUndoConfirmationPolicy, this.isTransparent(), this.myValid));
        }
        this.reset();
    }

    private void reset() {
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAllAffectedDocuments = new HashSet<DocumentReference>();
        this.myAdditionalAffectedDocuments = new HashSet<DocumentReference>();
        this.myLastGroupId = null;
        this.myForcedGlobal = false;
        this.myTransparent = false;
        this.myCommandName = null;
        this.myValid = true;
        this.myStateAfter = null;
        this.myStateBefore = null;
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
    }

    private void clearRedoStacks(@NotNull CommandMerger nextMerger) {
        if (nextMerger == null) {
            CommandMerger.$$$reportNull$$$0(11);
        }
        this.myManager.getRedoStacksHolder().clearStacks(nextMerger.isGlobal(), nextMerger.myAllAffectedDocuments);
    }

    boolean isGlobal() {
        return this.myForcedGlobal || this.affectsMultiplePhysicalDocs();
    }

    void markAsGlobal() {
        this.myForcedGlobal = true;
    }

    boolean isTransparent() {
        return this.myTransparent;
    }

    private boolean affectsMultiplePhysicalDocs() {
        HashSet<VirtualFile> affectedFiles2 = new HashSet<VirtualFile>();
        for (DocumentReference each : this.myAllAffectedDocuments) {
            VirtualFile file2 = each.getFile();
            if (CommandMerger.isVirtualDocumentChange(file2)) continue;
            affectedFiles2.add(file2);
            if (affectedFiles2.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isVirtualDocumentChange(VirtualFile file2) {
        return file2 == null || file2 instanceof LightVirtualFile;
    }

    void undoOrRedo(FileEditor editor, boolean isUndo) {
        UndoRedo undoRedo;
        this.flushCurrentCommand();
        while ((undoRedo = this.createUndoOrRedo(editor, true)) != null && undoRedo.isTemporary()) {
            if (!undoRedo.execute(true, false)) {
                return;
            }
            if (undoRedo.hasMoreActions()) continue;
        }
        while ((undoRedo = this.createUndoOrRedo(editor, isUndo)) != null && undoRedo.isTransparent()) {
            if (!undoRedo.execute(false, false)) {
                return;
            }
            if (undoRedo.hasMoreActions()) continue;
        }
        boolean isInsideStartFinishGroup = false;
        while ((undoRedo = this.createUndoOrRedo(editor, isUndo)) != null) {
            boolean shouldRepeat;
            UndoRedo blockingChange;
            if (editor != null && undoRedo.isBlockedByOtherChanges() && (blockingChange = this.createUndoOrRedo(null, isUndo)) != null && blockingChange.myUndoableGroup != undoRedo.myUndoableGroup) {
                if (!undoRedo.confirmSwitchTo(blockingChange)) break;
                blockingChange.execute(false, true);
                break;
            }
            if (!undoRedo.execute(false, isInsideStartFinishGroup)) {
                return;
            }
            if ((isInsideStartFinishGroup = undoRedo.myUndoableGroup.isInsideStartFinishGroup(isUndo, isInsideStartFinishGroup)) || (shouldRepeat = undoRedo.isTransparent() && undoRedo.hasMoreActions())) continue;
            break;
        }
    }

    @Nullable
    private UndoRedo createUndoOrRedo(FileEditor editor, boolean isUndo) {
        if (!this.myManager.isUndoOrRedoAvailable(editor, isUndo)) {
            return null;
        }
        return isUndo ? new Undo(this.myManager, editor) : new Redo(this.myManager, editor);
    }

    UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return this.myUndoConfirmationPolicy;
    }

    boolean hasActions() {
        return !this.myCurrentActions.isEmpty();
    }

    boolean isPhysical() {
        if (this.myAllAffectedDocuments.isEmpty()) {
            return false;
        }
        for (DocumentReference each : this.myAllAffectedDocuments) {
            if (!CommandMerger.isVirtualDocumentChange(each.getFile())) continue;
            return false;
        }
        return true;
    }

    boolean isUndoAvailable(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(12);
        }
        if (this.hasNonUndoableActions()) {
            return false;
        }
        if (refs.isEmpty()) {
            return this.isGlobal() && this.hasActions();
        }
        for (DocumentReference documentReference : refs) {
            if (!this.hasChangesOf(documentReference)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonUndoableActions() {
        for (UndoableAction each : this.myCurrentActions) {
            if (!(each instanceof NonUndoableAction)) continue;
            return true;
        }
        return false;
    }

    private boolean hasChangesOf(DocumentReference ref) {
        return this.hasChangesOf(ref, false);
    }

    boolean hasChangesOf(DocumentReference ref, boolean onlyDirectChanges) {
        for (UndoableAction action2 : this.myCurrentActions) {
            Object[] refs = action2.getAffectedDocuments();
            if (!(refs == null ? !onlyDirectChanges : ArrayUtil.contains((Object)ref, (Object[])refs))) continue;
            return true;
        }
        return this.hasActions() && this.myAdditionalAffectedDocuments.contains(ref);
    }

    void setBeforeState(EditorAndState state) {
        if (this.myStateBefore == null || !this.hasActions()) {
            this.myStateBefore = state;
        }
    }

    void setAfterState(EditorAndState state) {
        this.myStateAfter = state;
    }

    void addAdditionalAffectedDocuments(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(13);
        }
        this.myAllAffectedDocuments.addAll(refs);
        this.myAdditionalAffectedDocuments.addAll(refs);
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            CommandMerger.$$$reportNull$$$0(14);
        }
        if (this.myAllAffectedDocuments.contains(ref)) {
            this.myValid = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextCommandToMerge";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacksHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextMerger";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CommandMerger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addActionToSharedStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldMerge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "clearDocumentReferences";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "refMatch";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "flushCurrentCommand";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "clearRedoStacks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoAvailable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalAffectedDocuments";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateActionsFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyEmptyUndoableAction
    extends BasicUndoableAction {
        MyEmptyUndoableAction(DocumentReference @NotNull [] refs) {
            if (refs == null) {
                MyEmptyUndoableAction.$$$reportNull$$$0(0);
            }
            super(refs);
        }

        public void undo() throws UnexpectedUndoException {
        }

        public void redo() throws UnexpectedUndoException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/openapi/command/impl/CommandMerger$MyEmptyUndoableAction", "<init>"));
        }
    }
}

